/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.impl.routing;

import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.annotation.Contract;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.annotation.Internal;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.HttpException;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.HttpRequest;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.HttpRequestMapper;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.MisdirectedRequestException;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.impl.routing.PathRoute;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.impl.routing.UriPathRouter;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.protocol.HttpContext;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.protocol.UriPatternType;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.net.URIAuthority;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestRouter<T>
implements HttpRequestMapper<T> {
    public static final URIAuthority LOCAL_AUTHORITY = new URIAuthority("localhost");
    public static final BiFunction<String, URIAuthority, URIAuthority> LOCAL_AUTHORITY_RESOLVER = (scheme, authority) -> LOCAL_AUTHORITY;
    public static final BiFunction<String, URIAuthority, URIAuthority> IGNORE_PORT_AUTHORITY_RESOLVER = (scheme, authority) -> authority != null && authority.getPort() != -1 ? new URIAuthority(authority.getHostName(), -1) : authority;
    private final Function<URIAuthority, Function<String, T>> authorityRouter;
    private final BiFunction<String, URIAuthority, URIAuthority> authorityResolver;
    private final HttpRequestMapper<T> downstream;

    @Internal
    public static <T> RequestRouter<T> create(URIAuthority primaryAuthority, UriPatternType patternType, List<Entry<T>> handlerEntries, BiFunction<String, URIAuthority, URIAuthority> authorityResolver, HttpRequestMapper<T> downstream) {
        Function<URIAuthority, Object> authorityFunction;
        Map<URIAuthority, Function> authorityMap = handlerEntries.stream().collect(Collectors.groupingBy(e -> e.uriAuthority != null ? e.uriAuthority : (primaryAuthority != null ? primaryAuthority : LOCAL_AUTHORITY), Collectors.mapping(e -> e.route, Collectors.collectingAndThen(Collectors.toList(), e -> {
            switch (patternType) {
                case URI_PATTERN: {
                    return UriPathRouter.bestMatch(e);
                }
                case URI_PATTERN_IN_ORDER: {
                    return UriPathRouter.ordered(e);
                }
                case REGEX: {
                    return UriPathRouter.regEx(e);
                }
            }
            throw new IllegalStateException("Unexpected pattern type: " + (Object)((Object)patternType));
        }))));
        if (authorityMap.isEmpty()) {
            authorityFunction = new NoAuthorityResolver<Function<String, T>>();
        } else if (authorityMap.size() == 1) {
            Map.Entry<URIAuthority, Function> entry = authorityMap.entrySet().iterator().next();
            authorityFunction = new SingleAuthorityResolver<Function>(entry.getKey(), entry.getValue());
        } else {
            authorityFunction = authorityMap::get;
        }
        return new RequestRouter<T>(authorityFunction, authorityResolver, downstream);
    }

    public static <T> Builder<T> builder(UriPatternType patternType) {
        return new Builder(patternType);
    }

    public static <T> Builder<T> builder() {
        return new Builder(UriPatternType.URI_PATTERN);
    }

    RequestRouter(Function<URIAuthority, Function<String, T>> authorityRouter, BiFunction<String, URIAuthority, URIAuthority> authorityResolver, HttpRequestMapper<T> downstream) {
        this.authorityRouter = authorityRouter;
        this.authorityResolver = authorityResolver;
        this.downstream = downstream;
    }

    @Override
    public T resolve(HttpRequest request, HttpContext context) throws HttpException {
        Function<String, String> pathRouter;
        URIAuthority authority = this.authorityResolver != null ? this.authorityResolver.apply(request.getScheme(), request.getAuthority()) : request.getAuthority();
        Function<String, String> function = pathRouter = authority != null ? this.authorityRouter.apply(authority) : null;
        if (pathRouter == null) {
            if (this.downstream != null) {
                return this.downstream.resolve(request, context);
            }
            throw new MisdirectedRequestException("Not authoritative");
        }
        String path = request.getPath();
        int i = path.indexOf(63);
        if (i != -1) {
            path = path.substring(0, i);
        }
        return pathRouter.apply(path);
    }

    public static class Builder<T> {
        private final UriPatternType patternType;
        private final List<Entry<T>> handlerEntries;
        private BiFunction<String, URIAuthority, URIAuthority> authorityResolver;
        private HttpRequestMapper<T> downstream;

        Builder(UriPatternType patternType) {
            this.patternType = patternType != null ? patternType : UriPatternType.URI_PATTERN;
            this.handlerEntries = new ArrayList<Entry<T>>();
        }

        public Builder<T> addRoute(URIAuthority authority, String pathPattern, T handler) {
            Args.notNull(authority, "URI authority");
            Args.notBlank(pathPattern, "URI path pattern");
            Args.notNull(handler, "Handler");
            this.handlerEntries.add(new Entry<T>(authority, pathPattern, handler));
            return this;
        }

        public Builder<T> addRoute(String hostname, String pathPattern, T handler) {
            Args.notBlank(hostname, "Hostname");
            Args.notBlank(pathPattern, "URI path pattern");
            Args.notNull(handler, "Handler");
            this.handlerEntries.add(new Entry<T>(hostname, pathPattern, handler));
            return this;
        }

        public Builder<T> resolveAuthority(BiFunction<String, URIAuthority, URIAuthority> authorityResolver) {
            this.authorityResolver = authorityResolver;
            return this;
        }

        public Builder<T> downstream(HttpRequestMapper<T> downstream) {
            this.downstream = downstream;
            return this;
        }

        public RequestRouter<T> build() {
            return RequestRouter.create(null, this.patternType, this.handlerEntries, this.authorityResolver, this.downstream);
        }
    }

    static class NoAuthorityResolver<T>
    implements Function<URIAuthority, T> {
        NoAuthorityResolver() {
        }

        @Override
        public T apply(URIAuthority authority) {
            return null;
        }
    }

    static class SingleAuthorityResolver<T>
    implements Function<URIAuthority, T> {
        private final URIAuthority singleAuthority;
        private final T router;

        SingleAuthorityResolver(URIAuthority singleAuthority, T router) {
            this.singleAuthority = singleAuthority;
            this.router = router;
        }

        @Override
        public T apply(URIAuthority authority) {
            return this.singleAuthority.equals(authority) ? (T)this.router : null;
        }

        public String toString() {
            return this.singleAuthority + " " + this.router;
        }
    }

    @Internal
    public static final class Entry<T> {
        public final URIAuthority uriAuthority;
        public final PathRoute<String, T> route;

        public Entry(URIAuthority uriAuthority, String pathPattern, T handler) {
            this.uriAuthority = uriAuthority;
            this.route = new PathRoute<String, String>(pathPattern, (String)handler);
        }

        public Entry(String hostname, String pathPattern, T handler) {
            this(new URIAuthority(hostname), pathPattern, handler);
        }

        public Entry(String pathPattern, T handler) {
            this((URIAuthority)null, pathPattern, handler);
        }

        public String toString() {
            return this.uriAuthority + "/" + this.route;
        }
    }
}

