/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.nio.ssl;

import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.concurrent.FutureCallback;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.HttpHost;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.URIScheme;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.nio.ssl.TlsSupport;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.net.NamedEndpoint;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.ssl.SSLContexts;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.util.Args;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.util.Timeout;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class BasicClientTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    public BasicClientTlsStrategy(SSLContext sslContext, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.sslBufferMode = sslBufferMode;
        this.initializer = initializer;
        this.verifier = verifier;
    }

    public BasicClientTlsStrategy(SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(sslContext, null, initializer, verifier);
    }

    public BasicClientTlsStrategy(SSLContext sslContext, SSLSessionVerifier verifier) {
        this(sslContext, null, null, verifier);
    }

    public BasicClientTlsStrategy(SSLContext sslContext) {
        this(sslContext, null, null, null);
    }

    public BasicClientTlsStrategy() {
        this(SSLContexts.createSystemDefault());
    }

    public BasicClientTlsStrategy(SSLSessionVerifier verifier) {
        this(SSLContexts.createSystemDefault(), verifier);
    }

    @Override
    public void upgrade(TransportSecurityLayer tlsSession, NamedEndpoint endpoint, Object attachment, Timeout handshakeTimeout, FutureCallback<TransportSecurityLayer> callback) {
        tlsSession.startTls(this.sslContext, endpoint, this.sslBufferMode, (e, sslEngine) -> {
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm(URIScheme.HTTPS.id);
            sslEngine.setSSLParameters(TlsSupport.enforceStrongSecurity(sslParameters));
            if (this.initializer != null) {
                this.initializer.initialize(e, sslEngine);
            }
        }, this.verifier, handshakeTimeout, callback);
    }

    @Override
    @Deprecated
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        String scheme;
        String string = scheme = host != null ? host.getSchemeName() : null;
        if (URIScheme.HTTPS.same(scheme)) {
            this.upgrade(tlsSession, host, attachment, handshakeTimeout, null);
            return true;
        }
        return false;
    }
}

