/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwe.kdf;

import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.base64url.Base64Url;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwe.kdf.ConcatKeyDerivationFunctionFactory;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwe.kdf.ConcatenationKeyDerivationFunctionWithSha256;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.lang.ByteUtil;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.lang.StringUtil;

public class KdfUtil {
    private Base64Url base64Url = new Base64Url();
    private ConcatenationKeyDerivationFunctionWithSha256 kdf;

    public KdfUtil() {
        this(null);
    }

    public KdfUtil(String provider) {
        this.kdf = ConcatKeyDerivationFunctionFactory.make(provider);
    }

    public byte[] kdf(byte[] sharedSecret, int keydatalen, String algorithmId, String partyUInfo, String partyVInfo) {
        byte[] algorithmIdBytes = this.prependDatalen(StringUtil.getBytesUtf8(algorithmId));
        byte[] partyUInfoBytes = this.getDatalenDataFormat(partyUInfo);
        byte[] partyVInfoBytes = this.getDatalenDataFormat(partyVInfo);
        byte[] suppPubInfo = ByteUtil.getBytes(keydatalen);
        byte[] suppPrivInfo = ByteUtil.EMPTY_BYTES;
        byte[] otherInfo = ByteUtil.concat(algorithmIdBytes, partyUInfoBytes, partyVInfoBytes, suppPubInfo, suppPrivInfo);
        return this.kdf.kdf(sharedSecret, keydatalen, otherInfo);
    }

    byte[] prependDatalen(byte[] data) {
        if (data == null) {
            data = ByteUtil.EMPTY_BYTES;
        }
        byte[] datalen = ByteUtil.getBytes(data.length);
        return ByteUtil.concat(datalen, data);
    }

    byte[] getDatalenDataFormat(String encodedValue) {
        byte[] data = this.base64Url.base64UrlDecode(encodedValue);
        return this.prependDatalen(data);
    }
}

