/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwk;

import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwk.OctetKeyPairJsonWebKey;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwk.PublicJsonWebKey;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.keys.OctetKeyPairUtil;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.lang.JoseException;
import java.security.KeyPair;
import java.security.SecureRandom;

public class OkpJwkGenerator {
    public static OctetKeyPairJsonWebKey generateJwk(String subtype) throws JoseException {
        return OkpJwkGenerator.generateJwk(subtype, null, null);
    }

    public static OctetKeyPairJsonWebKey generateJwk(String subtype, String provider, SecureRandom secureRandom) throws JoseException {
        OctetKeyPairUtil kpu = OctetKeyPairUtil.getOctetKeyPairUtil(subtype, provider, secureRandom);
        if (kpu == null) {
            throw new IllegalArgumentException("Cannot create OKP JWK. The subtype/crv \"" + subtype + "\" is unknown or unsupported.");
        }
        KeyPair kp = kpu.generateKeyPair(subtype);
        OctetKeyPairJsonWebKey okpJwk = (OctetKeyPairJsonWebKey)PublicJsonWebKey.Factory.newPublicJwk(kp.getPublic());
        okpJwk.setPrivateKey(kp.getPrivate());
        return okpJwk;
    }
}

