/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwt.consumer;

import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwt.JwtClaims;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwt.MalformedClaimException;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwt.consumer.ErrorCodeValidator;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwt.consumer.JwtContext;
import java.util.List;
import java.util.Set;

public class AudValidator
implements ErrorCodeValidator {
    private static final ErrorCodeValidator.Error MISSING_AUD = new ErrorCodeValidator.Error(7, "No Audience (aud) claim present.");
    private Set<String> acceptableAudiences;
    private boolean requireAudience;

    public AudValidator(Set<String> acceptableAudiences, boolean requireAudience) {
        this.acceptableAudiences = acceptableAudiences;
        this.requireAudience = requireAudience;
    }

    @Override
    public ErrorCodeValidator.Error validate(JwtContext jwtContext) throws MalformedClaimException {
        JwtClaims jwtClaims = jwtContext.getJwtClaims();
        if (!jwtClaims.hasAudience()) {
            return this.requireAudience ? MISSING_AUD : null;
        }
        List<String> audiences = jwtClaims.getAudience();
        boolean ok = false;
        for (String audience : audiences) {
            if (!this.acceptableAudiences.contains(audience)) continue;
            ok = true;
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder();
            sb.append("Audience (aud) claim ").append(audiences);
            if (this.acceptableAudiences.isEmpty()) {
                sb.append(" present in the JWT but no expected audience value(s) were provided to the JWT Consumer.");
            } else {
                sb.append(" doesn't contain an acceptable identifier.");
            }
            sb.append(" Expected ");
            if (this.acceptableAudiences.size() == 1) {
                sb.append(this.acceptableAudiences.iterator().next());
            } else {
                sb.append("one of ").append(this.acceptableAudiences);
            }
            sb.append(" as an aud value.");
            return new ErrorCodeValidator.Error(8, sb.toString());
        }
        return null;
    }
}

