/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.validator;

import com.pingidentity.adapters.pingone.verify.config.AdapterConfiguration;
import com.pingidentity.adapters.pingone.verify.config.UiConfig;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class ProxyConfigurationValidator
implements ConfigurationValidator {
    public void validate(Configuration configuration) throws ValidationException {
        String proxySettings = AdapterConfiguration.getStringValue(configuration, UiConfig.PROXY_SETTINGS);
        if ("Custom".equals(proxySettings)) {
            String proxyHost = AdapterConfiguration.getStringValue(configuration, UiConfig.PROXY_HOST);
            int proxyPort = AdapterConfiguration.getIntValue(configuration, UiConfig.PROXY_PORT);
            if (StringUtils.isBlank(proxyHost) && proxyPort == 0) {
                throw new ValidationException("'" + UiConfig.PROXY_HOST.field + "' and '" + UiConfig.PROXY_PORT.field + "' are required if the proxy mode is '" + "Custom" + "'.");
            }
            if (StringUtils.isBlank(proxyHost)) {
                throw new ValidationException("'" + UiConfig.PROXY_HOST.field + "' is required if the proxy mode is '" + "Custom" + "'.");
            }
            if (proxyPort == 0) {
                throw new ValidationException("'" + UiConfig.PROXY_PORT.field + "' is required if the proxy mode is '" + "Custom" + "'.");
            }
        }
    }
}

