/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.rest.oauth.clientregistration.error.handler;

import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientPaths;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.sdk.oauth20.registration.ClientRegistrationException;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClientErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(DynamicClientErrorHandler.class);
    private final Validator validator;

    public DynamicClientErrorHandler(Validator validator) {
        this.validator = validator;
    }

    public void handle() throws ClientRegistrationException {
        if (this.validator.hasErrors()) {
            String errorDescription;
            List errors = this.validator.getErrors();
            ClientRegistrationException.ErrorCode errorCode = ClientRegistrationException.ErrorCode.invalid_client_metadata;
            if (errors.size() == 1) {
                ValidationError error = (ValidationError)errors.iterator().next();
                if (error.getFieldPath() != null && error.getFieldPath().contains(ClientPaths.getRedirectUris())) {
                    errorCode = ClientRegistrationException.ErrorCode.invalid_redirect_uri;
                }
                errorDescription = error.getMessage();
            } else {
                StringBuilder descriptions = new StringBuilder();
                for (ValidationError error : errors) {
                    descriptions.append(error.getMessage()).append(System.lineSeparator());
                }
                errorDescription = descriptions.toString();
            }
            logger.error("Dynamic client registration validation failed.");
            logger.debug("\tError Code : {}", (Object)errorCode);
            logger.debug("\tError Description : {}", (Object)errorDescription);
            throw new ClientRegistrationException(Response.Status.BAD_REQUEST, errorCode, errorDescription);
        }
    }
}

