/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.rest.oauth.clientregistration.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.servlet.filter.AbstractHttpFilter;

public class OAuthClientSettingEnabledFilter
extends AbstractHttpFilter {
    private static final Log log = LogFactory.getLog(OAuthClientSettingEnabledFilter.class);

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        if (!clientSetting.isEnableDynamicClientRegistration() || !MgmtFactory.getClientManager().isBackendDatabase()) {
            this.sendErrorResponse(request, response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.info((Object)("OAuth Dynamic Client Registration service endpoint Attempted: service=" + request.getRequestURI() + ", remote-ip=" + request.getRemoteAddr() + ", but the dynamic client registration is not enabled or backend client management database is not enabled. Consult product documentation for config changes required to enable service."));
        response.sendError(404);
    }
}

