/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.rest.oauth.clientregistration.parser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeUnit;
import com.pingidentity.admin.api.model.oauth.RefreshRollingType;
import com.pingidentity.admin.api.model.oauth.RefreshTokenRollingIntervalTimeUnit;
import com.pingidentity.rest.oauth.clientregistration.parser.DynamicClientParser;
import com.pingidentity.sdk.oauth20.registration.ClientAuthType;
import com.pingidentity.sdk.oauth20.registration.ClientRegistrationException;
import com.pingidentity.sdk.oauth20.registration.DynamicClientFields;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.domain.ClientParam;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.oauth20.domain.ClientUtil;
import org.sourceid.oauth20.domain.DynamicOAuthClient;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.openid.ciba.CibaDeliveryMode;
import org.sourceid.openid.connect.domain.ClientRegistrationCoreParameters;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.ObjectMapperFactory;

public class DynamicClientJsonParser
implements DynamicClientParser {
    private static final Logger log = LoggerFactory.getLogger(DynamicClientJsonParser.class);
    private static final OpenIdConnectProviderPolicyManager POLICY_MGR = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
    private static final ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapper();
    private final ClientSettingManager clientSettingManager = MgmtFactory.getClientSettingManager();
    private final OAuthIssuerUtils oAuthIssuerUtils = OAuthIssuerUtils.getInstance();
    private ClientAuthType requestedTokenEndpointAuthMethod;

    public DynamicOAuthClient parse(JsonNode clientRequestJson, boolean isUpdate) throws ClientRegistrationException {
        Iterator jsonFields = clientRequestJson.fields();
        Set<String> metadataParamNames = this.getMetadataParamNames();
        DynamicOAuthClient client = new DynamicOAuthClient();
        HashSet<String> fieldNames = DynamicClientJsonParser.getFieldNames();
        HashSet<String> unacceptableFields = DynamicClientJsonParser.getUnacceptableFields();
        HashMap<String, ParamValues> extendedParams = new HashMap<String, ParamValues>();
        while (jsonFields.hasNext()) {
            Map.Entry field = (Map.Entry)jsonFields.next();
            String fieldName = (String)field.getKey();
            JsonNode fieldJsonValue = (JsonNode)field.getValue();
            if (fieldNames.contains(fieldName) && !(fieldJsonValue instanceof NullNode)) {
                DynamicClientFields dynamicField = DynamicClientFields.valueOf((String)fieldName.toUpperCase());
                this.fillClientCoreField(dynamicField, fieldJsonValue, client, isUpdate);
                continue;
            }
            if (metadataParamNames.contains(fieldName) && !(fieldJsonValue instanceof NullNode)) {
                List<String> values = this.getValueAsList(fieldJsonValue);
                ParamValues paramValues = new ParamValues();
                paramValues.setElements(values);
                extendedParams.put(fieldName, paramValues);
                continue;
            }
            if (!unacceptableFields.contains(fieldName)) continue;
            String message = "The request must not include the fields \"registration_access_token\", \"registration_client_uri\", \"client_secret_expires_at\", or \"client_id_issued_at\".";
            log.error(message);
            throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, message);
        }
        if (StringUtils.isNotBlank((String)client.getIdTokenEncryptionAlgorithm()) && StringUtils.isBlank((String)client.getIdTokenContentEncryptionAlgorithm())) {
            client.setIdTokenContentEncryptionAlgorithm(client.getIdTokenContentEncryptionAlgorithm(true));
        }
        if (StringUtils.isNotBlank((String)client.getIntrospectionEncryptionAlgorithm()) && StringUtils.isBlank((String)client.getIntrospectionContentEncryptionAlgorithm())) {
            client.setIntrospectionContentEncryptionAlgorithm("A128CBC-HS256");
        }
        if (StringUtils.isNotBlank((String)client.getAuthorizationResponseEncryptionAlgorithm()) && StringUtils.isBlank((String)client.getAuthorizationResponseContentEncryptionAlgorithm())) {
            client.setAuthorizationResponseContentEncryptionAlgorithm("A128CBC-HS256");
        }
        client.setExtendedParams(extendedParams);
        return client;
    }

    @Override
    public JsonNode compose(DynamicOAuthClient client, HttpServletRequest req) {
        ObjectNode response = objectMapper.createObjectNode();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        response.put("client_id", client.getClientId());
        for (DynamicClientFields value : DynamicClientFields.values()) {
            this.fillClientJsonField(value, response, client);
        }
        response.put("validate_using_all_eligible_atms", client.isValidateUsingAllEligibleAtms());
        if (client.getExtendedParams() != null) {
            Map metadataParams = this.clientSettingManager.getClientSetting().getExtendedMetadataParams();
            for (Map.Entry param : client.getExtendedParams().entrySet()) {
                String name = (String)param.getKey();
                List paramValues = ((ParamValues)param.getValue()).getElements();
                if (((ClientParam)metadataParams.get(name)).isMultiValued()) {
                    if (paramValues == null || paramValues.isEmpty()) continue;
                    response.set(name, objectMapper.valueToTree((Object)paramValues));
                    continue;
                }
                if (!paramValues.iterator().hasNext()) continue;
                String value = (String)paramValues.iterator().next();
                response.put(name, value);
            }
        }
        if (client.getClientCertIssuerDn() != null) {
            response.put("tls_client_auth_root_dn", client.getClientCertIssuerDn());
        }
        if (StringUtils.isNotBlank((String)client.getDefaultAccessTokenManagerId())) {
            response.put("default_access_token_manager_id", client.getDefaultAccessTokenManagerId());
        }
        response.put("restrict_to_default_access_token_manager", client.isRestrictToDefaultAccessTokenManager());
        RefreshRollingType apiRollingType = RefreshRollingType.getType((String)client.getRefreshRolling());
        if (apiRollingType != null) {
            response.put("refresh_token_rolling_policy", apiRollingType.name().toLowerCase());
        }
        if (client.getRefreshTokenRollingIntervalType() != null) {
            response.put("refresh_token_rolling_interval_type", client.getRefreshTokenRollingIntervalType());
        }
        if (client.getRefreshTokenRollingInterval() != null) {
            response.put("refresh_token_rolling_interval", Long.toString(client.getRefreshTokenRollingInterval()));
            String refreshTokenRollingIntervalTimeUnit = client.getRefreshTokenRollingIntervalTimeUnit() == null ? "h" : client.getRefreshTokenRollingIntervalTimeUnit();
            response.put("refresh_token_rolling_interval_unit", RefreshTokenRollingIntervalTimeUnit.getType((String)refreshTokenRollingIntervalTimeUnit).toString().toLowerCase());
        }
        PersistentGrantLifetimeType apiPersistentType = PersistentGrantLifetimeType.getType((String)client.getPersistentGrantExpirationType());
        response.put("persistent_grant_expiration_type", apiPersistentType.toString().toLowerCase());
        if (client.getPersistentGrantExpirationTime() > 0L) {
            response.put("persistent_grant_expiration_time", client.getPersistentGrantExpirationTime());
            response.put("persistent_grant_expiration_time_unit", PersistentGrantLifetimeUnit.getType((String)client.getPersistentGrantExpirationTimeUnit()).toString().toLowerCase());
        }
        PersistentGrantLifetimeType apiPersistentIdleTimeoutType = PersistentGrantLifetimeType.getType((String)client.getPersistentGrantIdleTimeoutType());
        response.put("persistent_grant_idle_timeout_type", apiPersistentIdleTimeoutType.toString().toLowerCase());
        if (client.getPersistentGrantIdleTimeout() > 0L) {
            response.put("persistent_grant_idle_timeout", client.getPersistentGrantIdleTimeout());
            response.put("persistent_grant_idle_timeout_unit", PersistentGrantLifetimeUnit.getType((String)client.getPersistentGrantIdleTimeoutTimeUnit()).toString().toLowerCase());
        }
        if (POLICY_MGR.getPolicy().isEnabled()) {
            if (StringUtils.isNotBlank((String)client.getPolicyGroupId())) {
                response.put("policy_group_id", client.getPolicyGroupId());
            }
            response.put("grant_access_session_revocation_api", client.isGrantAccessSessionRevocationApi());
            response.put("grant_access_session_management_api", client.isGrantAccessSessionManagementApi());
            if (POLICY_MGR.getPolicy().isTrackUserSessionsForLogout()) {
                response.put("pingaccess_logout_capable", client.isPingAccessLogoutCapable() && client.getLogoutMode() == ClientLogoutMode.PING_FRONT_CHANNEL);
            }
        }
        if (StringUtils.isNotBlank((String)client.getSoftwareStatement())) {
            response.put("software_statement", client.getSoftwareStatement());
        }
        if (StringUtils.isNotBlank((String)client.getDeviceFlowSettingType())) {
            response.put("device_flow_setting_type", client.getDeviceFlowSettingType());
        }
        if (StringUtils.isNotBlank((String)client.getUserAuthzUrlOverride())) {
            response.put("user_authorization_url_override", client.getUserAuthzUrlOverride());
        }
        if (StringUtils.isNotBlank((String)client.getPendingAuthzTimeoutOverride())) {
            response.put("pending_authorization_timeout_override", Integer.parseInt(client.getPendingAuthzTimeoutOverride()));
        }
        if (StringUtils.isNotBlank((String)client.getDevicePollingIntervalOverride())) {
            response.put("device_polling_interval_override", Integer.parseInt(client.getDevicePollingIntervalOverride()));
        }
        if (client.getBypassActivationCodeConfirmationOverride() != null) {
            response.put("bypass_activation_code_confirmation_override", client.getBypassActivationCodeConfirmationOverride());
        }
        response.put("require_proof_key_for_code_exchange", client.isRequireProofKeyForCodeExchange());
        if (StringUtils.isNotBlank((String)client.getTokenExchangeProcessorPolicyId())) {
            response.put("token_exchange_processor_policy_id", client.getTokenExchangeProcessorPolicyId());
        }
        this.addToResponseIfNotBlank("refresh_token_rolling_grace_period_type", client.getRefreshTokenRollingGracePeriodType(), response);
        this.addToResponseIfNotBlank("refresh_token_rolling_grace_period", client.getRefreshTokenRollingGracePeriod(), response);
        response.put("require_jwt_secured_authorization_response_mode", client.isRequireJwtSecuredAuthorizationResponseMode());
        response.put("require_offline_access_scope_to_issue_refresh_tokens", client.getRequireOfflineAccessScopeToIssueRefreshTokens());
        response.put("offline_access_require_consent_prompt", client.getOfflineAccessRequireConsentPrompt());
        if (client.getLockoutMaxMaliciousActionsType() != null) {
            response.put("lockout_max_malicious_actions_type", client.getLockoutMaxMaliciousActionsType());
        }
        if (client.getLockoutMaxMaliciousActions() != null) {
            response.put("lockout_max_malicious_actions", Integer.toString(client.getLockoutMaxMaliciousActions()));
        }
        if (this.clientSettingManager.getClientSetting().isEnableDynamicClientRegistrationManagement()) {
            if (client.getRegistrationAccessToken() != null) {
                response.put("registration_access_token", client.getRegistrationAccessToken().getSecret());
            }
            String currentBaseUrl = this.oAuthIssuerUtils.getIssuerValue(req);
            String registrationClientUri = currentBaseUrl + "/as/clients.oauth2/" + client.getClientId();
            response.put("registration_client_uri", registrationClientUri);
        }
        return response;
    }

    private ClientAuthType getRequestedTokenEndpointAuthMethod() {
        return this.requestedTokenEndpointAuthMethod;
    }

    private static HashSet<String> getFieldNames() {
        HashSet<String> values = new HashSet<String>();
        for (DynamicClientFields c : DynamicClientFields.values()) {
            values.add(c.getName());
        }
        return values;
    }

    private static HashSet<String> getUnacceptableFields() {
        HashSet<String> values = new HashSet<String>();
        values.add(ClientRegistrationCoreParameters.REGISTRATION_ACCESS_TOKEN.getName());
        values.add(ClientRegistrationCoreParameters.REGISTRATION_CLIENT_URI.getName());
        values.add(ClientRegistrationCoreParameters.CLIENT_ID_ISSUED_AT.getName());
        values.add(ClientRegistrationCoreParameters.CLIENT_SECRET_EXPIRES_AT.getName());
        return values;
    }

    private void fillClientCoreField(DynamicClientFields dynamicField, JsonNode fieldJsonValue, DynamicOAuthClient client, boolean isUpdate) throws ClientRegistrationException {
        switch (dynamicField) {
            case REDIRECT_URIS: {
                this.setRedirectUris((Client)client, fieldJsonValue);
                break;
            }
            case TOKEN_ENDPOINT_AUTH_METHOD: {
                this.setTokenEndpointAuthMethod((Client)client, fieldJsonValue);
                break;
            }
            case TLS_CLIENT_AUTH_SUBJECT_DN: {
                this.setTlsClientAuthSubjectDn((Client)client, fieldJsonValue);
                break;
            }
            case ID_TOKEN_SIGNED_RESPONSE_ALG: {
                this.setIdTokenSignedResponseAlgo((Client)client, fieldJsonValue);
                break;
            }
            case ID_TOKEN_ENCRYPTED_RESPONSE_ALG: {
                this.setIdTokenEncryptedResponseAlg((Client)client, fieldJsonValue);
                break;
            }
            case ID_TOKEN_ENCRYPTED_RESPONSE_ENC: {
                this.setIdTokenEncryptedResponseEnc((Client)client, fieldJsonValue);
                break;
            }
            case INTROSPECTION_SIGNED_RESPONSE_ALG: {
                this.setIntrospectionSigningAlgorithm((Client)client, fieldJsonValue);
                break;
            }
            case INTROSPECTION_ENCRYPTED_RESPONSE_ALG: {
                this.setIntrospectionEncryptionAlgorithm((Client)client, fieldJsonValue);
                break;
            }
            case INTROSPECTION_ENCRYPTED_RESPONSE_ENC: {
                this.setIntrospectionContentEncryptionAlgorithm((Client)client, fieldJsonValue);
                break;
            }
            case AUTHORIZATION_SIGNED_RESPONSE_ALG: {
                this.setAuthorizationSignedResponseAlgorithm((Client)client, fieldJsonValue);
                break;
            }
            case AUTHORIZATION_ENCRYPTED_RESPONSE_ALG: {
                this.setAuthorizationResponseEncryptionAlgorithm((Client)client, fieldJsonValue);
                break;
            }
            case AUTHORIZATION_ENCRYPTED_RESPONSE_ENC: {
                this.setAuthorizationResponseContentEncryptionAlgorithm((Client)client, fieldJsonValue);
                break;
            }
            case USERINFO_SIGNED_RESPONSE_ALG: {
                this.setUserInfoResponseSigningAlgorithm((Client)client, fieldJsonValue);
                break;
            }
            case USERINFO_ENCRYPTED_RESPONSE_ALG: {
                this.setUserInfoResponseEncryptionAlgorithm((Client)client, fieldJsonValue);
                break;
            }
            case USERINFO_ENCRYPTED_RESPONSE_ENC: {
                this.setUserInfoResponseContentEncryptionAlgorithm((Client)client, fieldJsonValue);
                break;
            }
            case GRANT_TYPES: {
                this.setGrantTypes((Client)client, fieldJsonValue);
                break;
            }
            case CLIENT_ID: {
                if (!isUpdate) break;
                this.setClientId((Client)client, fieldJsonValue);
                break;
            }
            case CLIENT_SECRET: {
                if (!isUpdate) break;
                this.setSecret((Client)client, fieldJsonValue);
                break;
            }
            case CLIENT_NAME: {
                this.setClientName((Client)client, fieldJsonValue);
                break;
            }
            case LOGO_URI: {
                this.setLogoUri((Client)client, fieldJsonValue);
                break;
            }
            case SCOPE: {
                this.setScope((Client)client, fieldJsonValue);
                break;
            }
            case AUTHORIZATION_DETAILS_TYPES: {
                this.setAuthorizationDetailTypes((Client)client, fieldJsonValue);
                break;
            }
            case JWKS_URI: {
                this.setJwksUri((Client)client, fieldJsonValue);
                break;
            }
            case JWKS: {
                this.setJwks((Client)client, fieldJsonValue);
                break;
            }
            case SOFTWARE_STATEMENT: {
                this.setSoftwareStatement((Client)client, fieldJsonValue);
                break;
            }
            case RESPONSE_TYPES: {
                this.setResponseTypes((Client)client, fieldJsonValue);
                break;
            }
            case REQUEST_OBJECT_SIGNING_ALG: {
                client.setRequestObjectSigningAlgorithm(fieldJsonValue.asText());
                break;
            }
            case TOKEN_ENDPOINT_AUTH_SIGNING_ALG: {
                client.setTokenEndpointAuthSigningAlgorithm(fieldJsonValue.asText());
                break;
            }
            case BACKCHANNEL_TOKEN_DELIVERY_MODE: {
                this.setBackchannelTokenDeliveryMode((Client)client, fieldJsonValue);
                break;
            }
            case BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT: {
                this.setBackchannelClientNotificationEndpoint((Client)client, fieldJsonValue);
                break;
            }
            case BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG: {
                client.setCibaRequestObjectSigningAlgorithm(fieldJsonValue.asText());
                break;
            }
            case BACKCHANNEL_USER_CODE_PARAMETER: {
                this.setBackchannelUserCodeParameter((Client)client, fieldJsonValue);
                break;
            }
            case SUBJECT_TYPE: {
                this.setSubectType((Client)client, fieldJsonValue);
                break;
            }
            case SECTOR_IDENTIFIER_URI: {
                this.setSectorIdentifierUri((Client)client, fieldJsonValue);
                break;
            }
            case REQUIRE_PUSHED_AUTHORIZATION_REQUESTS: {
                client.setRequirePushedAuthorizationRequests(fieldJsonValue.asBoolean(false));
                break;
            }
            case BACKCHANNEL_LOGOUT_URI: {
                client.setBackChannelLogoutUri(fieldJsonValue.asText());
                break;
            }
            case FRONTCHANNEL_LOGOUT_URI: {
                client.setFrontChannelLogoutUri(fieldJsonValue.asText());
                break;
            }
            case POST_LOGOUT_REDIRECT_URIS: {
                this.setPostLogoutRedirectUris((Client)client, fieldJsonValue);
                break;
            }
            case CLIENT_DESCRIPTION: {
                this.setClientDescription((Client)client, fieldJsonValue);
                break;
            }
            case DPOP_BOUND_ACCESS_TOKENS: {
                client.setRequireDpop(fieldJsonValue.asBoolean(false));
                break;
            }
        }
    }

    private void fillClientJsonField(DynamicClientFields dynamicField, ObjectNode fieldJsonValue, DynamicOAuthClient client) {
        switch (dynamicField) {
            case REDIRECT_URIS: {
                if (client.getRedirectUris() == null || client.getRedirectUris().size() <= 0) break;
                fieldJsonValue.set(DynamicClientFields.REDIRECT_URIS.getName(), objectMapper.valueToTree((Object)client.getRedirectUris()));
                break;
            }
            case TOKEN_ENDPOINT_AUTH_METHOD: {
                String tokenEndpointAuthMethod = client.getClientAuthenticationType();
                if (this.getRequestedTokenEndpointAuthMethod() == ClientAuthType.client_secret_post) {
                    tokenEndpointAuthMethod = ClientAuthType.client_secret_post.name();
                }
                fieldJsonValue.put(DynamicClientFields.TOKEN_ENDPOINT_AUTH_METHOD.getName(), tokenEndpointAuthMethod);
                if (client.getClientAuthnType() != ClientAuthenticationType.PRIVATE_KEY_JWT && client.getClientAuthnType() != ClientAuthenticationType.CLIENT_SECRET_JWT) break;
                fieldJsonValue.put("jwt_replay_prevention", client.isEnforceReplayPrevention());
                break;
            }
            case TLS_CLIENT_AUTH_SUBJECT_DN: {
                if (client.getClientCertSubjectDn() == null) break;
                fieldJsonValue.put(DynamicClientFields.TLS_CLIENT_AUTH_SUBJECT_DN.getName(), client.getClientCertSubjectDn());
                break;
            }
            case ID_TOKEN_SIGNED_RESPONSE_ALG: {
                if (!POLICY_MGR.getPolicy().isEnabled() || !StringUtils.isNotBlank((String)client.getIdTokenSigningAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.ID_TOKEN_SIGNED_RESPONSE_ALG.getName(), client.getIdTokenSigningAlgorithm());
                break;
            }
            case ID_TOKEN_ENCRYPTED_RESPONSE_ALG: {
                if (client.getIdTokenEncryptionAlgorithm() == null) break;
                fieldJsonValue.put(DynamicClientFields.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.getName(), client.getIdTokenEncryptionAlgorithm());
                break;
            }
            case ID_TOKEN_ENCRYPTED_RESPONSE_ENC: {
                if (client.getIdTokenEncryptionAlgorithm() == null) break;
                fieldJsonValue.put(DynamicClientFields.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.getName(), client.getIdTokenContentEncryptionAlgorithm());
                break;
            }
            case INTROSPECTION_SIGNED_RESPONSE_ALG: {
                if (!StringUtils.isNotBlank((String)client.getIntrospectionSigningAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.INTROSPECTION_SIGNED_RESPONSE_ALG.getName(), client.getIntrospectionSigningAlgorithm());
                break;
            }
            case INTROSPECTION_ENCRYPTED_RESPONSE_ALG: {
                if (!StringUtils.isNotBlank((String)client.getIntrospectionEncryptionAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.INTROSPECTION_ENCRYPTED_RESPONSE_ALG.getName(), client.getIntrospectionEncryptionAlgorithm());
                break;
            }
            case INTROSPECTION_ENCRYPTED_RESPONSE_ENC: {
                if (!StringUtils.isNotBlank((String)client.getIntrospectionContentEncryptionAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.INTROSPECTION_ENCRYPTED_RESPONSE_ENC.getName(), client.getIntrospectionContentEncryptionAlgorithm());
                break;
            }
            case AUTHORIZATION_SIGNED_RESPONSE_ALG: {
                this.addFieldToObjectNode(fieldJsonValue, DynamicClientFields.AUTHORIZATION_SIGNED_RESPONSE_ALG, client.getAuthorizationResponseSigningAlgorithm());
                break;
            }
            case AUTHORIZATION_ENCRYPTED_RESPONSE_ALG: {
                this.addFieldToObjectNode(fieldJsonValue, DynamicClientFields.AUTHORIZATION_ENCRYPTED_RESPONSE_ALG, client.getAuthorizationResponseEncryptionAlgorithm());
                break;
            }
            case AUTHORIZATION_ENCRYPTED_RESPONSE_ENC: {
                this.addFieldToObjectNode(fieldJsonValue, DynamicClientFields.AUTHORIZATION_ENCRYPTED_RESPONSE_ENC, client.getAuthorizationResponseContentEncryptionAlgorithm());
                break;
            }
            case GRANT_TYPES: {
                fieldJsonValue.set(DynamicClientFields.GRANT_TYPES.getName(), objectMapper.valueToTree((Object)client.getGrantTypes()));
                break;
            }
            case CLIENT_NAME: {
                fieldJsonValue.put(DynamicClientFields.CLIENT_NAME.getName(), client.getName());
                break;
            }
            case CLIENT_SECRET: {
                if (client.getClientAuthnType() != ClientAuthenticationType.SECRET && !client.needReversibleSecret()) break;
                fieldJsonValue.put(DynamicClientFields.CLIENT_SECRET.getName(), client.getSecret() != null ? client.getSecret() : client.getReversableSecretAsString());
                fieldJsonValue.put("client_secret_expires_at", 0);
                break;
            }
            case LOGO_URI: {
                if (client.getLogoUrl() == null) break;
                fieldJsonValue.put(DynamicClientFields.LOGO_URI.getName(), client.getLogoUrl());
                break;
            }
            case SCOPE: {
                fieldJsonValue.set(DynamicClientFields.SCOPE.getName(), objectMapper.valueToTree((Object)ScopeUtil.getSupportedLocalScope((Client)client).getScopeStr()));
                break;
            }
            case AUTHORIZATION_DETAILS_TYPES: {
                fieldJsonValue.set(DynamicClientFields.AUTHORIZATION_DETAILS_TYPES.getName(), objectMapper.valueToTree((Object)client.getAllowedAuthorizationDetailsTypes()));
                break;
            }
            case JWKS_URI: {
                if (client.getJwksUrl() == null) break;
                fieldJsonValue.put(DynamicClientFields.JWKS_URI.getName(), client.getJwksUrl());
                break;
            }
            case JWKS: {
                if (client.getJwks() == null) break;
                try {
                    JsonNode jsonNode = (JsonNode)objectMapper.readValue(client.getJwks(), JsonNode.class);
                    fieldJsonValue.set(DynamicClientFields.JWKS.getName(), jsonNode);
                }
                catch (IOException e) {
                    String message = "JWKS value is not a valid JSON";
                    log.error(message + ", " + e.getMessage());
                    log.debug(message, (Throwable)e);
                }
                break;
            }
            case RESPONSE_TYPES: {
                if (!client.isRestrictResponseTypes() || client.getRestrictedResponseTypes() == null || client.getRestrictedResponseTypes().size() <= 0) break;
                fieldJsonValue.set(DynamicClientFields.RESPONSE_TYPES.getName(), objectMapper.valueToTree((Object)client.getRestrictedResponseTypes()));
                break;
            }
            case REQUEST_OBJECT_SIGNING_ALG: {
                if (!StringUtils.isNotBlank((String)client.getRequestObjectSigningAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.REQUEST_OBJECT_SIGNING_ALG.getName(), client.getRequestObjectSigningAlgorithm());
                break;
            }
            case TOKEN_ENDPOINT_AUTH_SIGNING_ALG: {
                if (!StringUtils.isNotBlank((String)client.getTokenEndpointAuthSigningAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.getName(), client.getTokenEndpointAuthSigningAlgorithm());
                break;
            }
            case BACKCHANNEL_TOKEN_DELIVERY_MODE: {
                if (client.getCibaTokenDeliveryMode() == null) break;
                fieldJsonValue.put(DynamicClientFields.BACKCHANNEL_TOKEN_DELIVERY_MODE.getName(), client.getCibaTokenDeliveryMode().toString());
                break;
            }
            case BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT: {
                if (client.getCibaNotificationEndpoint() == null) break;
                fieldJsonValue.put(DynamicClientFields.BACKCHANNEL_CLIENT_NOTIFICATION_ENDPOINT.getName(), client.getCibaNotificationEndpoint());
                break;
            }
            case BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG: {
                if (!StringUtils.isNotBlank((String)client.getCibaRequestObjectSigningAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG.getName(), client.getCibaRequestObjectSigningAlgorithm());
                break;
            }
            case BACKCHANNEL_USER_CODE_PARAMETER: {
                if (client.isCibaUserCodeSupported() == null) break;
                fieldJsonValue.put(DynamicClientFields.BACKCHANNEL_USER_CODE_PARAMETER.getName(), client.isCibaUserCodeSupported().booleanValue());
                break;
            }
            case SUBJECT_TYPE: {
                String subjectType = client.isPairwiseUserType() ? "pairwise" : "public";
                fieldJsonValue.put(DynamicClientFields.SUBJECT_TYPE.getName(), subjectType);
                break;
            }
            case SECTOR_IDENTIFIER_URI: {
                if (client.getSectorIdentifierUri() == null) break;
                fieldJsonValue.put(DynamicClientFields.SECTOR_IDENTIFIER_URI.getName(), client.getSectorIdentifierUri());
                break;
            }
            case REQUIRE_PUSHED_AUTHORIZATION_REQUESTS: {
                boolean requirePar = client.isRequirePushedAuthorizationRequests();
                if (!requirePar) break;
                fieldJsonValue.put(DynamicClientFields.REQUIRE_PUSHED_AUTHORIZATION_REQUESTS.getName(), requirePar);
                break;
            }
            case BACKCHANNEL_LOGOUT_URI: {
                if (client.getLogoutMode() != ClientLogoutMode.OIDC_BACK_CHANNEL) break;
                fieldJsonValue.put(DynamicClientFields.BACKCHANNEL_LOGOUT_URI.getName(), client.getBackChannelLogoutUri());
                break;
            }
            case FRONTCHANNEL_LOGOUT_URI: {
                if (client.getFrontChannelLogoutUri() == null) break;
                fieldJsonValue.put(DynamicClientFields.FRONTCHANNEL_LOGOUT_URI.getName(), client.getFrontChannelLogoutUri());
                break;
            }
            case POST_LOGOUT_REDIRECT_URIS: {
                if (client.getPostLogoutRedirectUris() == null || client.getPostLogoutRedirectUris().isEmpty()) break;
                fieldJsonValue.set(DynamicClientFields.POST_LOGOUT_REDIRECT_URIS.getName(), objectMapper.valueToTree((Object)client.getPostLogoutRedirectUris()));
                break;
            }
            case CLIENT_DESCRIPTION: {
                fieldJsonValue.put(DynamicClientFields.CLIENT_DESCRIPTION.getName(), client.getDescription());
                break;
            }
            case DPOP_BOUND_ACCESS_TOKENS: {
                fieldJsonValue.put(DynamicClientFields.DPOP_BOUND_ACCESS_TOKENS.getName(), client.isRequireDpop());
                break;
            }
            case USERINFO_SIGNED_RESPONSE_ALG: {
                if (!StringUtils.isNotBlank((String)client.getUserInfoResponseSigningAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.USERINFO_SIGNED_RESPONSE_ALG.getName(), client.getUserInfoResponseSigningAlgorithm());
                break;
            }
            case USERINFO_ENCRYPTED_RESPONSE_ALG: {
                if (!StringUtils.isNotBlank((String)client.getUserInfoResponseEncryptionAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.USERINFO_ENCRYPTED_RESPONSE_ALG.getName(), client.getUserInfoResponseEncryptionAlgorithm());
                break;
            }
            case USERINFO_ENCRYPTED_RESPONSE_ENC: {
                if (!StringUtils.isNotBlank((String)client.getUserInfoResponseContentEncryptionAlgorithm())) break;
                fieldJsonValue.put(DynamicClientFields.USERINFO_ENCRYPTED_RESPONSE_ENC.getName(), client.getUserInfoResponseContentEncryptionAlgorithm());
                break;
            }
        }
    }

    private Set<String> getMetadataParamNames() {
        HashMap metadataParams = this.clientSettingManager.getClientSetting().getExtendedMetadataParams();
        if (metadataParams == null) {
            metadataParams = new HashMap();
        }
        return metadataParams.keySet();
    }

    private List<String> getValueAsList(JsonNode node) {
        ArrayList<String> values = new ArrayList<String>();
        if (node.isArray()) {
            for (JsonNode uriNode : node) {
                values.add(uriNode.asText());
            }
        } else {
            values.add(node.asText());
        }
        return values;
    }

    private void setRedirectUris(Client client, JsonNode redirectUrisNode) {
        List<String> redirectUri = this.getValueAsList(redirectUrisNode);
        client.setRedirectUris(redirectUri);
    }

    private void setPostLogoutRedirectUris(Client client, JsonNode redirectUrisNode) {
        List<String> redirectUris = this.getValueAsList(redirectUrisNode);
        client.setPostLogoutRedirectUris(redirectUris);
    }

    private void setTokenEndpointAuthMethod(Client client, JsonNode tokenEndpointAuthMethodNode) throws ClientRegistrationException {
        String clientAuthnType = tokenEndpointAuthMethodNode.asText();
        if (clientAuthnType == null || clientAuthnType.isEmpty()) {
            client.setClientAuthnType(ClientAuthenticationType.SECRET);
        } else {
            try {
                this.requestedTokenEndpointAuthMethod = ClientAuthType.valueOf((String)clientAuthnType.toLowerCase());
                client.setClientAuthnType(this.requestedTokenEndpointAuthMethod.getDomainClientAuthnType());
            }
            catch (IllegalArgumentException e) {
                String msg = String.format("Invalid Token Endpoint Authentication Method '%s'.", clientAuthnType);
                throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, msg);
            }
        }
    }

    private void setTlsClientAuthSubjectDn(Client client, JsonNode tlsClientAuthSubjectDnNode) {
        client.setClientCertSubjectDn(tlsClientAuthSubjectDnNode.asText());
    }

    private void setTlsClientAuthRootDn(Client client, JsonNode tlsClientAuthRootDnNode) {
        client.setClientCertIssuerDn(tlsClientAuthRootDnNode.asText());
    }

    private void setIdTokenSignedResponseAlgo(Client client, JsonNode idTokenSignedResponseAlgoNode) {
        client.setIdTokenSigningAlgorithm(idTokenSignedResponseAlgoNode.asText());
    }

    private void setIdTokenEncryptedResponseAlg(Client client, JsonNode idTokenEncryptionAlg) {
        client.setIdTokenEncryptionAlgorithm(idTokenEncryptionAlg.asText());
    }

    private void setIntrospectionSigningAlgorithm(Client client, JsonNode fieldJsonValue) {
        client.setIntrospectionSigningAlgorithm(fieldJsonValue.asText());
    }

    private void setIntrospectionEncryptionAlgorithm(Client client, JsonNode fieldJsonValue) {
        client.setIntrospectionEncryptionAlgorithm(fieldJsonValue.asText());
    }

    private void setIntrospectionContentEncryptionAlgorithm(Client client, JsonNode fieldJsonValue) {
        client.setIntrospectionContentEncryptionAlgorithm(fieldJsonValue.asText());
    }

    private void setAuthorizationSignedResponseAlgorithm(Client client, JsonNode fieldJsonValue) {
        client.setAuthorizationResponseSigningAlgorithm(fieldJsonValue.asText());
    }

    private void setAuthorizationResponseEncryptionAlgorithm(Client client, JsonNode fieldJsonValue) {
        client.setAuthorizationResponseEncryptionAlgorithm(fieldJsonValue.asText());
    }

    private void setAuthorizationResponseContentEncryptionAlgorithm(Client client, JsonNode fieldJsonValue) {
        client.setAuthorizationResponseContentEncryptionAlgorithm(fieldJsonValue.asText());
    }

    private void setIdTokenEncryptedResponseEnc(Client client, JsonNode idTokenEncryptedResponseEnc) {
        client.setIdTokenContentEncryptionAlgorithm(idTokenEncryptedResponseEnc.asText());
    }

    private void setUserInfoResponseSigningAlgorithm(Client client, JsonNode fieldJsonValue) {
        client.setUserInfoResponseSigningAlgorithm(fieldJsonValue.asText());
    }

    private void setUserInfoResponseEncryptionAlgorithm(Client client, JsonNode fieldJsonValue) {
        client.setUserInfoResponseEncryptionAlgorithm(fieldJsonValue.asText());
    }

    private void setUserInfoResponseContentEncryptionAlgorithm(Client client, JsonNode fieldJsonValue) {
        client.setUserInfoResponseContentEncryptionAlgorithm(fieldJsonValue.asText());
    }

    private void setGrantTypes(Client client, JsonNode grantTypectUriNode) {
        List<String> grantTypes = this.getValueAsList(grantTypectUriNode);
        HashSet<String> grants = new HashSet<String>();
        for (String grantType : grantTypes) {
            grants.add(grantType.toLowerCase());
        }
        client.setGrantTypes(grants);
    }

    private void setResponseTypes(Client client, JsonNode responseTypesNode) {
        List<String> responseTypes = this.getValueAsList(responseTypesNode);
        if (responseTypes.size() > 0) {
            client.setRestrictResponseTypes(true);
            client.setRestrictedResponseTypes(responseTypes);
        }
    }

    private void setClientName(Client client, JsonNode clientNameNode) {
        client.setName(clientNameNode.asText());
    }

    private void setClientDescription(Client client, JsonNode clientDescriptionNode) {
        client.setDescription(clientDescriptionNode.asText());
    }

    private void setClientId(Client client, JsonNode clientIdNode) {
        client.setClientId(clientIdNode.asText());
    }

    private void setSecret(Client client, JsonNode clientSecretNode) {
        client.setSecret(clientSecretNode.asText());
    }

    private void setLogoUri(Client client, JsonNode logoUriNode) {
        client.setLogoUrl(logoUriNode.asText());
    }

    private void setScope(Client client, JsonNode scopeNode) {
        String scopeValue = scopeNode.asText();
        ArrayList<String> scopes = new ArrayList<String>(Arrays.asList(scopeValue.split(" ")));
        ClientUtil.setScopes(scopes, (Client)client);
    }

    private void setAuthorizationDetailTypes(Client client, JsonNode authorizationDetailTypesNode) {
        List<String> authorizationDetailTypes = this.getValueAsList(authorizationDetailTypesNode);
        ClientUtil.setAuthorizationDetailsTypes(authorizationDetailTypes, (Client)client);
    }

    private void setJwksUri(Client client, JsonNode jwksUriNode) {
        client.setJwksUrl(jwksUriNode.asText());
    }

    private void setJwks(Client client, JsonNode jwksNode) throws ClientRegistrationException {
        if (!jwksNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            throw new ClientRegistrationException(Response.Status.BAD_REQUEST, ClientRegistrationException.ErrorCode.invalid_client_metadata, "Invalid JWKS.");
        }
        client.setJwks(jwksNode.toString());
    }

    private void setSoftwareStatement(Client client, JsonNode fieldJsonValue) {
        if (client instanceof DynamicOAuthClient) {
            ((DynamicOAuthClient)client).setSoftwareStatement(fieldJsonValue.asText());
        }
    }

    private void setBackchannelTokenDeliveryMode(Client client, JsonNode responseTypesNode) {
        client.setCibaTokenDeliveryMode(CibaDeliveryMode.lookupByName((String)responseTypesNode.asText()));
    }

    private void setBackchannelClientNotificationEndpoint(Client client, JsonNode responseTypesNode) {
        client.setCibaNotificationEndpoint(responseTypesNode.asText());
    }

    private void setBackchannelUserCodeParameter(Client client, JsonNode responseTypesNode) {
        boolean cibaUserCode = responseTypesNode.asBoolean();
        client.setCibaUserCodeSupported(Boolean.valueOf(cibaUserCode));
    }

    private void setSubectType(Client client, JsonNode responseTypesNode) {
        String subjectType = responseTypesNode.asText();
        boolean pairwiseUserType = "pairwise".equals(subjectType);
        client.setPairwiseUserType(pairwiseUserType);
    }

    private void setSectorIdentifierUri(Client client, JsonNode responseTypesNode) {
        client.setSectorIdentifierUri(responseTypesNode.asText());
    }

    private void addToResponseIfNotBlank(String key, String value, ObjectNode response) {
        if (StringUtils.isNotBlank((String)value)) {
            response.put(key, value);
        }
    }

    private void addToResponseIfNotBlank(String key, Integer value, ObjectNode response) {
        if (value != null) {
            response.put(key, value);
        }
    }

    private void addFieldToObjectNode(ObjectNode objectNode, DynamicClientFields dynamicClientFields, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            objectNode.put(dynamicClientFields.getName(), value);
        }
    }
}

