/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.rest.oauth.clientregistration.token;

import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.oauth20.AccessToken;
import com.pingidentity.sdk.oauth20.BearerAccessTokenManagementPlugin;
import com.pingidentity.sdk.oauth20.IssuedAccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;

public class RegistrationAccessTokenManagementPlugin
implements BearerAccessTokenManagementPlugin {
    private Client client;
    private ConfigStore dynamicClientRegistrationConfigStore = ConfigStoreFarm.getConfig((String)"dynamic-client-registration");
    private final int REGISTRATION_ACCESS_TOKEN_LENGTH = Integer.signum(this.dynamicClientRegistrationConfigStore.getIntValue("RegistrationAccessTokenLength", 28)) == 1 ? this.dynamicClientRegistrationConfigStore.getIntValue("RegistrationAccessTokenLength", 28) : 28;

    public RegistrationAccessTokenManagementPlugin(Client client) {
        this.client = client;
    }

    public AccessToken validateAccessToken(String accessTokenValue) {
        AccessToken accessToken = null;
        if (StringUtils.isNotBlank((String)accessTokenValue) && this.client.getRegistrationAccessToken() != null && this.client.getRegistrationAccessToken().checkSecret(accessTokenValue)) {
            accessToken = new AccessToken(0L, null, null, this.client.getClientId(), null);
        }
        return accessToken;
    }

    public IssuedAccessToken issueAccessToken(Map<String, AttributeValue> attributes, Scope scope, String clientId, String accessGrantGuid) {
        String accessTokenString = IDGenerator.rndAlphaNumeric((int)this.REGISTRATION_ACCESS_TOKEN_LENGTH);
        return new IssuedAccessToken(accessTokenString, "Bearer", null);
    }

    public void configure(Configuration configuration) {
    }

    public PluginDescriptor getPluginDescriptor() {
        return null;
    }
}

