/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c;

import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.plugins.datastore.p14c.shade.com.pingidentity.integrations.logger.LogLevel;

public enum DataStoreLogEvent implements LogEvent
{
    INVALID_EXPRESSION(LogLevel.ERROR, "000", "Invalid expression: %s"),
    INVALID_CRITERIA(LogLevel.WARN, "001", "Invalid search criteria, returning null"),
    RETRIEVE_ERROR(LogLevel.WARN, "002", "Error encountered while processing expression: [%s]"),
    EVALUATING_EXPRESSION(LogLevel.TRACE, "003", "Evaluating expression: %s"),
    RETRIEVED_RESULT(LogLevel.TRACE, "004", "Retrieved result: [%s]"),
    ENV_TEST_ERROR(LogLevel.ERROR, "005", "Error while testing connection"),
    RESPONSE_PROCESSING_ERROR(LogLevel.ERROR, "006", "Error processing response: %s"),
    RESPONSE_RETRIEVING_ERROR(LogLevel.ERROR, "007", "Error retrieving user device attributes: %s"),
    MULTIPLE_USER(LogLevel.ERROR, "008", "Multiple users are returned based on condition given, only one should be returned"),
    NO_USER(LogLevel.ERROR, "009", "No user found matching filter criteria"),
    GET_ACCESS_TOKEN(LogLevel.DEBUG, "010", "Getting new access token"),
    NO_USER_INFO(LogLevel.DEBUG, "011", "Unable to find user info"),
    INFO_RETRIEVING_ERROR(LogLevel.DEBUG, "012", "Error while retrieving information from driver"),
    SEND_REQUEST(LogLevel.DEBUG, "013", "Sending %s request to %s"),
    EXCEEDING_RETRY(LogLevel.DEBUG, "014", "Exceeded configured retries number or maximum retries attempt"),
    BACKOFF_ENFORCED(LogLevel.DEBUG, "015", "Exponential Backoff Algorithm delay enforced to handle rate limiting failures. Sleeping for %.2f seconds"),
    THREAD_INTERRUPTED(LogLevel.DEBUG, "016", "Thread interrupted: %s"),
    RETRY_REQUEST(LogLevel.DEBUG, "017", "Retrying %s request to %s (retry #%d)"),
    REFRESH_ACCESS_TOKEN(LogLevel.DEBUG, "018", "Service returned %d, refreshing access token"),
    NO_DEVICE_INFO(LogLevel.TRACE, "019", "User with id %s has no device info"),
    ASSIGNING_ATTR_ERROR(LogLevel.TRACE, "020", "Unable to assigning attribute '%s'"),
    ASSIGNING_ATTR(LogLevel.TRACE, "021", "Assigning attribute '%s' with value '%s'"),
    REQUEST_RESPONSE(LogLevel.TRACE, "022", "%s response to '%s' returned '%s'"),
    ERROR_GETTING_ACCESS_TOKEN(LogLevel.DEBUG, "027", "Error getting access token."),
    TEST_CONNECTION_FAIL(LogLevel.ERROR, "023", "Connection test failed. Response code: %d, Response data: %s"),
    TEST_CONNECTION_ERROR(LogLevel.ERROR, "024", "An error occurred while testing the connection. Error: %s"),
    TEST_CONNECTION(LogLevel.DEBUG, "025", "Action invoked to test connection"),
    TEST_CONNECTION_SUCCESS(LogLevel.DEBUG, "026", "Connection test successful. Response code: %d, Response data: %s");

    private static final String PRODUCT_CODE = "IPOD";
    private final LogLevel level;
    private final String code;
    private final String message;

    private DataStoreLogEvent(LogLevel level, String code, String message) {
        this.level = level;
        this.code = code;
        this.message = message;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getCode() {
        return "IPOD-" + this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

