/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class ExponentialBackOffCalculator {
    private static final double DELAY_IN_MILLIS = 1000.0;
    private static final double MULTIPLIER = 2.0;
    private static final long MAX_DELAY = 0x6DDD00L;
    private int retryAttemptNumber = 0;
    private boolean backOffEnforced = false;

    public synchronized boolean isBackOffEnforced() {
        return this.backOffEnforced;
    }

    public synchronized void resetBackOffEnforcement() {
        this.backOffEnforced = false;
        this.retryAttemptNumber = 0;
    }

    public synchronized void enableBackOffEnforcement() {
        this.backOffEnforced = true;
        this.retryAttemptNumber = 0;
    }

    public synchronized long calculateRetryDelay() {
        try {
            SecureRandom randomGenerator = SecureRandom.getInstance("SHA1PRNG");
            long delay = (long)(Math.pow(2.0, this.retryAttemptNumber) * 1000.0 + (double)randomGenerator.nextInt(1001));
            ++this.retryAttemptNumber;
            return delay;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean shouldRetry() {
        try {
            SecureRandom randomGenerator = SecureRandom.getInstance("SHA1PRNG");
            long delay = (long)(Math.pow(2.0, this.retryAttemptNumber) * 1000.0 + (double)randomGenerator.nextInt(1001));
            boolean exceedMaxWaitTime = delay > 0x6DDD00L;
            return !exceedMaxWaitTime;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

