/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c.configuration;

import com.pingidentity.plugins.datastore.p14c.CustomExpressionEvaluator;
import com.pingidentity.plugins.datastore.p14c.DataStoreConstants;
import com.pingidentity.plugins.datastore.p14c.TestConnectionAction;
import com.pingidentity.plugins.datastore.p14c.configuration.Region;
import com.pingidentity.plugins.datastore.p14c.configuration.TemplatesTableColumnValuesUniqueValidator;
import com.pingidentity.plugins.datastore.p14c.util.HttpClientBuilderUtils;
import com.pingidentity.plugins.datastore.p14c.util.StringUtils;
import com.pingidentity.plugins.datastore.p14c.util.UrlUtil;
import com.pingidentity.plugins.datastore.p14c.validators.ConfigUrlValidator;
import com.pingidentity.plugins.datastore.p14c.validators.DataStoreConfigurationValidator;
import com.pingidentity.plugins.datastore.p14c.validators.FieldValueValidator;
import com.pingidentity.plugins.datastore.p14c.validators.IntegerFieldLabelValidator;
import com.pingidentity.plugins.datastore.p14c.validators.RequiredFieldLabelValidator;
import com.pingidentity.sources.gui.FilterFieldsGuiDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class DataStoreConfiguration {
    private static boolean supportsSetHidden;
    private static boolean supportsPingOneEnvironmentFieldDescriptor;

    public static boolean supportsPingOneEnvironmentFieldDescriptor() {
        return supportsPingOneEnvironmentFieldDescriptor;
    }

    public static FilterFieldsGuiDescriptor getFilterFieldsGuiDescriptor() {
        RequiredFieldValidator requiredFieldValidator = new RequiredFieldValidator();
        FilterFieldsGuiDescriptor filterFieldsDescriptor = new FilterFieldsGuiDescriptor("The following settings control what attribute and filter is used to look up entries in PingOne.");
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> options = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        options.add(new AbstractSelectionFieldDescriptor.OptionValue("username", "username"));
        options.add(new AbstractSelectionFieldDescriptor.OptionValue("id", "id"));
        SelectFieldDescriptor selectField = new SelectFieldDescriptor("Attribute", "The attribute to use for performing filtered lookups.", options);
        selectField.addValidator((FieldValidator)requiredFieldValidator);
        filterFieldsDescriptor.addField((FieldDescriptor)selectField);
        TextFieldDescriptor valueField = new TextFieldDescriptor("Value", "The criteria used in conjunction with the selected attribute to look up entries. References to other attributes provided at runtime should be included. E.g.: ${username} from an HTML Form Adapter, or ${SAML_SUBJECT} from an IdP connection.");
        valueField.addValidator((FieldValidator)requiredFieldValidator);
        filterFieldsDescriptor.addField((FieldDescriptor)valueField);
        return filterFieldsDescriptor;
    }

    public static AdapterConfigurationGuiDescriptor getAdapterConfigurationGuiDescriptor() {
        return DataStoreConfiguration.getAdapterConfigurationGuiDescriptor(null);
    }

    public static AdapterConfigurationGuiDescriptor getAdapterConfigurationGuiDescriptor(Configuration configuration) {
        AdapterConfigurationGuiDescriptor dataStoreConfigGuiDesc = new AdapterConfigurationGuiDescriptor("This data store will connect to PingOne for user and attribute lookups. Connection details to PingOne are specific to your organization.");
        if (supportsPingOneEnvironmentFieldDescriptor) {
            dataStoreConfigGuiDesc.addField(PingOneEnvironmentField.newPingOneEnvironmentField());
            if (configuration == null || PingOneEnvironmentField.isConfigured(configuration)) {
                dataStoreConfigGuiDesc.addField((FieldDescriptor)DataStoreConfiguration.getEnvironmentIdFieldDescriptor(true));
                dataStoreConfigGuiDesc.addField((FieldDescriptor)DataStoreConfiguration.getClientIdFieldDescriptor(true));
                dataStoreConfigGuiDesc.addField((FieldDescriptor)DataStoreConfiguration.getClientSecretFieldDescriptor(true));
                dataStoreConfigGuiDesc.addField((FieldDescriptor)RegionField.getHiddenInstance());
                dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)PingOneApiServiceField.hiddenInstance());
                dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)PingOneAuthServiceUrlField.hiddenInstance());
            }
        }
        if (!supportsPingOneEnvironmentFieldDescriptor || configuration != null && !PingOneEnvironmentField.isConfigured(configuration)) {
            dataStoreConfigGuiDesc.addField((FieldDescriptor)DataStoreConfiguration.getEnvironmentIdFieldDescriptor(false));
            dataStoreConfigGuiDesc.addField((FieldDescriptor)DataStoreConfiguration.getClientIdFieldDescriptor(false));
            dataStoreConfigGuiDesc.addField((FieldDescriptor)DataStoreConfiguration.getClientSecretFieldDescriptor(false));
            dataStoreConfigGuiDesc.addField((FieldDescriptor)new RegionField(configuration));
            if (configuration != null && !RegionField.isConfigured(configuration) && PingOneApiServiceField.isConfigured(configuration) && PingOneAuthServiceUrlField.isConfigured(configuration)) {
                dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)new PingOneApiServiceField());
                dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)new PingOneAuthServiceUrlField());
            } else {
                dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)PingOneApiServiceField.hiddenInstance());
                dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)PingOneAuthServiceUrlField.hiddenInstance());
            }
        }
        dataStoreConfigGuiDesc.addTable(DataStoreConfiguration.getCustomAttributeTableDescriptor());
        dataStoreConfigGuiDesc.addValidator((ConfigurationValidator)new TemplatesTableColumnValuesUniqueValidator("Custom Attributes Details", "Local Attribute", "Duplicate local attributes are not allowed: "));
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)DataStoreConfiguration.getRequestTimeOutDescriptor());
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)DataStoreConfiguration.getRetryCheckboxDescriptor());
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)DataStoreConfiguration.getMaxRetriesAttemptDescriptor());
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)DataStoreConfiguration.getErrorCodeForRetryDescriptor());
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)DataStoreConfiguration.getUserGroupCheckboxDescriptor());
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)DataStoreConfiguration.getDeviceInfoCheckboxDescriptor());
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)HttpClientBuilderUtils.getProxyConfigRadioGroupField());
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)HttpClientBuilderUtils.getProxyConfigHostTextField());
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)HttpClientBuilderUtils.getProxyConfigPortTextField());
        dataStoreConfigGuiDesc.addAdvancedField((FieldDescriptor)ReadTimeoutField.hiddenInstance());
        dataStoreConfigGuiDesc.addValidator((ConfigurationValidator)new DataStoreConfigurationValidator(configuration));
        dataStoreConfigGuiDesc.addAction(new ActionDescriptor("Test Connection", "Tests the provided client credentials for service authentication.", (ActionDescriptor.Action)new TestConnectionAction()));
        return dataStoreConfigGuiDesc;
    }

    public static TextFieldDescriptor getEnvironmentIdFieldDescriptor(boolean isHidden) {
        TextFieldDescriptor environmentIdFieldDescriptor;
        if (isHidden) {
            environmentIdFieldDescriptor = new TextFieldDescriptor("Environment ID", "Environment ID from your PingOne organization. Deprecated. Replaced by 'PingOne Environment'.");
            environmentIdFieldDescriptor.setHidden(true);
        } else {
            environmentIdFieldDescriptor = new TextFieldDescriptor("Environment ID", "Environment ID from your PingOne organization.");
            environmentIdFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
            environmentIdFieldDescriptor.addValidator((FieldValidator)new FieldValueValidator());
        }
        return environmentIdFieldDescriptor;
    }

    public static TextFieldDescriptor getClientIdFieldDescriptor(boolean isHidden) {
        TextFieldDescriptor clientIdFieldDescriptor;
        if (isHidden) {
            clientIdFieldDescriptor = new TextFieldDescriptor("Client ID", "The ID of the client created in PingOne for service authentication. Deprecated. Replaced by 'PingOne Environment'.");
            clientIdFieldDescriptor.setHidden(true);
        } else {
            clientIdFieldDescriptor = new TextFieldDescriptor("Client ID", "The ID of the client created in PingOne for service authentication.");
            clientIdFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
            clientIdFieldDescriptor.addValidator((FieldValidator)new FieldValueValidator());
        }
        return clientIdFieldDescriptor;
    }

    public static TextFieldDescriptor getClientSecretFieldDescriptor(boolean isHidden) {
        TextFieldDescriptor clientSecretFieldDescriptor;
        if (isHidden) {
            clientSecretFieldDescriptor = new TextFieldDescriptor("Client Secret", "The secret of the client created in PingOne for service authentication. Deprecated. Replaced by 'PingOne Environment'.", true);
            clientSecretFieldDescriptor.setHidden(true);
        } else {
            clientSecretFieldDescriptor = new TextFieldDescriptor("Client Secret", "The secret of the client created in PingOne for service authentication.", true);
            clientSecretFieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
        }
        return clientSecretFieldDescriptor;
    }

    public static TableDescriptor getCustomAttributeTableDescriptor() {
        TableDescriptor customAttributesTable = new TableDescriptor("Custom Attributes Details", "Define local attributes, and map them to a remote attribute using JSON Pointer (RFC 6901) syntax. Click 'Add a new row ...' to add multiple entries.");
        TextFieldDescriptor customAttributeLocalAttributeNameField = new TextFieldDescriptor("Local Attribute", DataStoreConstants.CUSTOM_ATTRIBUTES_TABLE_NAME_LOCAL_ATTR_FIELD_DESC);
        customAttributeLocalAttributeNameField.addValidator((FieldValidator)new RequiredFieldValidator());
        customAttributesTable.addRowField((FieldDescriptor)customAttributeLocalAttributeNameField);
        TextFieldDescriptor customAttributeRemoteAttributePathField = new TextFieldDescriptor("PingOne for Customers Attribute", DataStoreConstants.CUSTOM_ATTRIBUTES_TABLE_REMOTE_ATTR_PATH_FIELD_DESC);
        customAttributeRemoteAttributePathField.setLabel("PingOne Attribute");
        customAttributeRemoteAttributePathField.addValidator((FieldValidator)new RequiredFieldLabelValidator("PingOne Attribute"));
        customAttributesTable.addRowField((FieldDescriptor)customAttributeRemoteAttributePathField);
        customAttributesTable.addValidator(fieldsInRow -> {
            String path = fieldsInRow.getFieldValue("PingOne for Customers Attribute");
            CustomExpressionEvaluator customExpressionEvaluator = new CustomExpressionEvaluator(path);
            boolean valid = customExpressionEvaluator.validateJsonPointerExpression();
            if (!valid) {
                throw new ValidationException("Enter valid JSON Pointer format.");
            }
        });
        return customAttributesTable;
    }

    public static TextFieldDescriptor getRequestTimeOutDescriptor() {
        TextFieldDescriptor requestTimeOutFieldDescriptor = new TextFieldDescriptor("Connection Timeout", "The amount of time in milliseconds that PingFederate waits for PingOne API to respond to requests and connection establishment. The default value is 10000. A value of 0 disables the timeout.");
        requestTimeOutFieldDescriptor.setLabel("API Request Timeout");
        requestTimeOutFieldDescriptor.addValidator((FieldValidator)new RequiredFieldLabelValidator("API Request Timeout"));
        requestTimeOutFieldDescriptor.setDefaultValue("10000");
        requestTimeOutFieldDescriptor.addValidator((FieldValidator)new IntegerFieldLabelValidator("API Request Timeout", 0, Integer.MAX_VALUE));
        return requestTimeOutFieldDescriptor;
    }

    public static CheckBoxFieldDescriptor getRetryCheckboxDescriptor() {
        CheckBoxFieldDescriptor retryCheckboxField = new CheckBoxFieldDescriptor("Retry Request", "Retry user data retrieval request if API fails with error codes configured.");
        retryCheckboxField.setDefaultValue(true);
        return retryCheckboxField;
    }

    public static CheckBoxFieldDescriptor getUserGroupCheckboxDescriptor() {
        CheckBoxFieldDescriptor enableUserGroupInfoFieldDescriptor = new CheckBoxFieldDescriptor("Enable User Group Info Retrieval", "If selected, the request to retrieve user group info will be made during data store lookup. The core contract attribute memberOfGroupIDs and memberOfGroupNames will be populated with retrieved values.");
        enableUserGroupInfoFieldDescriptor.setDefaultValue(true);
        enableUserGroupInfoFieldDescriptor.setDefaultForLegacyConfig(Boolean.TRUE.toString());
        return enableUserGroupInfoFieldDescriptor;
    }

    public static CheckBoxFieldDescriptor getDeviceInfoCheckboxDescriptor() {
        CheckBoxFieldDescriptor enableDeviceInfoFieldDescriptor = new CheckBoxFieldDescriptor("Enable Device Info Retrieval", "If selected, the request to retrieve device info will be made during data store lookup. The core contract attributes devices.phone and devices.email will be populated with retrieved values.");
        enableDeviceInfoFieldDescriptor.setDefaultValue(true);
        enableDeviceInfoFieldDescriptor.setDefaultForLegacyConfig(Boolean.TRUE.toString());
        return enableDeviceInfoFieldDescriptor;
    }

    public static TextFieldDescriptor getMaxRetriesAttemptDescriptor() {
        TextFieldDescriptor maxRetriesAttemptField = new TextFieldDescriptor("Maximum Retries Limit", "Maximum number of retries attempted if API fails with error codes configured.");
        maxRetriesAttemptField.setDefaultValue("5");
        maxRetriesAttemptField.setDefaultForLegacyConfig("5");
        return maxRetriesAttemptField;
    }

    public static TextFieldDescriptor getErrorCodeForRetryDescriptor() {
        TextFieldDescriptor errorCodeForRetryField = new TextFieldDescriptor("Retry Error Codes", "Comma-separated list of error code values for API re-attempt e.g. 429, 503.");
        errorCodeForRetryField.setDefaultValue("429");
        return errorCodeForRetryField;
    }

    static {
        try {
            Method[] methods = FieldDescriptor.class.getMethods();
            supportsSetHidden = Arrays.stream(methods).anyMatch(method -> "setHidden".equals(method.getName()));
            Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
            supportsPingOneEnvironmentFieldDescriptor = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPingOneEnvironmentFieldDescriptor = false;
        }
    }

    public static class PingOneAuthServiceUrlField
    extends TextFieldDescriptor {
        public PingOneAuthServiceUrlField() {
            super("PingOne Authorization Service", "The base URL of the PingOne services to authenticate and authorize API requests. This field should only be modified for testing purposes.");
            this.addValidator(new ConfigUrlValidator());
            this.addValidator(new FieldValueValidator());
        }

        public static TextFieldDescriptor hiddenInstance() {
            TextFieldDescriptor pingOneAuthServiceUrlField = new TextFieldDescriptor("PingOne Authorization Service", "The base URL of the PingOne services to authenticate and authorize API requests. This field should only be modified for testing purposes. Deprecated. Replaced by 'PingOne Environment' for PingFederate 10.2 and later.Replaced by 'Region' for PingFederate 10.1 and earlier.");
            pingOneAuthServiceUrlField.addValidator((FieldValidator)new ConfigUrlValidator());
            pingOneAuthServiceUrlField.addValidator((FieldValidator)new FieldValueValidator());
            if (supportsSetHidden) {
                pingOneAuthServiceUrlField.setHidden(true);
            }
            return pingOneAuthServiceUrlField;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && configuration.getFieldValue("PingOne Authorization Service") != null && !configuration.getFieldValue("PingOne Authorization Service").isEmpty();
        }
    }

    public static class PingOneApiServiceField
    extends TextFieldDescriptor {
        public PingOneApiServiceField() {
            super("PingOne API Service", "The base URL of the PingOne API services. This field should only be modified for testing purposes.");
            this.addValidator(new ConfigUrlValidator());
            this.addValidator(new FieldValueValidator());
        }

        public static TextFieldDescriptor hiddenInstance() {
            TextFieldDescriptor pingOneApiServiceField = new TextFieldDescriptor("PingOne API Service", "The base URL of the PingOne API services. This field should only be modified for testing purposes. Deprecated. Replaced by 'PingOne Environment' for PingFederate 10.2 and later.Replaced by 'Region' for PingFederate 10.1 and earlier.");
            pingOneApiServiceField.addValidator((FieldValidator)new ConfigUrlValidator());
            pingOneApiServiceField.addValidator((FieldValidator)new FieldValueValidator());
            if (supportsSetHidden) {
                pingOneApiServiceField.setHidden(true);
            }
            return pingOneApiServiceField;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && configuration.getFieldValue("PingOne API Service") != null && !configuration.getFieldValue("PingOne API Service").isEmpty();
        }
    }

    public static class ReadTimeoutField {
        public static TextFieldDescriptor hiddenInstance() {
            TextFieldDescriptor readTimeoutField = new TextFieldDescriptor("Read Timeout", "Defines the socket timeout in milliseconds. A timeout value of zero is interpreted as an infinite timeout. A negative value will cause the OS level default to be used. Deprecated. Replaced by 'API Request Timeout'.");
            readTimeoutField.addValidator((FieldValidator & Serializable)field -> {
                String fieldValue = field.getValue();
                if (fieldValue != null && !fieldValue.isEmpty()) {
                    IntegerValidator integerValidator = new IntegerValidator();
                    integerValidator.validate(field);
                }
            });
            if (supportsSetHidden) {
                readTimeoutField.setHidden(true);
            }
            return readTimeoutField;
        }
    }

    public static class RegionField
    extends SelectFieldDescriptor {
        private static final List<AbstractSelectionFieldDescriptor.OptionValue> OPTION_VALUES = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();

        private RegionField(String description) {
            super("Region", description, OPTION_VALUES);
        }

        public RegionField(Configuration configuration) {
            this("The region shown in your environment properties on the PingOne console. This determines which PingOne API service endpoints are used.");
            Region region = RegionField.getRegion(configuration);
            this.setDefaultValue(region.getValue());
            this.setDefaultForLegacyConfig(region.getValue());
        }

        public static RegionField getHiddenInstance() {
            RegionField regionField = new RegionField("The region shown in your environment properties on the PingOne console. This determines which PingOne API service endpoints are used. Deprecated. Replaced by 'PingOne Environment'.");
            regionField.setHidden(true);
            return regionField;
        }

        public static Region getRegion(Configuration configuration) {
            Region region;
            if (configuration == null) {
                region = Region.getDefault();
            } else {
                String value = configuration.getFieldValue("Region");
                if (StringUtils.isBlank(value)) {
                    String apiPath = UrlUtil.trimTrailingSlash(configuration.getFieldValue("PingOne API Service"));
                    String authPath = UrlUtil.trimTrailingSlash(configuration.getFieldValue("PingOne Authorization Service"));
                    region = apiPath != null && Region.fromApiEndpoint(apiPath) != null ? Region.fromApiEndpoint(apiPath) : (authPath != null && Region.fromAuthEndpoint(authPath) != null ? Region.fromAuthEndpoint(authPath) : Region.getDefault());
                } else {
                    region = Region.fromValue(value);
                }
            }
            return region;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && configuration.getFieldValue("Region") != null && !configuration.getFieldValue("Region").isEmpty();
        }

        static {
            OPTION_VALUES.add(SelectFieldDescriptor.SELECT_ONE);
            OPTION_VALUES.addAll(Arrays.stream(Region.values()).map(region -> new AbstractSelectionFieldDescriptor.OptionValue(region.getName(), region.getValue())).collect(Collectors.toList()));
        }
    }

    public static class PingOneEnvironmentField {
        public static FieldDescriptor newPingOneEnvironmentField() {
            try {
                Class<?> pingOneEnvironmentFieldClass = Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
                Constructor<?> pingOneEnvironmentFieldConstructor = pingOneEnvironmentFieldClass.getConstructor(String.class, String.class);
                return (FieldDescriptor)pingOneEnvironmentFieldConstructor.newInstance("PingOne Environment", "Your PingOne environment. Create connections in System > External Systems > PingOne Connections.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String getPingOneEnvironment(Configuration configuration) {
            return configuration.getFieldValue("PingOne Environment");
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotEmpty(PingOneEnvironmentField.getPingOneEnvironment(configuration));
        }
    }
}

