/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c.configuration;

import java.util.Arrays;

public enum Region {
    NORTH_AMERICA("North America", "NA", "https://auth.pingone.com", "https://api.pingone.com"),
    EUROPEAN_UNION("European Union", "EU", "https://auth.pingone.eu", "https://api.pingone.eu"),
    ASIA_PACIFIC("Asia-Pacific", "AP", "https://auth.pingone.asia", "https://api.pingone.asia");

    private final String name;
    private final String value;
    private final String apiEndpoint;
    private final String authEndpoint;

    private Region(String name, String value, String authEndpoint, String apiEndpoint) {
        this.name = name;
        this.value = value;
        this.apiEndpoint = apiEndpoint;
        this.authEndpoint = authEndpoint;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public static Region fromValue(String value) {
        return Arrays.stream(Region.values()).filter(region -> region.value.equals(value)).findFirst().orElse(null);
    }

    public static Region fromApiEndpoint(String apiEndpoint) {
        return Arrays.stream(Region.values()).filter(region -> region.apiEndpoint.equals(apiEndpoint)).findFirst().orElse(null);
    }

    public static Region fromAuthEndpoint(String authEndpoint) {
        return Arrays.stream(Region.values()).filter(region -> region.authEndpoint.equals(authEndpoint)).findFirst().orElse(null);
    }

    public static Region getDefault() {
        return NORTH_AMERICA;
    }
}

