/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c.configuration;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class TemplatesTableColumnValuesUniqueValidator
implements ConfigurationValidator {
    private String tableName;
    private String colName;
    private String errMsg;

    public TemplatesTableColumnValuesUniqueValidator(String tableName, String colName, String errMsg) {
        this.tableName = tableName;
        this.colName = colName;
        this.errMsg = errMsg;
    }

    private void validateDuplicatesInTable(Configuration configuration) throws ValidationException {
        Table table = configuration.getTable(this.tableName);
        if (table.getRows() != null && table.getRows().size() > 1) {
            StringJoiner strJoiner = new StringJoiner(", ");
            HashSet<String> loggedDupValuesSet = new HashSet<String>();
            HashSet<String> colValueSet = new HashSet<String>();
            for (Row row : table.getRows()) {
                Field field = row.getField(this.colName);
                for (String colValue : this.processValue(field)) {
                    if (colValueSet.add(colValue) || loggedDupValuesSet.contains(colValue)) continue;
                    strJoiner.add(colValue);
                    loggedDupValuesSet.add(colValue);
                }
            }
            if (!loggedDupValuesSet.isEmpty()) {
                throw new ValidationException(this.errMsg + strJoiner);
            }
        }
    }

    public List<String> processValue(Field field) {
        return Collections.singletonList(field.getValue());
    }

    public void validate(Configuration configuration) throws ValidationException {
        this.validateDuplicatesInTable(configuration);
    }
}

