/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.http;

import com.pingidentity.plugins.datastore.p14c.shade.org.apache.hc.core5.util.Args;
import java.util.Locale;

public enum Method {
    GET(true, true),
    HEAD(true, true),
    POST(false, false),
    PUT(false, true),
    DELETE(false, true),
    CONNECT(false, false),
    TRACE(true, true),
    OPTIONS(true, true),
    PATCH(false, false);

    private final boolean safe;
    private final boolean idempotent;

    private Method(boolean safe, boolean idempotent) {
        this.safe = safe;
        this.idempotent = idempotent;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public static boolean isSafe(String value) {
        if (value == null) {
            return false;
        }
        try {
            return Method.normalizedValueOf((String)value).safe;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isIdempotent(String value) {
        if (value == null) {
            return false;
        }
        try {
            return Method.normalizedValueOf((String)value).idempotent;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static Method normalizedValueOf(String method) {
        return Method.valueOf(Args.notNull(method, "method").toUpperCase(Locale.ROOT));
    }

    public boolean isSame(String value) {
        if (value == null) {
            return false;
        }
        return this.name().equalsIgnoreCase(value);
    }
}

