/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu;

import com.pingidentity.pf.support.ucu.doer.Doer;
import com.pingidentity.pf.support.ucu.exception.UserCountUtilityException;
import com.pingidentity.pf.support.ucu.util.ListUtil;
import com.pingidentity.pf.support.ucu.util.UniqueUser;
import com.pingidentity.pf.support.ucu.util.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Aggregator {
    Map<String, List<String>> userToTrackingId = new HashMap<String, List<String>>();
    Map<String, List<String>> trackingIdToUser = new HashMap<String, List<String>>();
    Map<String, HashSet<String>> connectionIdToSubject = new HashMap<String, HashSet<String>>();
    String event = "";

    public void setEvent(String e) {
        this.event = e;
    }

    public String getEvent() {
        return this.event;
    }

    public Map<String, List<String>> getUserToTrackingId() {
        return this.userToTrackingId;
    }

    public Map<String, List<String>> getTrackingIdToUser() {
        return this.trackingIdToUser;
    }

    public void addUserToAggregatePerApp(User user) {
        if (!this.connectionIdToSubject.keySet().contains(user.connectionid)) {
            this.connectionIdToSubject.put(user.connectionid, new HashSet());
        }
        this.connectionIdToSubject.get(user.connectionid).add(user.subject);
    }

    public void addUser(User user) {
        List<String> users;
        List<String> trackingIds;
        String subjectRoleConnectionId;
        String trackingid = user.trackingid;
        if (trackingid.equals("")) {
            trackingid = subjectRoleConnectionId = user.subject;
        } else {
            subjectRoleConnectionId = user.subject + user.role + user.connectionid;
        }
        if (this.userToTrackingId.keySet().contains(subjectRoleConnectionId)) {
            trackingIds = this.userToTrackingId.get(subjectRoleConnectionId);
            ListUtil.addUnique(trackingIds, trackingid);
        } else {
            trackingIds = new ArrayList<String>();
            trackingIds.add(trackingid);
            this.userToTrackingId.put(subjectRoleConnectionId, trackingIds);
        }
        if (this.trackingIdToUser.keySet().contains(trackingid)) {
            users = this.trackingIdToUser.get(trackingid);
            ListUtil.addUnique(users, subjectRoleConnectionId);
        } else {
            users = new ArrayList<String>();
            users.add(subjectRoleConnectionId);
            this.trackingIdToUser.put(trackingid, users);
        }
    }

    public void addUniqueUser(UniqueUser user) {
        for (String subjectRoleConnectionId : user.getSubjectRoleConnectionIds()) {
            List<String> trackingIds;
            if (this.userToTrackingId.keySet().contains(subjectRoleConnectionId)) {
                trackingIds = this.userToTrackingId.get(subjectRoleConnectionId);
                ListUtil.addAllUnique(trackingIds, new ArrayList<String>(user.getTrackingIds()));
                continue;
            }
            trackingIds = new ArrayList<String>();
            trackingIds.addAll(user.getTrackingIds());
            this.userToTrackingId.put(subjectRoleConnectionId, trackingIds);
        }
        for (String trackingId : user.getTrackingIds()) {
            List<String> users;
            if (this.trackingIdToUser.keySet().contains(trackingId)) {
                users = this.trackingIdToUser.get(trackingId);
                ListUtil.addAllUnique(users, new ArrayList<String>(user.getSubjectRoleConnectionIds()));
                continue;
            }
            users = new ArrayList<String>();
            users.addAll(user.getSubjectRoleConnectionIds());
            this.trackingIdToUser.put(trackingId, users);
        }
    }

    private List<String> getAllTrackingIdsForUser(String user, List<String> excludeTrackingids) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> trackingIds = this.userToTrackingId.get(user);
        for (String trackingId : trackingIds) {
            if (excludeTrackingids.contains(trackingId)) continue;
            result.add(trackingId);
        }
        return result;
    }

    private List<String> getAllUsersForTrackingId(String trackingId, List<String> excludeUsers) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> users = this.trackingIdToUser.get(trackingId);
        for (String user : users) {
            if (excludeUsers.contains(user)) continue;
            result.add(user);
        }
        return result;
    }

    private UniqueUser getUniqueUser(String user, List<String> processedUsers) {
        UniqueUser result = new UniqueUser();
        result.setEvent(this.event);
        ArrayList<String> users = new ArrayList<String>();
        users.add(user);
        ArrayList<String> excludeTrackingIds = new ArrayList<String>();
        ArrayList<String> excludeUsers = new ArrayList<String>();
        excludeUsers.add(user);
        while (users.size() > 0) {
            String u = (String)users.remove(0);
            result.addAltUserId(u);
            List<String> trackingIds = this.getAllTrackingIdsForUser(u, excludeTrackingIds);
            for (String trackingId : trackingIds) {
                users.addAll(this.getAllUsersForTrackingId(trackingId, excludeUsers));
                excludeTrackingIds.add(trackingId);
                result.addAltUserTrackingId(trackingId);
            }
            processedUsers.add(u);
        }
        return result;
    }

    public List<UniqueUser> aggregate() {
        ArrayList<UniqueUser> result = new ArrayList<UniqueUser>();
        ArrayList<String> processedUsers = new ArrayList<String>();
        ArrayList<String> usersToProcess = new ArrayList<String>();
        usersToProcess.addAll(this.userToTrackingId.keySet());
        while (usersToProcess.size() > 0) {
            String user = (String)usersToProcess.remove(usersToProcess.size() - 1);
            result.add(this.getUniqueUser(user, processedUsers));
            if (processedUsers.size() > 1) {
                usersToProcess.removeAll(processedUsers);
            }
            processedUsers.clear();
        }
        return result;
    }

    public static Map<String, Set<String>> aggregateDoersPerApp(List<Doer> doers) throws UserCountUtilityException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Doer doer : doers) {
            Map<String, Set<String>> doerUsers = doer.doitPerApp();
            for (String app : doerUsers.keySet()) {
                if (!result.keySet().contains(app)) {
                    result.put(app, new HashSet());
                }
                for (String subject : doerUsers.get(app)) {
                    ((Set)result.get(app)).add(subject);
                }
            }
        }
        return result;
    }

    public static Map<String, List<UniqueUser>> aggregateDoers(List<Doer> doers) throws UserCountUtilityException {
        HashMap users = new HashMap();
        HashMap<String, List<UniqueUser>> result = new HashMap<String, List<UniqueUser>>();
        for (Doer doer : doers) {
            Map<String, List<UniqueUser>> doerUsers = doer.doitPerSession();
            for (String event : doerUsers.keySet()) {
                if (!users.keySet().contains(event)) {
                    users.put(event, new ArrayList());
                }
                for (UniqueUser u : doerUsers.get(event)) {
                    ((List)users.get(event)).add(u);
                }
            }
        }
        if (doers.size() > 1) {
            HashMap<String, Aggregator> aggregators = new HashMap<String, Aggregator>();
            for (String event : users.keySet()) {
                if (!aggregators.keySet().contains(event)) {
                    Aggregator aggregator = new Aggregator();
                    aggregator.setEvent(event);
                    aggregators.put(event, aggregator);
                }
                for (UniqueUser u : (List)users.get(event)) {
                    ((Aggregator)aggregators.get(event)).addUniqueUser(u);
                }
                result.put(event, ((Aggregator)aggregators.get(event)).aggregate());
            }
        } else {
            result = users;
        }
        return result;
    }

    public void aggregatePerApp(Map<String, Set<String>> result) {
        for (String connectionId : this.connectionIdToSubject.keySet()) {
            Set allSubjects = this.connectionIdToSubject.get(connectionId);
            result.put(connectionId + " (" + this.getEvent() + ") ", allSubjects);
            this.connectionIdToSubject.put(connectionId, null);
        }
        this.connectionIdToSubject.clear();
    }
}

