/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.pf.support.ucu.Aggregator;
import com.pingidentity.pf.support.ucu.Log;
import com.pingidentity.pf.support.ucu.conf.AppenderConfig;
import com.pingidentity.pf.support.ucu.conf.ConfigParser;
import com.pingidentity.pf.support.ucu.doer.Doer;
import com.pingidentity.pf.support.ucu.doer.DoerFactory;
import com.pingidentity.pf.support.ucu.exception.UserCountException;
import com.pingidentity.pf.support.ucu.exception.UserCountUtilityException;
import com.pingidentity.pf.support.ucu.fileUCUCollector.UCUOutputFileUniqueUserCollector;
import com.pingidentity.pf.support.ucu.util.Regex;
import com.pingidentity.pf.support.ucu.util.UniqueUser;
import com.pingidentity.pf.support.ucu.util.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class UserCountUtility {
    private static final String UCU_VERSION_PROPERTIES_FILE = "ucu-version.properties";
    private static final String UCU_VERSION_PROPERTY = "ucu-version";
    private static String ucuVersion = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String pfHome;
            try {
                Log.init();
            }
            catch (FileNotFoundException e) {
                Log.warn(UserCountUtility.class, "Unable to open 'usercount.log' for writing.", e);
            }
            try (InputStream inputStream = Regex.class.getResourceAsStream("/ucu-version.properties");){
                Properties ucuVersionProps = new Properties();
                Log.debug(Regex.class, "Loading ucu-version.properties");
                ucuVersionProps.load(inputStream);
                ucuVersion = ucuVersionProps.getProperty(UCU_VERSION_PROPERTY);
            }
            catch (IOException e) {
                throw new UserCountUtilityException("Unable to determine UCU version");
            }
            Map<String, List<String>> argMap = UserCountUtility.processArgs(args);
            boolean aggregatePerUserSession = false;
            UserCountUtility.logVersion();
            UserCountUtility.logArgMap(argMap);
            ConfigParser configParser = null;
            ArrayList<Doer> doers = new ArrayList<Doer>();
            UCUOutputFileUniqueUserCollector ucuOutputFileUniqueUserCollector = null;
            if (argMap.containsKey("loglevel")) {
                if (argMap.get("loglevel").isEmpty()) {
                    UserCountUtility.printUsage();
                    System.exit(0);
                }
                System.setProperty("ucu.log.level", argMap.get("loglevel").get(0));
            }
            if (argMap.isEmpty() || argMap.size() == 1 && argMap.containsKey("loglevel") || argMap.size() == 1 && argMap.containsKey("aggregate-per-user-session")) {
                if (argMap.containsKey("aggregate-per-user-session")) {
                    aggregatePerUserSession = true;
                }
                pfHome = System.getProperty("pf.home");
                configParser = new ConfigParser(pfHome);
            } else if (argMap.containsKey("help")) {
                UserCountUtility.printUsage();
                System.exit(0);
            } else if (argMap.containsKey("log-path")) {
                if (argMap.containsKey("log4j-config-path")) {
                    if (argMap.containsKey("pf-version")) {
                        configParser = new ConfigParser(argMap.get("log4j-config-path").get(0), argMap.get("log-path").get(0), new Version(argMap.get("pf-version").get(0)));
                    } else {
                        Log.error(UserCountUtility.class, "ERROR: --pf-version is required when specifying --log4j-config-path");
                        UserCountUtility.printUsage();
                    }
                } else {
                    pfHome = System.getProperty("pf.home");
                    configParser = new ConfigParser(pfHome);
                    configParser.setLogPath(argMap.get("log-path").get(0));
                }
            }
            if (configParser != null) {
                List<AppenderConfig> appenderConfigs = configParser.parse();
                doers.addAll(DoerFactory.getDoers(appenderConfigs));
            }
            if (!doers.isEmpty()) {
                if (aggregatePerUserSession) {
                    Map<String, List<UniqueUser>> users = Aggregator.aggregateDoers(doers);
                    if (users.size() != 0) {
                        Map<String, List<UniqueUser>> sortedUsers = UserCountUtility.sortUserPerSession(users);
                        try {
                            String userListFileName = System.getProperty("user.dir") + "/unique-users.ucu";
                            PrintWriter userListFile = new PrintWriter(userListFileName, "UTF-8");
                            UserCountUtility.printHeader(true, false);
                            for (String event : sortedUsers.keySet()) {
                                if (event == null || event.isEmpty()) {
                                    Log.info(UserCountUtility.class, "Total unique user count: " + sortedUsers.get(event).size());
                                } else {
                                    Log.info(UserCountUtility.class, "Unique " + event + " user count: " + sortedUsers.get(event).size());
                                }
                                for (UniqueUser u : sortedUsers.get(event)) {
                                    userListFile.println(u.serialize());
                                }
                            }
                            userListFile.close();
                            Log.info(UserCountUtility.class, "List of users saved in: " + userListFileName);
                        }
                        catch (Exception e) {
                            Log.error(UserCountUtility.class, e);
                        }
                    } else {
                        Log.error(UserCountUtility.class, "No users found");
                    }
                } else {
                    Map<String, Set<String>> usersPerApp = Aggregator.aggregateDoersPerApp(doers);
                    if (usersPerApp.size() != 0) {
                        Map<String, Set<String>> sortedUsersPerApp = UserCountUtility.sortUsersPerApp(usersPerApp);
                        try {
                            Integer connectionIdColumnWidth = 40;
                            Integer eventTypeColumnWidth = 7;
                            UserCountUtility.printHeader(false, false);
                            String userListFileName = System.getProperty("user.dir") + "/unique-users.ucu";
                            PrintWriter userListFile = new PrintWriter(userListFileName, "UTF-8");
                            for (String event : sortedUsersPerApp.keySet()) {
                                if (event == null || event.isEmpty()) {
                                    Log.info(UserCountUtility.class, "Unique user count: " + sortedUsersPerApp.get(event));
                                    continue;
                                }
                                String app = event.substring(0, event.indexOf("("));
                                String eventType = event.substring(event.indexOf("("), event.indexOf(")") + 1);
                                Log.info(UserCountUtility.class, UserCountUtility.truncateStringAndFillSpace(app, connectionIdColumnWidth) + " " + UserCountUtility.truncateStringAndFillSpace(eventType, eventTypeColumnWidth) + "   " + sortedUsersPerApp.get(event).size());
                                ObjectMapper mapper = new ObjectMapper();
                                userListFile.println("{\"" + app + "\":" + mapper.writeValueAsString(sortedUsersPerApp.get(event)) + "}");
                            }
                            userListFile.close();
                            Log.info(UserCountUtility.class, "List of users saved in: " + userListFileName);
                        }
                        catch (Exception e) {
                            Log.error(UserCountUtility.class, e);
                        }
                    } else {
                        Log.error(UserCountUtility.class, "No users found");
                    }
                }
            } else if (argMap.containsKey("aggregate")) {
                ucuOutputFileUniqueUserCollector = new UCUOutputFileUniqueUserCollector(argMap.get("aggregate"));
                Map<String, Set<String>> userIdsByApp = ucuOutputFileUniqueUserCollector.getUserIdsByApp();
                Map<String, Set<String>> sortedUserIdsByApp = UserCountUtility.sortUsersPerApp(userIdsByApp);
                Map<String, List<UniqueUser>> uniqueUsersByEvent = ucuOutputFileUniqueUserCollector.getUniqueUsersByEvent();
                Map<String, List<UniqueUser>> sortedUniqueUsersByEvent = UserCountUtility.sortUserPerSession(uniqueUsersByEvent);
                if (!sortedUserIdsByApp.isEmpty()) {
                    UserCountUtility.printHeader(false, true);
                    Integer connectionIdColumnWidth = 40;
                    for (Map.Entry<String, Set<String>> entry : sortedUserIdsByApp.entrySet()) {
                        Log.info(UserCountUtility.class, UserCountUtility.truncateStringAndFillSpace(entry.getKey(), connectionIdColumnWidth) + "   " + entry.getValue().size());
                    }
                }
                if (!sortedUniqueUsersByEvent.isEmpty()) {
                    UserCountUtility.printHeader(true, true);
                    for (String event : sortedUniqueUsersByEvent.keySet()) {
                        if (event == null || event.isEmpty()) {
                            Log.info(UserCountUtility.class, "Total unique user count: " + sortedUniqueUsersByEvent.get(event).size());
                            continue;
                        }
                        Log.info(UserCountUtility.class, "Unique " + event + " user count: " + sortedUniqueUsersByEvent.get(event).size());
                    }
                }
                if (sortedUserIdsByApp.isEmpty() && sortedUniqueUsersByEvent.isEmpty()) {
                    Log.error(UserCountUtility.class, "No users found");
                }
            } else {
                Log.error(UserCountUtility.class, "Nothing to do... please review command line options");
                UserCountUtility.printUsage();
            }
        }
        catch (UserCountUtilityException e) {
            Log.error(UserCountUtility.class, e);
            UserCountUtility.printUsage();
        }
        catch (Throwable t) {
            Log.error(UserCountUtility.class, t);
        }
        finally {
            Log.shutdown();
        }
    }

    private static Map<String, List<UniqueUser>> sortUserPerSession(Map<String, List<UniqueUser>> users) {
        LinkedHashMap<String, List<UniqueUser>> sortedUsers = new LinkedHashMap<String, List<UniqueUser>>();
        users.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingInt(entry -> ((List)entry.getValue()).size()))).forEachOrdered(entry -> {
            List cfr_ignored_0 = (List)sortedUsers.put((String)entry.getKey(), (List<UniqueUser>)entry.getValue());
        });
        return sortedUsers;
    }

    private static Map<String, Set<String>> sortUsersPerApp(Map<String, Set<String>> userPerApp) {
        LinkedHashMap<String, Set<String>> sortedUsersPerApp = new LinkedHashMap<String, Set<String>>();
        userPerApp.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingInt(entry -> ((Set)entry.getValue()).size()))).forEachOrdered(entry -> {
            Set cfr_ignored_0 = (Set)sortedUsersPerApp.put((String)entry.getKey(), (Set<String>)entry.getValue());
        });
        return sortedUsersPerApp;
    }

    private static Map<String, List<String>> processArgs(String[] args) throws UserCountUtilityException {
        HashMap<String, List<String>> argMap = new HashMap<String, List<String>>();
        String key = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--")) {
                key = args[i].substring(2);
                if (argMap.containsKey(key)) continue;
                argMap.put(key, new ArrayList());
                continue;
            }
            if (key != null && !key.equals("")) {
                ((List)argMap.get(key)).add(args[i]);
                continue;
            }
            Log.error(UserCountUtility.class, "Unrecognized parameter '" + args[i] + "'. Please review usage.", false, true);
            UserCountUtility.printUsage();
            System.exit(0);
        }
        UserCountUtility.validateArgs(argMap);
        return argMap;
    }

    private static void validateArgs(Map<String, List<String>> argMap) throws UserCountUtilityException {
        HashSet<String> supportedArgs = new HashSet<String>();
        supportedArgs.add("help");
        supportedArgs.add("aggregate");
        supportedArgs.add("log4j-config-path");
        supportedArgs.add("log-path");
        supportedArgs.add("pf-version");
        supportedArgs.add("loglevel");
        supportedArgs.add("aggregate-per-user-session");
        ArrayList<String> errors = new ArrayList<String>();
        for (String arg : argMap.keySet()) {
            String dirName;
            Object f;
            if (!supportedArgs.contains(arg)) {
                errors.add("Unsupported parameter: " + arg);
                continue;
            }
            if (arg.equals("aggregate")) {
                if (argMap.containsKey("help") || argMap.containsKey("log4j-config-path") || argMap.containsKey("log-path") || argMap.containsKey("pf-version")) {
                    errors.add("The aggregate parameter should be specified with out other options, with the exception of optionally specifying loglevel");
                }
                if (argMap.get(arg).size() <= 0) continue;
                List<String> options = argMap.get(arg);
                for (String option : options) {
                    File f2 = new File(option);
                    if (!f2.exists()) {
                        errors.add("File '" + option + "', specified in the aggregate parameter, does not exist");
                        continue;
                    }
                    if (f2.isFile()) continue;
                    errors.add("File '" + option + "', specified in the aggregate parameter, is not a file");
                }
                continue;
            }
            if (arg.equals("log4j-config-path")) {
                if (argMap.containsKey("help") || argMap.containsKey("aggregate")) {
                    errors.add("The log4j-config-path parameter shoud not include other parameters other than log-path and pf-version, and optionally loglevel");
                }
                if (!argMap.containsKey("log-path") || !argMap.containsKey("pf-version")) {
                    errors.add("The log4j-config-path parameter must be specified along with the log-path and pf-version parameters.");
                }
                if (argMap.get(arg).size() != 1) {
                    errors.add("The log4j-config-path parameter requires that the path to a single directory be specified");
                    continue;
                }
                f = new File(argMap.get(arg).get(0));
                if (!((File)f).exists()) {
                    errors.add("Directory '" + ((File)f).toString() + "', specified in the log4j-config-path parameter, does not exist");
                    continue;
                }
                if (!((File)f).isDirectory()) {
                    errors.add("Directory '" + ((File)f).toString() + "', specified in the log4j-config-path parameter, is not a directory");
                    continue;
                }
                dirName = argMap.get(arg).get(0);
                if (!dirName.endsWith(File.separator)) continue;
                argMap.get(arg).set(0, dirName.substring(0, dirName.length() - 1));
                continue;
            }
            if (arg.equals("pf-version")) {
                if (argMap.containsKey("help") || argMap.containsKey("aggregate")) {
                    errors.add("The pf-version parameter should not include other parameters other than log-path and log4j-config-path , and optionally loglevel");
                }
                if (!argMap.containsKey("log-path") || !argMap.containsKey("pf-version")) {
                    errors.add("The pf-version parameter must be specified along with the log-path and log4j-config-path parameters.");
                }
                if (argMap.get(arg).size() != 1) {
                    errors.add("The pf-version parameter requires a single version be specified");
                    continue;
                }
                try {
                    f = new Version(argMap.get(arg).get(0));
                }
                catch (UserCountException e) {
                    errors.add("Version '" + argMap.get(arg).get(0) + "', specified in the pf-version parameter, can not be parsed.");
                }
                continue;
            }
            if (arg.equals("log-path")) {
                if (argMap.containsKey("help") || argMap.containsKey("aggregate")) {
                    errors.add("The log-path parameter should not include other parameters other than possibly log4j-config-path and pf-version and/or optionally loglevel");
                }
                if (argMap.get(arg).size() != 1) {
                    errors.add("The log-path parameter requires that the path to a single directory be specified");
                    continue;
                }
                f = new File(argMap.get(arg).get(0));
                if (!((File)f).exists()) {
                    errors.add("Directory '" + ((File)f).toString() + "', specified in the log-path parameter, does not exist");
                    continue;
                }
                if (!((File)f).isDirectory()) {
                    errors.add("Directory '" + ((File)f).toString() + "', specified in the log-path parameter, is not a directory");
                    continue;
                }
                dirName = argMap.get(arg).get(0);
                if (!dirName.endsWith(File.separator)) continue;
                argMap.get(arg).set(0, dirName.substring(0, dirName.length() - 1));
                continue;
            }
            if (arg.equals("loglevel")) {
                if (argMap.get(arg).size() != 1) {
                    errors.add("The loglevel paramter requires a single number, 1-5");
                    continue;
                }
                if (argMap.get(arg).get(0).matches("[1-5]")) continue;
                errors.add("The loglevel paramter requires a single number, 1-5. The specified value '" + argMap.get(arg).get(0) + "' does not meet this requirement.");
                continue;
            }
            if (!arg.equals("aggregate-per-user-session") || !argMap.containsKey("help") && !argMap.containsKey("log4j-config-path") && !argMap.containsKey("log-path") && !argMap.containsKey("pf-version") && !argMap.containsKey("aggregate")) continue;
            errors.add("The aggregate-per-session parameter should be specified without other options");
        }
        if (!errors.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("\n");
            errorMessage.append("* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \n");
            errorMessage.append("              Problems detected processing command line arguments!              \n");
            errorMessage.append("* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \n");
            errorMessage.append("\n");
            if (errors.size() == 1) {
                errorMessage.append("The following issue was identified:\n");
            } else {
                errorMessage.append("The following issues were identified:\n");
            }
            errorMessage.append("\n");
            for (String error : errors) {
                errorMessage.append(" * " + error + "\n");
            }
            errorMessage.append("\n");
            errorMessage.append("Please review the above and appropriate usage as follows.\n");
            errorMessage.append("* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * \n");
            errorMessage.append("\n");
            Log.info(UserCountUtility.class, errorMessage.toString(), false, true);
            UserCountUtility.printUsage();
            System.exit(0);
        }
    }

    private static void printHeader(boolean aggregatePerUserSession, boolean aggregated) {
        StringBuilder ucuColumnHeader = new StringBuilder();
        ucuColumnHeader.append("\n");
        if (!aggregatePerUserSession) {
            if (!aggregated) {
                ucuColumnHeader.append("Unique Users Per Application\n");
                ucuColumnHeader.append("============================\n\n");
                ucuColumnHeader.append("Application ID                                     User Count\n");
                ucuColumnHeader.append("--------------                                     ----------");
            } else {
                ucuColumnHeader.append("Unique Users Per Application (Aggregated)\n");
                ucuColumnHeader.append("=========================================\n\n");
                ucuColumnHeader.append("Application ID                             User Count\n");
                ucuColumnHeader.append("--------------                             ----------");
            }
        } else if (!aggregated) {
            ucuColumnHeader.append("Unique Users Per Application Type\n");
            ucuColumnHeader.append("=================================\n");
        } else {
            ucuColumnHeader.append("Unique Users Per Application Type (Aggregated)\n");
            ucuColumnHeader.append("==============================================\n");
        }
        Log.info(UserCountUtility.class, String.valueOf(ucuColumnHeader));
    }

    private static String truncateStringAndFillSpace(String str, int maxLength) {
        if (str.length() > maxLength) {
            return str.substring(0, maxLength - 3) + "...";
        }
        return str + UserCountUtility.fillSpace(maxLength - str.length());
    }

    private static String fillSpace(int count) {
        StringBuilder space = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            space.append(" ");
        }
        return String.valueOf(space);
    }

    public static void printUsage() {
        StringBuilder usage = new StringBuilder();
        usage.append("================================================================================\n");
        usage.append("PingFederate User Count Utility (Version " + ucuVersion + ")                        \n");
        usage.append("================================================================================\n");
        usage.append("Usage: usercount.sh [options], or                                                     \n");
        usage.append("       usercount.bat [options]                                                        \n");
        usage.append("                                                                                \n");
        usage.append("================================================================================\n");
        usage.append("                                                                                \n");
        usage.append("Option                          Meaning                                         \n");
        usage.append("  --help                          show this message                             \n");
        usage.append("                                                                                \n");
        usage.append("  --aggregate-per-user-session    aggregate unique users on a per-session basis \n");
        usage.append("                                  Note: This option enables unique user count   \n");
        usage.append("                                  be determined from the tracking ids recorded  \n");
        usage.append("                                  in the audit logs. For large log files, this  \n");
        usage.append("                                  option may potentially incur performance      \n");
        usage.append("                                  issues.                                       \n");
        usage.append("                                                                                \n");
        usage.append("  --aggregate [files...]          aggregate unique users from the specified UCU \n");
        usage.append("                                  output files, or if none are specified all    \n");
        usage.append("                                  .ucu files in the current directory will be   \n");
        usage.append("                                  processed.                                    \n");
        usage.append("                                                                                \n");
        usage.append("  --log4j-config-path <dir-path>  location of log4j2 configuration files (*)    \n");
        usage.append("                                                                                \n");
        usage.append("  --log-path <dir-path>           location of audit log files (*)               \n");
        usage.append("                                                                                \n");
        usage.append("  --pf-version <version>          version of PingFederate that generated the    \n");
        usage.append("                                  logs (*)                                      \n");
        usage.append("                                                                                \n");
        usage.append("  --loglevel <1-5>                override the default log level (INFO). All    \n");
        usage.append("                                  levels less than or equal to the specified    \n");
        usage.append("                                  level will be logged. Only ERROR, WARN and    \n");
        usage.append("                                  INFO will be written to the console, while    \n");
        usage.append("                                  everything will be written to 'usercount.log' \n");
        usage.append("                                  in current working directory. Log levels are  \n");
        usage.append("                                  as follows:                                   \n");
        usage.append("                                  1=ERROR, 2=WARN, 3=INFO, 4=DEBUG, 5=TRACE     \n");
        usage.append("                                                                                \n");
        usage.append("                                                                                \n");
        usage.append("--------------------------------------------------------------------------------\n");
        usage.append("(*)NOTE:                                                                        \n");
        usage.append("--------------------------------------------------------------------------------\n");
        usage.append("  If audit log files to be processed are in a location other than the           \n");
        usage.append("  location(s) specified in the log4j2.xml found in the                          \n");
        usage.append("  pingfederate/server/default/conf directory, you will need to override this    \n");
        usage.append("  location using the --log-path option.                                         \n");
        usage.append("                                                                                \n");
        usage.append("  If the log4j2.xml files have changed since the logs to                        \n");
        usage.append("  be processed were generated, you may need to override the current log4j       \n");
        usage.append("  configuration using the --log4j-config-path option. The path specified should \n");
        usage.append("  be a directory that contains the log4j2.xml that was used when                \n");
        usage.append("  the logs were created. Additionally, if auditing to a database is/was used,   \n");
        usage.append("  log4j2.db.properties will also need to be included in this directory (only if \n");
        usage.append("  log4j2 is used).                                                              \n");
        usage.append("                                                                                \n");
        usage.append("  If --log4j-config-path or --pf-version must be specified, both are required in\n");
        usage.append("  addition to --log-path.                                                       \n");
        usage.append("                                                                                \n");
        usage.append("  The --pf-version parameter must only be specified when used in combination    \n");
        usage.append("  with the --log4j-config-path and --log-path parameters. The following         \n");
        usage.append("  demonstrates how to specify PingFederate version 8.3.0:                       \n");
        usage.append("    --pf-version 8.3.0                                                          \n");
        usage.append("--------------------------------------------------------------------------------\n");
        usage.append("                                                                                \n");
        Log.info(UserCountUtility.class, usage.toString(), false, true);
    }

    public static void logVersion() {
        StringBuilder versionStr = new StringBuilder();
        versionStr.append("================================================================================\n");
        versionStr.append("PingFederate User Count Utility (Version " + ucuVersion + ")\n");
        versionStr.append("================================================================================\n");
        Log.info(UserCountUtility.class, versionStr.toString(), true, false);
    }

    private static void logArgMap(Map<String, List<String>> map) {
        Log.info(UserCountUtility.class, "----------------------------------------", true, false);
        Log.info(UserCountUtility.class, "Command line arguments: " + map.keySet().size(), true, false);
        Log.info(UserCountUtility.class, "----------------------------------------", true, false);
        if (map.keySet().size() > 0) {
            for (String key : map.keySet()) {
                Log.info(UserCountUtility.class, key, true, false);
                for (String val : map.get(key)) {
                    Log.info(UserCountUtility.class, "    " + val, true, false);
                }
                Log.info(UserCountUtility.class, "----------------------------------------", true, false);
            }
        }
    }
}

