/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.conf;

import com.pingidentity.pf.support.ucu.util.Regex;
import java.io.File;
import java.util.HashMap;
import java.util.Set;

public class AppenderConfig {
    private String type;
    private String name;
    private String fileName;
    private String filePattern;
    private String pattern;
    private String databaseType;
    private String databaseUrl;
    private String databaseDriver;
    private String databaseUsername;
    private String databasePassword;
    private String tableName;
    private String pfVersion;
    private HashMap<String, String> patternsToColumnNames;
    private HashMap<String, String> columnNamesToPatterns;

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public void setDatabaseDriver(String databaseDriver) {
        this.databaseDriver = databaseDriver;
    }

    public void setDatabaseUsername(String databaseUsername) {
        this.databaseUsername = databaseUsername;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPfVersion(String pfVersion) {
        this.pfVersion = pfVersion;
    }

    public void addColumn(String columnName, String columnPattern) {
        if (this.columnNamesToPatterns == null) {
            this.columnNamesToPatterns = new HashMap();
        }
        if (this.patternsToColumnNames == null) {
            this.patternsToColumnNames = new HashMap();
        }
        this.columnNamesToPatterns.put(columnName, columnPattern);
        this.patternsToColumnNames.put(columnPattern, columnName);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Set<String> getColumnNames() {
        return this.columnNamesToPatterns.keySet();
    }

    public String getPatternForColumnName(String columnName) {
        return this.columnNamesToPatterns.get(columnName);
    }

    public Set<String> getPatterns() {
        return this.patternsToColumnNames.keySet();
    }

    public String getColumnNameForPattern(String pattern) {
        String retval = this.patternsToColumnNames.get(pattern);
        if (retval == null) {
            return "";
        }
        return retval;
    }

    public String getPfVersion() {
        return this.pfVersion;
    }

    public File getLogDir() {
        File result = new File(this.fileName).getParentFile();
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("AppenderConfig: " + this.name + "\n");
        result.append("----------------------------------------\n");
        result.append("    name             : " + this.name + "\n");
        result.append("    type             : " + this.type + "\n");
        switch (this.type) {
            case "RollingFile": 
            case "org.jboss.logging.appender.DailyRollingFileAppender": 
            case "org.jboss.logging.appender.RollingFileAppender": 
            case "org.apache.log4j.DailyRollingFileAppender": {
                result.append("    fileName         : " + this.fileName + "\n");
                result.append("    filePattern      : " + Regex.unmaskRegex(this.filePattern) + "\n");
                result.append("    pattern          : " + this.pattern + "\n");
                break;
            }
            case "JDBC": 
            case "org.apache.log4j.jdbc.PingJDBCAppender": {
                result.append("    databaseType     : " + this.databaseType + "\n");
                result.append("    databaseDriver   : " + this.databaseDriver + "\n");
                result.append("    databaseUrl      : " + this.databaseUrl + "\n");
                result.append("    databaseUsername : " + this.databaseUsername + "\n");
                result.append("    tableName    : " + this.tableName + "\n");
                result.append("    columns      :\n");
                for (String columnName : this.columnNamesToPatterns.keySet()) {
                    result.append("        column  : " + columnName + "\n");
                    result.append("        pattern : " + this.columnNamesToPatterns.get(columnName) + "\n\n");
                }
                break;
            }
            default: {
                result.append("WARNING: Unsupported Appender type.\n");
            }
        }
        result.append("----------------------------------------\n");
        return result.toString();
    }
}

