/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.conf;

import com.pingidentity.pf.support.ucu.conf.AppenderConfig;
import com.pingidentity.pf.support.ucu.conf.Log4j2ConfigParser;
import com.pingidentity.pf.support.ucu.exception.UserCountException;
import com.pingidentity.pf.support.ucu.util.PropertiesUtil;
import com.pingidentity.pf.support.ucu.util.Version;
import java.io.File;
import java.util.List;

public class ConfigParser {
    private Version version;
    private String configPath = null;
    private String logPath = null;

    public ConfigParser(String pingfederatePath) throws UserCountException {
        PropertiesUtil.loadProperties();
        this.configPath = pingfederatePath + File.separator + "server" + File.separator + "default" + File.separator + "conf";
        this.logPath = "";
        this.version = Version.getPingFederateVersion(pingfederatePath);
    }

    public ConfigParser(String configPath, String logPath, Version version) {
        this.configPath = configPath;
        this.logPath = logPath;
        this.version = version;
        System.setProperty("pf.log.dir", logPath);
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public List<AppenderConfig> parse() {
        return Log4j2ConfigParser.parse(this.configPath, this.logPath, this.version);
    }
}

