/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.conf;

import com.pingidentity.crypto.Password;
import com.pingidentity.pf.support.ucu.Log;
import com.pingidentity.pf.support.ucu.conf.AppenderConfig;
import com.pingidentity.pf.support.ucu.util.Regex;
import com.pingidentity.pf.support.ucu.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Log4j2ConfigParser {
    public static List<AppenderConfig> parse(String configPath, String logPath, Version version) {
        ArrayList<AppenderConfig> result = new ArrayList<AppenderConfig>();
        ArrayList<String> loggerNames = new ArrayList<String>();
        loggerNames.add("org.sourceid.websso.profiles.sp.SpAuditLogger");
        loggerNames.add("org.sourceid.websso.profiles.idp.IdpAuditLogger");
        loggerNames.add("org.sourceid.websso.profiles.idp.AsAuditLogger");
        loggerNames.add("org.sourceid.wstrust.log.STSAuditLogger");
        ArrayList<String> appenders = new ArrayList<String>();
        String configFile = configPath + File.separator + "log4j2.xml";
        String propertiesFile = configPath + File.separator + "log4j2.db.properties";
        String FEATURE = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            factory.setFeature(FEATURE, true);
            FEATURE = "http://xml.org/sax/features/namespaces";
            factory.setFeature(FEATURE, false);
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            factory.setFeature(FEATURE, false);
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            factory.setFeature(FEATURE, false);
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
            factory.setFeature(FEATURE, false);
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            factory.setFeature(FEATURE, false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(configFile);
            NodeList list = document.getElementsByTagName("Logger");
            for (int i = 0; i < list.getLength(); ++i) {
                Element logger = (Element)list.item(i);
                String name = logger.getAttribute("name");
                if (!loggerNames.contains(name)) continue;
                NodeList appenderRefs = logger.getElementsByTagName("appender-ref");
                if (appenderRefs.getLength() == 1) {
                    Element appenderRef = (Element)appenderRefs.item(0);
                    String ref = appenderRef.getAttribute("ref");
                    if (appenders.contains(ref)) continue;
                    appenders.add(ref);
                    continue;
                }
                Log.error(Log4j2ConfigParser.class, "ERROR: More than one appender-ref!");
            }
            if (!appenders.isEmpty()) {
                Map<String, Element> appenderElementMap = Log4j2ConfigParser.getAppenderElementMap(document);
                ArrayList<String> processedAppenders = new ArrayList<String>();
                block16: while (!appenders.isEmpty()) {
                    String appenderName = (String)appenders.remove(0);
                    processedAppenders.add(appenderName);
                    if (appenderElementMap.containsKey(appenderName)) {
                        Element appender = appenderElementMap.get(appenderName);
                        AppenderConfig appenderConfig = new AppenderConfig();
                        switch (appender.getTagName()) {
                            case "RollingFile": {
                                Log4j2ConfigParser.getRollingFileAppenderConfig(appender, appenderConfig, version, logPath);
                                result.add(appenderConfig);
                                break;
                            }
                            case "JDBC": {
                                Log4j2ConfigParser.getJDBCAppenderConfig(appender, appenderConfig, version, propertiesFile);
                                result.add(appenderConfig);
                                break;
                            }
                            case "PingFailover": {
                                String failoverAppender;
                                String primaryAppender = appender.getAttribute("primary");
                                if (!appenders.contains(primaryAppender) && !processedAppenders.contains(primaryAppender)) {
                                    appenders.add(primaryAppender);
                                }
                                if (appenders.contains(failoverAppender = ((Element)((Element)appender.getElementsByTagName("Failovers").item(0)).getElementsByTagName("AppenderRef").item(0)).getAttribute("ref")) || processedAppenders.contains(failoverAppender)) continue block16;
                                appenders.add(failoverAppender);
                                break;
                            }
                            default: {
                                Log.warn(Log4j2ConfigParser.class, "Unsupported Appender Type: " + appenderConfig.getType());
                                break;
                            }
                        }
                        continue;
                    }
                    Log.warn(Log4j2ConfigParser.class, "Appender not found: " + appenderName);
                }
            } else {
                Log.error(Log4j2ConfigParser.class, "ERROR: No appenders found!");
            }
            for (AppenderConfig appenderConfig : result) {
                Log.debug(Log4j2ConfigParser.class, appenderConfig.toString());
            }
        }
        catch (FactoryConfigurationError e) {
            Log.error(Log4j2ConfigParser.class, "Caught exception: unable to get a document builder factory: " + e);
        }
        catch (ParserConfigurationException e) {
            Log.error(Log4j2ConfigParser.class, "Parser was unable to be configured; The feature '" + FEATURE + "' is probably not supported by your XML processor:" + e);
        }
        catch (SAXException e) {
            Log.error(Log4j2ConfigParser.class, "Caught exception: parsing error - A DOCTYPE was probably passed into the XML document: " + e);
        }
        catch (IOException e) {
            Log.error(Log4j2ConfigParser.class, "IOException occurred, XML eXternal Entity injection (XXE) may still possible: " + e.getMessage());
        }
        return result;
    }

    private static Map<String, Element> getAppenderElementMap(Document document) {
        HashMap<String, Element> result = new HashMap<String, Element>();
        if (document.getElementsByTagName("Appenders").getLength() == 1) {
            NodeList list = document.getElementsByTagName("Appenders").item(0).getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!(list.item(i) instanceof Element)) continue;
                Element appender = (Element)list.item(i);
                String name = appender.getAttribute("name");
                result.put(name, appender);
            }
        } else {
            Log.error(Log4j2ConfigParser.class, "ERROR: More than one Appenders element found!?");
        }
        return result;
    }

    private static void getRollingFileAppenderConfig(Element appender, AppenderConfig appenderConfig, Version version, String logPath) {
        appenderConfig.setType(appender.getTagName());
        appenderConfig.setName(appender.getAttribute("name"));
        appenderConfig.setPfVersion(version.toString());
        appenderConfig.setFileName(Log4j2ConfigParser.doFileNameSubstitution(appender.getAttribute("fileName"), logPath));
        appenderConfig.setFilePattern(Log4j2ConfigParser.doFilePatternSubstitution(Log4j2ConfigParser.doFileNameSubstitution(appender.getAttribute("filePattern"), logPath)));
        Element patternLayout = (Element)appender.getElementsByTagName("PatternLayout").item(0);
        Element pattern = (Element)patternLayout.getElementsByTagName("pattern").item(0);
        appenderConfig.setPattern(pattern.getTextContent());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getJDBCAppenderConfig(Element appender, AppenderConfig appenderConfig, Version version, String propertiesFile) throws FileNotFoundException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
            appenderConfig.setType(appender.getTagName());
            appenderConfig.setName(appender.getAttribute("name"));
            appenderConfig.setPfVersion(version.toString());
            appenderConfig.setTableName(appender.getAttribute("tableName"));
            NodeList columnList = appender.getElementsByTagName("Column");
            for (int j = 0; j < columnList.getLength(); ++j) {
                Element column = (Element)columnList.item(j);
                appenderConfig.addColumn(column.getAttribute("name"), column.getAttribute("pattern"));
            }
            Element connectionFactory = (Element)appender.getElementsByTagName("ConnectionFactory").item(0);
            String method = connectionFactory.getAttribute("method");
            Properties props = new Properties();
            props.load(fileInputStream);
            switch (method) {
                case "getOracleDatabaseConnection": {
                    appenderConfig.setDatabaseType("oracle");
                    appenderConfig.setDatabaseUrl(props.getProperty("oracle.url"));
                    appenderConfig.setDatabaseUsername(props.getProperty("oracle.username"));
                    appenderConfig.setDatabasePassword(Log4j2ConfigParser.deobfuscatePassword(props.getProperty("oracle.password")));
                    return;
                }
                case "getSQLServerDatabaseConnection": {
                    appenderConfig.setDatabaseType("sqlserver");
                    appenderConfig.setDatabaseUrl(props.getProperty("sqlserver.url"));
                    appenderConfig.setDatabaseUsername(props.getProperty("sqlserver.username"));
                    appenderConfig.setDatabasePassword(Log4j2ConfigParser.deobfuscatePassword(props.getProperty("sqlserver.password")));
                    return;
                }
                case "getMySQLDatabaseConnection": {
                    appenderConfig.setDatabaseType("mysql");
                    appenderConfig.setDatabaseUrl(props.getProperty("mysql.url"));
                    appenderConfig.setDatabaseUsername(props.getProperty("mysql.username"));
                    appenderConfig.setDatabasePassword(Log4j2ConfigParser.deobfuscatePassword(props.getProperty("mysql.password")));
                    return;
                }
                default: {
                    Log.warn(Log4j2ConfigParser.class, "WARNING: Unsupported database type got method: " + method);
                    return;
                }
            }
        }
    }

    private static String deobfuscatePassword(String password) {
        GlobalRegistry.getRegistry();
        Password p = new Password(password);
        return p.getStrValue();
    }

    private static String doFileNameSubstitution(String str, String logPath) {
        if (str.matches("^.*\\$\\{.+?}.*$")) {
            Pattern pattern = Pattern.compile("^(.*)(\\$\\{.+?})(.*)$");
            Matcher matcher = pattern.matcher(str);
            if (matcher.find()) {
                String prop = matcher.group(2);
                if ((prop = prop.substring(2, prop.length() - 1)).startsWith("sys:")) {
                    if (logPath.isEmpty()) {
                        String propval = System.getProperty(prop = prop.substring(4));
                        if (propval == null || propval.equals("")) {
                            Log.warn(Log4j2ConfigParser.class, "Unable to resolve System Property: " + prop);
                            return str;
                        }
                        return Log4j2ConfigParser.doFileNameSubstitution(matcher.group(1) + propval + matcher.group(3), logPath);
                    }
                    return Log4j2ConfigParser.doFileNameSubstitution(matcher.group(1) + logPath + matcher.group(3), logPath);
                }
                Log.warn(Log4j2ConfigParser.class, "Do not know how to resolve: " + prop);
                return str;
            }
            return str;
        }
        return str.replaceAll("/", Regex.escapeSpecialChars(File.separator));
    }

    private static String doFilePatternSubstitution(String str) {
        if (str.matches("^.*%d\\{.+?}.*$")) {
            Pattern pattern = Pattern.compile("^(.*)%d\\{(.+?)}(.*)$");
            Matcher matcher = pattern.matcher(str);
            matcher.find();
            String format = matcher.group(2);
            format = Regex.getDateFormatRegex(format);
            return Log4j2ConfigParser.doFilePatternSubstitution(matcher.group(1) + Regex.maskRegex(format) + matcher.group(3));
        }
        return str.replaceAll("/", Regex.escapeSpecialChars(File.separator)).replaceAll("%i", Regex.maskRegex("[0-9]+"));
    }
}

