/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.doer;

import com.pingidentity.pf.support.ucu.conf.AppenderConfig;
import com.pingidentity.pf.support.ucu.doer.DatabaseDoerImpl;
import com.pingidentity.pf.support.ucu.doer.Doer;
import com.pingidentity.pf.support.ucu.doer.RegexDoerImpl;
import java.util.ArrayList;
import java.util.List;

public class DoerFactory {
    public static Doer getDoer(AppenderConfig appenderConfig) {
        switch (appenderConfig.getType()) {
            case "RollingFile": 
            case "org.jboss.logging.appender.DailyRollingFileAppender": 
            case "org.jboss.logging.appender.RollingFileAppender": 
            case "org.apache.log4j.DailyRollingFileAppender": {
                return new RegexDoerImpl(appenderConfig);
            }
            case "JDBC": 
            case "org.apache.log4j.jdbc.PingJDBCAppender": {
                return new DatabaseDoerImpl(appenderConfig);
            }
        }
        return null;
    }

    public static List<Doer> getDoers(List<AppenderConfig> appenderConfigs) {
        ArrayList<Doer> doers = new ArrayList<Doer>();
        for (AppenderConfig appenderConfig : appenderConfigs) {
            doers.add(DoerFactory.getDoer(appenderConfig));
        }
        return doers;
    }
}

