/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.doer;

import com.pingidentity.pf.support.ucu.Aggregator;
import com.pingidentity.pf.support.ucu.Log;
import com.pingidentity.pf.support.ucu.conf.AppenderConfig;
import com.pingidentity.pf.support.ucu.doer.Doer;
import com.pingidentity.pf.support.ucu.exception.UserCountException;
import com.pingidentity.pf.support.ucu.exception.UserCountUtilityException;
import com.pingidentity.pf.support.ucu.util.Regex;
import com.pingidentity.pf.support.ucu.util.RegexFileFilter;
import com.pingidentity.pf.support.ucu.util.UniqueUser;
import com.pingidentity.pf.support.ucu.util.User;
import com.pingidentity.pf.support.ucu.util.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexDoerImpl
extends Doer {
    private AppenderConfig appenderConfig;

    public RegexDoerImpl(AppenderConfig appenderConfig) {
        this.appenderConfig = appenderConfig;
    }

    @Override
    public Map<String, List<UniqueUser>> doitPerSession() throws UserCountUtilityException {
        boolean perSession = true;
        List<Aggregator> aggregators = this.readLogsAndPopulateAggregators(perSession);
        return this.doAggregationPerSession(aggregators);
    }

    @Override
    public Map<String, Set<String>> doitPerApp() throws UserCountException {
        boolean perSession = false;
        List<Aggregator> aggregators = this.readLogsAndPopulateAggregators(perSession);
        return this.doAggregationPerApp(aggregators);
    }

    public List<Aggregator> readLogsAndPopulateAggregators(boolean perSession) {
        List<File> logFile;
        String pattern = this.appenderConfig.getPattern();
        String regexString = "";
        try {
            regexString = Regex.getRegex(this.appenderConfig.getPfVersion(), pattern);
        }
        catch (Throwable t) {
            Log.error(this.getClass(), t);
        }
        Pattern p = Pattern.compile(regexString);
        Log.trace(this.getClass(), "log4j pattern = " + pattern);
        Log.trace(this.getClass(), "regexString = " + regexString);
        boolean containsEvent = regexString.contains("(?<event>");
        boolean containsSubject = regexString.contains("(?<subject>");
        boolean containsTrackingid = regexString.contains("(?<trackingid>");
        boolean containsRole = regexString.contains("(?<role>");
        boolean containsConnectionid = regexString.contains("(?<connectionid>");
        boolean containsStatus = regexString.contains("(?<status>");
        if (!containsSubject) {
            Log.error(this.getClass(), "No subject found in appender config. Skipping this appender.");
        }
        if (!containsRole) {
            Log.debug(this.getClass(), "No role found in appender config. Proceeding without it.");
        }
        if (!containsConnectionid) {
            Log.debug(this.getClass(), "No connectionid found in appender config. Proceeding without it.");
        }
        if (!containsTrackingid) {
            Log.debug(this.getClass(), "No trackingid found in appender config. Proceeding without it.");
        }
        if ((logFile = this.getFiles()).isEmpty()) {
            Log.error(this.getClass(), "No logs to parse for this appender");
            return null;
        }
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        Aggregator aggregator = new Aggregator();
        Aggregator ssoAggregator = new Aggregator();
        ssoAggregator.setEvent("SSO");
        Aggregator oauthAggregator = new Aggregator();
        oauthAggregator.setEvent("OAuth");
        Aggregator stsAggregator = new Aggregator();
        stsAggregator.setEvent("STS");
        int recordCount = 0;
        for (int fileNum = 0; fileNum < logFile.size(); ++fileNum) {
            try {
                String fileName = this.appenderConfig.getLogDir() + File.separator + logFile.get(fileNum).getName();
                Log.debug(this.getClass(), "Processing " + fileName);
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                String line = in.readLine();
                while (line != null) {
                    User tempUser = new User();
                    Matcher m = p.matcher(line);
                    if (m.matches()) {
                        if (containsRole && m.group("role") != null) {
                            try {
                                tempUser.role = m.group("role");
                            }
                            catch (IllegalArgumentException e) {
                                tempUser.role = "";
                            }
                        }
                        if (containsConnectionid && m.group("connectionid") != null) {
                            try {
                                tempUser.connectionid = m.group("connectionid");
                            }
                            catch (IllegalArgumentException e) {
                                tempUser.connectionid = "";
                            }
                        }
                        try {
                            tempUser.subject = m.group("subject");
                        }
                        catch (IllegalArgumentException e) {
                            Log.debug(this.getClass(), "No subject, skipping line " + recordCount + " in file: " + fileName);
                            tempUser.subject = "";
                        }
                        if (perSession) {
                            if (containsTrackingid && m.group("trackingid") != null) {
                                try {
                                    tempUser.trackingid = m.group("trackingid");
                                }
                                catch (IllegalArgumentException e) {
                                    tempUser.trackingid = "";
                                }
                            } else {
                                tempUser.trackingid = "";
                            }
                        }
                        if ((!containsStatus || containsStatus && "success".equals(m.group("status"))) && containsEvent && m.group("event") != null) {
                            try {
                                String event = m.group("event");
                                if ("SSO".equals(event)) {
                                    this.addUserForAggregation(perSession, ssoAggregator, tempUser);
                                } else if ("STS".equals(event)) {
                                    this.addUserForAggregation(perSession, stsAggregator, tempUser);
                                } else if ("OAuth".equals(event)) {
                                    this.addUserForAggregation(perSession, oauthAggregator, tempUser);
                                }
                                if (!("SLO".equals(event) || "GET User".equals(event) || "POST User".equals(event) || "PUT User".equals(event) || "PATCH User".equals(event))) {
                                    aggregator.addUser(tempUser);
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                    } else {
                        Log.trace(this.getClass(), "No match on line " + recordCount + " in file: " + fileName + "\n" + line);
                    }
                    line = in.readLine();
                    ++recordCount;
                }
                in.close();
                Log.info(this.getClass(), "Processed file: " + fileName);
                continue;
            }
            catch (IOException e) {
                Log.error(this.getClass(), "Caught exception: " + e);
            }
        }
        Log.debug(this.getClass(), "Total number of audit log entries parsed: " + recordCount);
        aggregators.add(ssoAggregator);
        aggregators.add(stsAggregator);
        aggregators.add(oauthAggregator);
        aggregators.add(aggregator);
        return aggregators;
    }

    private void addUserForAggregation(boolean perSession, Aggregator aggregator, User tempUser) {
        if (perSession) {
            aggregator.addUser(tempUser);
        } else {
            aggregator.addUserToAggregatePerApp(tempUser);
        }
    }

    private List<File> getFiles() {
        ArrayList<File> logFile = new ArrayList<File>();
        File defaultLogFile = new File(this.appenderConfig.getFileName());
        if (defaultLogFile.exists()) {
            logFile.add(defaultLogFile);
        } else {
            Log.warn(this.getClass(), "Log file '" + defaultLogFile.getAbsolutePath() + "' does not exist");
        }
        String filePattern = "";
        try {
            filePattern = Version.compare(this.appenderConfig.getPfVersion(), "8.0.0") < 0 ? this.appenderConfig.getFileName() + this.appenderConfig.getFilePattern() : this.appenderConfig.getFilePattern();
        }
        catch (UserCountException e1) {
            Log.error(this.getClass(), "Error parsing version string for AppenderConfig", e1);
        }
        File logDir = new File(filePattern).getParentFile();
        if (logDir != null) {
            if (logDir.exists()) {
                File[] files;
                RegexFileFilter filter = new RegexFileFilter(Regex.unmaskRegex(Regex.escapeSpecialChars(filePattern)));
                for (File f : files = logDir.listFiles(filter)) {
                    logFile.add(f);
                }
            } else {
                Log.warn(this.getClass(), "Log directory'" + logDir.toString() + "' does not exist");
            }
        } else {
            Log.warn(this.getClass(), "Unable to get the parent directory for '" + filePattern + "'");
        }
        return logFile;
    }
}

