/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.util;

import com.pingidentity.pf.support.ucu.util.SetUtil;
import com.pingidentity.pf.support.ucu.util.User;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ucu-shaded.org.jose4j.json.internal.json_simple.JSONObject;

public class UniqueUser {
    public static final String TRACKING_IDS = "trackingids";
    public static final String SUBJECT_ROLE_CONNECTION_IDS = "subjectRoleConnectionids";
    public static final String EVENT = "event";
    Set<String> trackingid;
    Set<String> subjectRoleConnectionid;
    Set<String> appUserId;
    String event;

    public UniqueUser() {
        this.trackingid = new HashSet<String>();
        this.subjectRoleConnectionid = new HashSet<String>();
        this.appUserId = new HashSet<String>();
        this.event = "";
    }

    public UniqueUser(User u) {
        this.event = "";
        this.trackingid = new HashSet<String>();
        this.subjectRoleConnectionid = new HashSet<String>();
        this.subjectRoleConnectionid.add(u.subject + u.role + u.connectionid);
        this.trackingid.add(u.trackingid);
    }

    public UniqueUser(String combinedSubjectRoleConnectionid, String trackingid) {
        this.event = "";
        this.trackingid = new HashSet<String>();
        this.subjectRoleConnectionid = new HashSet<String>();
        this.subjectRoleConnectionid.add(combinedSubjectRoleConnectionid);
        this.trackingid.add(trackingid);
    }

    public UniqueUser(UniqueUser u) {
        this.event = "";
        this.trackingid = new HashSet<String>();
        this.subjectRoleConnectionid = new HashSet<String>();
        this.subjectRoleConnectionid.addAll(u.subjectRoleConnectionid);
        this.trackingid.addAll(u.trackingid);
    }

    public void setEvent(String e) {
        this.event = e;
    }

    public String getEvent() {
        return this.event;
    }

    public void addAltUser(User u) {
        this.addAltUser(u.subject + u.role + u.connectionid, u.trackingid);
    }

    public void addAltUser(String combinedSubjectRoleConnectionid, String trackingid) {
        this.addAltUserTrackingId(trackingid);
        this.addAltUserId(combinedSubjectRoleConnectionid);
    }

    public void addAltUserId(String combinedSubjectRoleConnectionid) {
        if (!this.subjectRoleConnectionid.contains(combinedSubjectRoleConnectionid)) {
            this.subjectRoleConnectionid.add(combinedSubjectRoleConnectionid);
        }
    }

    public void addAltUserTrackingId(String trackingid) {
        if (!this.trackingid.contains(trackingid)) {
            this.trackingid.add(trackingid);
        }
    }

    public void addAltUser(UniqueUser u) {
        if (!SetUtil.containsAny(this.trackingid, u.trackingid)) {
            this.trackingid.addAll(u.trackingid);
        } else {
            SetUtil.addAllUnique(this.trackingid, u.trackingid);
        }
        if (!SetUtil.containsAny(this.subjectRoleConnectionid, u.subjectRoleConnectionid)) {
            this.subjectRoleConnectionid.addAll(u.subjectRoleConnectionid);
        } else {
            SetUtil.addAllUnique(this.subjectRoleConnectionid, u.subjectRoleConnectionid);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof UniqueUser) {
            UniqueUser u = (UniqueUser)o;
            return SetUtil.containsAny(u.subjectRoleConnectionid, this.subjectRoleConnectionid) || SetUtil.containsAny(u.trackingid, this.trackingid);
        }
        return false;
    }

    public String serialize() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put(EVENT, this.event);
        jsonMap.put(SUBJECT_ROLE_CONNECTION_IDS, this.subjectRoleConnectionid);
        jsonMap.put(TRACKING_IDS, this.trackingid);
        StringBuffer result = new StringBuffer();
        return JSONObject.toJSONString(jsonMap);
    }

    public void addSubjectRoleConnectionids(List<String> subjectRoleConnectionid) {
        this.subjectRoleConnectionid.addAll(subjectRoleConnectionid);
    }

    public Set<String> getSubjectRoleConnectionIds() {
        return this.subjectRoleConnectionid;
    }

    public Set<String> getTrackingIds() {
        return this.trackingid;
    }

    public void addAppUserIds(List<String> appUserIds) {
        this.appUserId.addAll(appUserIds);
    }
}

