/*
 * Decompiled with CFR 0.152.
 */
package ucu-shaded.com.pingidentity.pingcommons.upgrade.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import ucu-shaded.org.apache.commons.compress.archivers.ArchiveInputStream;
import ucu-shaded.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import ucu-shaded.org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import ucu-shaded.org.apache.commons.io.FileUtils;
import ucu-shaded.org.apache.commons.io.IOUtils;

public class UnzipUtil {
    public static File unGZip(File inputFile) throws IOException {
        return UnzipUtil.unGZip(inputFile, inputFile.getParentFile());
    }

    public static File unGZip(File inputFile, File outputDir) throws IOException {
        File outputFile = new File(outputDir, inputFile.getName().substring(0, inputFile.getName().length() - 3));
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(inputFile));
        FileOutputStream out = new FileOutputStream(outputFile);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.close();
        return outputFile;
    }

    public static void deployToFilesystem(String directory, File archiveToImport) throws IOException {
        HashSet<String> sanitizedRootFiles = new HashSet<String>();
        byte[] buffer = new byte[8192];
        try (ArchiveInputStream zipInputStream = UnzipUtil.getInputStream(archiveToImport);){
            Object zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int count;
                boolean initFile = true;
                String entryName = zipEntry.getName();
                int firstSlash = entryName.indexOf("/");
                String rootName = entryName;
                if (firstSlash != -1) {
                    rootName = entryName.substring(0, firstSlash);
                }
                File unzippedFile = new File(directory, entryName);
                FileOutputStream fileOutputStream = null;
                if (entryName.endsWith(".placeholder")) {
                    UnzipUtil.initFile(sanitizedRootFiles, directory, rootName, unzippedFile);
                    initFile = false;
                }
                while ((count = zipInputStream.read(buffer, 0, buffer.length)) != -1) {
                    if (initFile && count > 0) {
                        UnzipUtil.initFile(sanitizedRootFiles, directory, rootName, unzippedFile);
                        initFile = false;
                    }
                    if (fileOutputStream == null) {
                        fileOutputStream = new FileOutputStream(unzippedFile);
                    }
                    fileOutputStream.write(buffer, 0, count);
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (!entryName.endsWith(".sh")) continue;
                unzippedFile.setExecutable(true, false);
            }
        }
    }

    private static void initFile(Set<String> sanitizedRootFiles, String directory, String rootName, File unzippedFile) throws IOException {
        if (!sanitizedRootFiles.contains(rootName)) {
            File fileToDelete = new File(directory, rootName);
            if (fileToDelete.exists()) {
                if (fileToDelete.isDirectory()) {
                    FileUtils.deleteDirectory(fileToDelete);
                } else {
                    Files.delete(fileToDelete.toPath());
                }
            }
            sanitizedRootFiles.add(rootName);
        }
        unzippedFile.getParentFile().mkdirs();
        unzippedFile.createNewFile();
    }

    private static ArchiveInputStream getInputStream(File archive) throws IOException {
        if (archive.getName().endsWith(".tar.gz")) {
            File tar = UnzipUtil.unGZip(archive);
            return UnzipUtil.getInputStream(tar);
        }
        if (archive.getName().endsWith(".tar")) {
            FileInputStream archiveInputStream = new FileInputStream(archive);
            return new TarArchiveInputStream(archiveInputStream);
        }
        if (archive.getName().endsWith(".zip") || archive.getName().endsWith(".jar")) {
            FileInputStream archiveInputStream = new FileInputStream(archive);
            return new ZipArchiveInputStream(archiveInputStream);
        }
        FileInputStream archiveInputStream = new FileInputStream(archive);
        return new ZipArchiveInputStream(archiveInputStream);
    }

    public static String findRootDirInArchive(File archive) throws IOException {
        try (ArchiveInputStream archiveInputStream = UnzipUtil.getInputStream(archive);){
            Object archiveEntry;
            while ((archiveEntry = archiveInputStream.getNextEntry()) != null) {
                String entryName = archiveEntry.getName();
                int firstSlash = entryName.indexOf("/");
                if (firstSlash == -1) continue;
                String string = entryName.substring(0, firstSlash);
                return string;
            }
        }
        return null;
    }
}

