/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.security.Key;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import jcifs.smb.MIEName;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class Kerb5Context {
    private static final String OID = "1.2.840.113554.1.2.2";
    private GSSContext gssContext;
    static /* synthetic */ Class class$javax$security$auth$kerberos$KerberosTicket;

    Kerb5Context(String host, String service, String name, int userLifetime, int contextLifetime) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        Oid oid = null;
        GSSName serviceName = null;
        GSSName clientName = null;
        GSSCredential clientCreds = null;
        oid = new Oid(OID);
        serviceName = manager.createName(service + "@" + host, GSSName.NT_HOSTBASED_SERVICE, oid);
        if (name != null) {
            clientName = manager.createName(name, GSSName.NT_USER_NAME, oid);
            clientCreds = manager.createCredential(clientName, userLifetime, oid, 1);
        }
        this.gssContext = manager.createContext(serviceName, oid, clientCreds, contextLifetime);
    }

    GSSContext getGSSContext() {
        return this.gssContext;
    }

    Key searchSessionKey(Subject subject) throws GSSException {
        MIEName src = new MIEName(this.gssContext.getSrcName().export());
        MIEName targ = new MIEName(this.gssContext.getTargName().export());
        Iterator iter = subject.getPrivateCredentials(class$javax$security$auth$kerberos$KerberosTicket == null ? (class$javax$security$auth$kerberos$KerberosTicket = Kerb5Context.class$("javax.security.auth.kerberos.KerberosTicket")) : class$javax$security$auth$kerberos$KerberosTicket).iterator();
        while (iter.hasNext()) {
            KerberosTicket ticket = (KerberosTicket)iter.next();
            MIEName client = new MIEName(this.gssContext.getMech(), ticket.getClient().getName());
            MIEName server = new MIEName(this.gssContext.getMech(), ticket.getServer().getName());
            if (!src.equals(client) || !targ.equals(server)) continue;
            return ticket.getSessionKey();
        }
        return null;
    }

    public void dispose() throws GSSException {
        if (this.gssContext != null) {
            this.gssContext.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

