/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.pf.adapters.referenceid.AttributeDeserializer;
import com.pingidentity.pf.adapters.referenceid.AttributeSerializer;
import com.pingidentity.pf.adapters.referenceid.BackchannelCreds;
import com.pingidentity.pf.adapters.referenceid.CredsValidatorUtil;
import com.pingidentity.pf.adapters.referenceid.DNValidator;
import com.pingidentity.pf.adapters.referenceid.DropoffHandler;
import com.pingidentity.pf.adapters.referenceid.JsonDeserializer;
import com.pingidentity.pf.adapters.referenceid.JsonSerializer;
import com.pingidentity.pf.adapters.referenceid.LogCleaner;
import com.pingidentity.pf.adapters.referenceid.LoggerMessage;
import com.pingidentity.pf.adapters.referenceid.PickupHandler;
import com.pingidentity.pf.adapters.referenceid.PropertiesSerializer;
import com.pingidentity.pf.adapters.referenceid.SimpleDeserializer;
import com.pingidentity.pf.adapters.referenceid.SocketFactoryHolder;
import com.pingidentity.pf.adapters.referenceid.cert.util.CertHelper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.Util;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.BearerAccessTokenFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.HttpURLValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.service.ArtifactPersistenceServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.servlet.adapter.Handler;
import org.sourceid.websso.servlet.adapter.HandlerRegistry;
import shaded.refid.com.google.gson.Gson;
import shaded.refid.com.google.gson.JsonSyntaxException;
import shaded.refid.com.google.gson.reflect.TypeToken;
import shaded.refid.com.pingidentity.integrations.logger.IntegrationsLogger;
import shaded.refid.com.pingidentity.integrations.logger.LogEvent;

public abstract class BackchannelReferenceAuthnAdapter
implements ConfigurableAuthnAdapter {
    protected static final String ADAPTER_VERSION = "2.2.1";
    private static final IntegrationsLogger logger;
    protected static String LOG_UTIL;
    static final String TOKEN_SUBJECT = "subject";
    protected static Set<String> DEFAULT_CONTRACT;
    protected int transportMode = 0;
    protected boolean replayPrevention = false;
    protected String transportModeConstant;
    private static Boolean isSetLabelConfigMethodPresent;
    private static Boolean isSetHiddenMethodPresent;
    static final String HTTPS = "https://";
    private static boolean inited;
    static final RequiredFieldValidator REQUIRED_FIELD_VALIDATOR;
    static final HttpURLValidator HTTP_URL_VALIDATOR;
    protected ArtifactPersistenceService persistenceService = StateMgmtFactory.getArtifactPersistenceService();
    private static volatile SocketFactoryHolder socketFactoryHolder;
    static final String EXT = "/ext";
    static final String DROPOFF_SUBPATH = "/ref/dropoff";
    static final String PICKUP_SUBPATH = "/ref/pickup";
    static final String DROPOFF = "/ext/ref/dropoff";
    static final String PICKUP = "/ext/ref/pickup";
    static final String BASE_DESCRIPTION = "The Reference ID Adapter allows user attributes to be passed in and out of the PingFederate server via direct HTTP(S) calls. Attributes are retrieved via a Reference ID.";
    static DropoffHandler dropoffHandler;
    static PickupHandler pickupHandler;
    public static final String TIMEOUT_FIELD_NAME = "Reference Duration";
    int timeout = 3;
    public static final String REF_LENGTH_FIELD_NAME = "Reference Length";
    int handleLength = 30;
    public static final String REF_PARAMETER_NAME = "REF";
    public static final String SOURCE_PARAMETER_NAME = "source";
    public static final String LOGOUT_ENDPOINT_FIELD_NAME = "Logout Service Endpoint";
    String logoutSvcEndpoint;
    public static final String LOGOUT_MODE_FIELD_NAME = "Logout Service Mode";
    public static final String LOGOUT_MODE_HIDDEN_FIELD_NAME = "Logout Mode";
    public static final String LOGOUT_MODE_FIELD_NAME_LABEL = "Logout Mode";
    public static final String INCLUDE_NULL_ATTRIBUTES_FIELD_NAME = "Include Null Attributes";
    public boolean includeNullAttributes = false;
    LogoutMode logoutMode;
    public static final String USER_NAME_FIELD_NAME = "User Name";
    String uname;
    public static final String PASS_PHRASE_FIELD_NAME = "Pass Phrase";
    String passphrase;
    public static final String REQUIRE_TLS_FIELD_NAME = "Require SSL/TLS";
    boolean requireTLS = true;
    public static final String SKIP_HOSTNAME_VALIDATION_FIELD_NAME = "Skip Host Name Validation ";
    boolean skipHostNameValidation = false;
    private static final String RELAX_PASSWORD_REQUIREMENTS_FIELD_NAME = "Relax Password Requirements";
    private static final String RELAX_PASSPHRASE_LABEL = "Relax Pass Phrase Requirements";
    boolean relaxPasswordValidation = false;
    public static final String RESUME_PATH_PARAM_NAME = "resumePath";
    public static final String CURRENT_BASE_URL_PARAM_NAME = "currentBaseUrl";
    public static final String PARTNER_ID_PARAM_NAME = "partnerEntityID";
    public static final String AUTHN_CTX_PARAM_NAME = "authnCtx";
    public static final String INSTANCE_ID = "com.pingidentity.plugin.instanceid";
    public static final String INSTANCE_PARAM_NAME = "instanceId";
    public static final String AUTHN_INST_PARAM_NAME = "authnInst";
    public static final String AUTHN_INST_DATE_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    public static final String SERIALIZER_FIELD_NAME = "Outgoing Attribute Format";
    public static final String TRANSPORT_MODE_FIELD_NAME = "Transport Mode";
    AttributeSerializer serializer = new PropertiesSerializer();
    public static final String DESERIALIZER_FIELD_NAME = "Incoming Attribute Format";
    AttributeDeserializer deserializer = new SimpleDeserializer();
    public static final String SUBJECT_DN_FIELD_NAME = "Allowed Subject DN";
    List<X500Principal> acceptableSubjectDN;
    public static final String ISSUER_DN_FIELD_NAME = "Allowed Issuer DN";
    List<X500Principal> acceptableIssuerDN;
    public static final String ACCESS_TOKEN_MANAGER_FIELD_NAME = "Access Token Manager";
    public static final String ALLOWED_BEARER_ACCESS_TOKEN_CLIENT_IDS = "Allowed Bearer Access Token Client IDs";
    public static final String REQUIRED_BEARER_ACCESS_TOKEN_SCOPES = "Required Bearer Access Token Scopes";
    String bearerTokenValidClientIds;
    String bearerTokenRequiredScopes;
    String tokenManagerId;
    CredsValidatorUtil credsValidatorUtil;
    static final int MIN_PASS_LENGTH = 30;
    public static final String CERT_AUTH = "Client Certificate";
    String instanceId = null;
    public static final String FLAG_SSO_CONTEXT_BOOLEAN = "isSsoContextVariable.flag";
    public static final String ERROR_CANNOT_RETRIEVE_SSO_CONTEXT_REFS_ON_RESUME = "Invalid Reference ID";
    private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER;
    private static final HostnameVerifier LAX_HOSTNAME_VERIFIER;

    void addCommonGuiStuff(AdapterConfigurationGuiDescriptor guiDesc, Configuration configuration) {
        String unameDesc = "ID the application uses to authenticate to the PingFederate server.";
        TextFieldDescriptor unameFieldDesc = new TextFieldDescriptor(USER_NAME_FIELD_NAME, unameDesc);
        unameFieldDesc.setSize(18);
        guiDesc.addField((FieldDescriptor)unameFieldDesc);
        String pwdDesc = "Pass phrase the application uses to authenticate to the PingFederate server.";
        TextFieldDescriptor pwdFieldDesc = new TextFieldDescriptor(PASS_PHRASE_FIELD_NAME, pwdDesc, true);
        pwdFieldDesc.setSize(50);
        guiDesc.addField((FieldDescriptor)pwdFieldDesc);
        String subjectDnDesc = "Subject DN from the client certificate. If entered, PingFederate restricts client-certificate authentication (when enabled) by matching against this DN.\nNote: Supports the asterisk (*) wildcard character and multiple DNs, separated by the pipe '|'.";
        TextFieldDescriptor subjectDnFieldDesc = new TextFieldDescriptor(SUBJECT_DN_FIELD_NAME, subjectDnDesc);
        subjectDnFieldDesc.addValidator((FieldValidator)new DNValidator());
        guiDesc.addField((FieldDescriptor)subjectDnFieldDesc);
        String issuerDnDesc = "Issuer DN from the client certificate. If entered, PingFederate restricts client-certificate authentication (when enabled) by matching against this DN.\nNote: Supports the asterisk (*) wildcard character and multiple DNs, separated by the pipe '|'.";
        TextFieldDescriptor issuerDnField = new TextFieldDescriptor(ISSUER_DN_FIELD_NAME, issuerDnDesc);
        issuerDnField.addValidator((FieldValidator)new DNValidator());
        guiDesc.addField((FieldDescriptor)issuerDnField);
        String bearerAccessTokenManagerDesc = "To enable OAuth Access Token authentication for applications, select an Access Token Management instance that will be  used for issuing and validating access tokens.";
        BearerAccessTokenFieldDescriptor bearerAccessTokenFieldDesc = new BearerAccessTokenFieldDescriptor(ACCESS_TOKEN_MANAGER_FIELD_NAME, bearerAccessTokenManagerDesc);
        guiDesc.addField((FieldDescriptor)bearerAccessTokenFieldDesc);
        String bearerAccessTokenValidClientsDesc = "A list of authorized client IDs allowed in the Bearer Access Token, separated by the pipe ' | '. If left empty, all client IDs will be accepted.";
        TextFieldDescriptor bearerAccessTokenValidClientsField = new TextFieldDescriptor(ALLOWED_BEARER_ACCESS_TOKEN_CLIENT_IDS, bearerAccessTokenValidClientsDesc);
        guiDesc.addField((FieldDescriptor)bearerAccessTokenValidClientsField);
        String bearerAccessTokenValidScopesDesc = "A list of required scopes that must be included in the Bearer Access Token. Scopes defined as common or exclusive scopes in scope management are valid. Separate multiple scopes using the pipe ' | '. If left empty, all scopes will be accepted.";
        TextFieldDescriptor bearerAccessTokenValidScopesField = new TextFieldDescriptor(REQUIRED_BEARER_ACCESS_TOKEN_SCOPES, bearerAccessTokenValidScopesDesc);
        guiDesc.addField((FieldDescriptor)bearerAccessTokenValidScopesField);
        String logoutDesc = "Application endpoint URL used for single logout, configure with Logout Service Mode.";
        TextFieldDescriptor logoutUrlFieldDesc = new TextFieldDescriptor(LOGOUT_ENDPOINT_FIELD_NAME, logoutDesc);
        logoutUrlFieldDesc.setSize(75);
        logoutUrlFieldDesc.addValidator((FieldValidator)HTTP_URL_VALIDATOR, true);
        logoutUrlFieldDesc.setDefaultValue(this.logoutSvcEndpoint);
        guiDesc.addField((FieldDescriptor)logoutUrlFieldDesc);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> opts = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>(3);
        opts.add(new AbstractSelectionFieldDescriptor.OptionValue("Front Channel", LogoutMode.FRONT.toString()));
        opts.add(new AbstractSelectionFieldDescriptor.OptionValue("Back Channel", LogoutMode.BACK.toString()));
        opts.add(new AbstractSelectionFieldDescriptor.OptionValue("None", LogoutMode.NONE.toString()));
        String modeDesc = "Configured with Logout Service Endpoint to define how the application logout is handled. Front channel redirects the user to the application endpoint and expects the application to redirect back to the provided PingFederate resume path.  Back channel sends a direct HTTP request from the server to the application.";
        String modeDescDeprecated = "DEPRECATED.";
        if (!isSetHiddenMethodPresent.booleanValue()) {
            modeDescDeprecated = isSetLabelConfigMethodPresent != false ? "DEPRECATED: use the other 'Logout Mode' configuration." : "DEPRECATED: use 'Logout Service Mode' configuration.";
        }
        RadioGroupFieldDescriptor logoutModeFieldDesc = new RadioGroupFieldDescriptor(LOGOUT_MODE_FIELD_NAME, modeDesc, opts);
        logoutModeFieldDesc.setDefaultValue(LogoutMode.NONE.toString());
        if (configuration != null && StringUtils.isBlank((CharSequence)configuration.getFieldValue(LOGOUT_ENDPOINT_FIELD_NAME))) {
            logoutModeFieldDesc.setDefaultValue(LogoutMode.NONE.toString());
            logoutModeFieldDesc.setDefaultForLegacyConfig(LogoutMode.NONE.toString());
        }
        if (configuration != null && StringUtils.isNotBlank((CharSequence)configuration.getFieldValue("Logout Mode"))) {
            logoutModeFieldDesc.setDefaultValue(configuration.getFieldValue("Logout Mode"));
            logoutModeFieldDesc.setDefaultForLegacyConfig(configuration.getFieldValue("Logout Mode"));
        }
        if (isSetLabelConfigMethodPresent.booleanValue()) {
            logoutModeFieldDesc.setLabel("Logout Mode");
        }
        RadioGroupFieldDescriptor logoutModeHiddenFieldDesc = new RadioGroupFieldDescriptor("Logout Mode", modeDescDeprecated, opts);
        if (isSetHiddenMethodPresent.booleanValue()) {
            logoutModeHiddenFieldDesc.setHidden(true);
        }
        guiDesc.addField((FieldDescriptor)logoutModeFieldDesc);
        guiDesc.addField((FieldDescriptor)logoutModeHiddenFieldDesc);
        String includeNullAttrsDesc = "Ensure the pick-up API endpoint response includes attributes with null values if they existed in the dropped-off payload, and for the Reference ID IdP Adapter, include null claims in the signed request object if applicable.";
        CheckBoxFieldDescriptor includeNullAttributesFieldAttr = new CheckBoxFieldDescriptor(INCLUDE_NULL_ATTRIBUTES_FIELD_NAME, includeNullAttrsDesc);
        guiDesc.addAdvancedField((FieldDescriptor)includeNullAttributesFieldAttr);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> transportModeOptions = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>(3);
        transportModeOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Query Parameter", String.valueOf(0)));
        transportModeOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Form Post", String.valueOf(2)));
        String transportModeDesc = "How the data (such as a Reference ID) is transported to/from the application, either via a Query Parameter or as a Form POST (default). This is applicable to the front channel only.";
        SelectFieldDescriptor transportModeFieldDesc = new SelectFieldDescriptor(TRANSPORT_MODE_FIELD_NAME, transportModeDesc, transportModeOptions);
        transportModeFieldDesc.setDefaultValue(String.valueOf(2));
        guiDesc.addAdvancedField((FieldDescriptor)transportModeFieldDesc);
        String toDesc = "The length of time (in seconds) that the PingFederate server retains the referenced attributes in memory.";
        TextFieldDescriptor timeoutFieldDesc = new TextFieldDescriptor(TIMEOUT_FIELD_NAME, toDesc);
        timeoutFieldDesc.setSize(3);
        timeoutFieldDesc.addValidator((FieldValidator)new IntegerValidator(1, 95));
        timeoutFieldDesc.addValidator((FieldValidator)REQUIRED_FIELD_VALIDATOR);
        timeoutFieldDesc.setDefaultValue(String.valueOf(this.timeout));
        guiDesc.addAdvancedField((FieldDescriptor)timeoutFieldDesc);
        String refLenDesc = "The number of bytes used for the pseudo-randomly generated reference value.";
        TextFieldDescriptor refLengthFieldDesc = new TextFieldDescriptor(REF_LENGTH_FIELD_NAME, refLenDesc);
        refLengthFieldDesc.setSize(3);
        refLengthFieldDesc.addValidator((FieldValidator)new IntegerValidator(21, 60));
        refLengthFieldDesc.addValidator((FieldValidator)REQUIRED_FIELD_VALIDATOR);
        refLengthFieldDesc.setDefaultValue(String.valueOf(this.handleLength));
        guiDesc.addAdvancedField((FieldDescriptor)refLengthFieldDesc);
        String tlsDesc = "Determines whether the PingFederate server requires a secure connection for calls made to the attribute-retrieval endpoint.";
        CheckBoxFieldDescriptor requireTLSFieldDesc = new CheckBoxFieldDescriptor(REQUIRE_TLS_FIELD_NAME, tlsDesc);
        requireTLSFieldDesc.setDefaultValue(this.requireTLS);
        guiDesc.addAdvancedField((FieldDescriptor)requireTLSFieldDesc);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> serializerOptions = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>(3);
        serializerOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Properties", SerializerType.PROPERTIES.toString()));
        serializerOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("JSON", SerializerType.JSON.toString()));
        String sezDesc = "The format in which PingFederate encodes attribute values on the HTTP response to the application. The application must be equipped to parse this format.";
        SelectFieldDescriptor serializerFieldDesc = new SelectFieldDescriptor(SERIALIZER_FIELD_NAME, sezDesc, serializerOptions);
        serializerFieldDesc.setDefaultValue(SerializerType.JSON.toString());
        guiDesc.addAdvancedField((FieldDescriptor)serializerFieldDesc);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> deserializerOptions = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>(3);
        deserializerOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("Query Parameter", DeserializerType.SIMPLE.toString()));
        deserializerOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("JSON", DeserializerType.JSON.toString()));
        String deszDesc = "The format in which the application encodes attribute values on the HTTP request to PingFederate. ";
        SelectFieldDescriptor deserializerFieldDesc = new SelectFieldDescriptor(DESERIALIZER_FIELD_NAME, deszDesc, deserializerOptions);
        deserializerFieldDesc.setDefaultValue(DeserializerType.JSON.toString());
        guiDesc.addAdvancedField((FieldDescriptor)deserializerFieldDesc);
        String skipHostDesc = "For back-channel logout -- if selected, skips HTTPS host name validation of the server certificate presented by the application.";
        CheckBoxFieldDescriptor skipHostNameValidationFieldDesc = new CheckBoxFieldDescriptor(SKIP_HOSTNAME_VALIDATION_FIELD_NAME, skipHostDesc);
        skipHostNameValidationFieldDesc.setDefaultValue(this.skipHostNameValidation);
        guiDesc.addAdvancedField((FieldDescriptor)skipHostNameValidationFieldDesc);
        String relaxPasswordValidationDesc = "When selected, the adapter does not enforce requirements for the application credentials entered in the 'Pass Phrase' field.";
        CheckBoxFieldDescriptor relaxPasswordValidationFieldDesc = new CheckBoxFieldDescriptor(RELAX_PASSWORD_REQUIREMENTS_FIELD_NAME, relaxPasswordValidationDesc);
        relaxPasswordValidationFieldDesc.setDefaultValue(this.relaxPasswordValidation);
        relaxPasswordValidationFieldDesc.setDefaultForLegacyConfig(Boolean.TRUE.toString());
        if (isSetLabelConfigMethodPresent.booleanValue()) {
            relaxPasswordValidationFieldDesc.setLabel(RELAX_PASSPHRASE_LABEL);
        }
        guiDesc.addAdvancedField((FieldDescriptor)relaxPasswordValidationFieldDesc);
        guiDesc.addValidator(new ConfigurationValidator(){

            public void validate(Configuration configuration) throws ValidationException {
                String configuredScopes;
                StringBuilder errorMessage;
                String unameValue = configuration.getFieldValue(BackchannelReferenceAuthnAdapter.USER_NAME_FIELD_NAME);
                String passphraseValue = configuration.getFieldValue(BackchannelReferenceAuthnAdapter.PASS_PHRASE_FIELD_NAME);
                String subjectDNValue = configuration.getFieldValue(BackchannelReferenceAuthnAdapter.SUBJECT_DN_FIELD_NAME);
                String issuerDNValue = configuration.getFieldValue(BackchannelReferenceAuthnAdapter.ISSUER_DN_FIELD_NAME);
                BackchannelReferenceAuthnAdapter.this.relaxPasswordValidation = Boolean.parseBoolean(configuration.getFieldValue(BackchannelReferenceAuthnAdapter.RELAX_PASSWORD_REQUIREMENTS_FIELD_NAME));
                String tokenManagerIdValue = configuration.getFieldValue(BackchannelReferenceAuthnAdapter.ACCESS_TOKEN_MANAGER_FIELD_NAME);
                if (StringUtils.isBlank((CharSequence)unameValue) && StringUtils.isBlank((CharSequence)passphraseValue) && StringUtils.isBlank((CharSequence)subjectDNValue) && StringUtils.isBlank((CharSequence)issuerDNValue) && StringUtils.isBlank((CharSequence)tokenManagerIdValue)) {
                    throw new ValidationException("Configure values for the 'User Name' and 'Pass Phrase' fields, or the 'Allowed Subject DN' and/or 'Allowed Issuer DN' fields, or the 'Access Token Manager' field.");
                }
                if (!StringUtils.isBlank((CharSequence)unameValue) && StringUtils.isBlank((CharSequence)passphraseValue)) {
                    throw new ValidationException("Pass Phrase must be specified along with User Name for authentication to work.");
                }
                if (StringUtils.isBlank((CharSequence)unameValue) && !StringUtils.isBlank((CharSequence)passphraseValue)) {
                    throw new ValidationException("User Name must be specified along with Pass Phrase for authentication to work.");
                }
                if (!BackchannelReferenceAuthnAdapter.this.relaxPasswordValidation && StringUtils.isNotBlank((CharSequence)unameValue) && StringUtils.isNotBlank((CharSequence)passphraseValue) && !ValidationUtil.isPasswordValid((String)passphraseValue, (StringBuilder)(errorMessage = new StringBuilder()))) {
                    String erroMessageUpdated = errorMessage.toString().replace("Password", "Pass phrase");
                    throw new ValidationException(erroMessageUpdated);
                }
                String configuredClientIds = configuration.getFieldValue(BackchannelReferenceAuthnAdapter.ALLOWED_BEARER_ACCESS_TOKEN_CLIENT_IDS);
                if (StringUtils.isNotBlank((CharSequence)configuredClientIds)) {
                    List clientIds = Arrays.stream(configuredClientIds.split("\\|")).map(String::trim).collect(Collectors.toList());
                    for (String clientId : clientIds) {
                        if (MgmtFactory.getClientManager().getCachedClient(clientId) != null) continue;
                        throw new ValidationException("Client ID '" + clientId + "' is not a valid client ID.");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(configuredScopes = configuration.getFieldValue(BackchannelReferenceAuthnAdapter.REQUIRED_BEARER_ACCESS_TOKEN_SCOPES)))) {
                    List scopes = Arrays.stream(configuredScopes.split("\\|")).map(String::trim).collect(Collectors.toList());
                    Map groupDescriptionsMap = MgmtFactory.getScopeManager().getScopeGroupDescriptions();
                    Map scopeDescriptionsMap = MgmtFactory.getScopeManager().getScopeDescriptions();
                    Map exclusiveScopeGroupDescriptionsMap = MgmtFactory.getScopeManager().getExclusiveScopeGroupDescriptions();
                    Map exclusiveScopeDescriptionsMap = MgmtFactory.getScopeManager().getExclusiveScopeDescriptions();
                    Set dynamicExclusiveScopes = MgmtFactory.getScopeManager().getDynamicExclusiveScopes();
                    Set dynamicCommonScopes = MgmtFactory.getScopeManager().getDynamicCommonScopes();
                    for (String scope : scopes) {
                        boolean exactDynamicMatchFound;
                        boolean bl = exactDynamicMatchFound = BackchannelReferenceAuthnAdapter.this.checkForExactDynamicMatch(scope, dynamicExclusiveScopes) || BackchannelReferenceAuthnAdapter.this.checkForExactDynamicMatch(scope, dynamicCommonScopes);
                        if (exactDynamicMatchFound) {
                            throw new ValidationException("Scope '" + scope + "' is not a valid scope.");
                        }
                        boolean validScope = groupDescriptionsMap.containsKey(scope) || scopeDescriptionsMap.containsKey(scope) || exclusiveScopeGroupDescriptionsMap.containsKey(scope) || exclusiveScopeDescriptionsMap.containsKey(scope);
                        if (validScope || (validScope = BackchannelReferenceAuthnAdapter.this.validateDynamicScopeSet(scope, dynamicExclusiveScopes) || BackchannelReferenceAuthnAdapter.this.validateDynamicScopeSet(scope, dynamicCommonScopes))) continue;
                        throw new ValidationException("Scope '" + scope + "' is not a valid scope.");
                    }
                }
            }
        });
        String actionDesc = "Shows the clear text value of the pass phrase for copying to applications.";
        guiDesc.addAction(new ActionDescriptor("Show Pass Phrase", actionDesc, new ActionDescriptor.Action(){

            public String actionInvoked(Configuration configuration) {
                return configuration.getFieldValue(BackchannelReferenceAuthnAdapter.PASS_PHRASE_FIELD_NAME);
            }
        }));
    }

    public boolean checkForExactDynamicMatch(String inputScope, Set<String> dynamicScopeSet) {
        if (dynamicScopeSet.isEmpty()) {
            return false;
        }
        for (String dynamicScope : dynamicScopeSet) {
            if (!dynamicScope.equals(inputScope)) continue;
            return true;
        }
        return false;
    }

    public boolean validateDynamicScopeSet(String inputScope, Set<String> dynamicScopeSet) {
        if (dynamicScopeSet.isEmpty()) {
            return false;
        }
        for (String dynamicScope : dynamicScopeSet) {
            if (!this.validateDynamicScope(inputScope, dynamicScope)) continue;
            return true;
        }
        return false;
    }

    public boolean validateDynamicScope(String inputScope, String dynamicScopePattern) {
        int starIndex = dynamicScopePattern.indexOf(42);
        if (starIndex == -1) {
            return inputScope.equals(dynamicScopePattern);
        }
        String prefix = dynamicScopePattern.substring(0, starIndex);
        String suffix = dynamicScopePattern.substring(starIndex + 1);
        if (prefix.isEmpty()) {
            return !suffix.equals(inputScope) && inputScope.endsWith(suffix);
        }
        if (suffix.isEmpty()) {
            return !prefix.equals(inputScope) && inputScope.startsWith(prefix);
        }
        return inputScope.startsWith(prefix) && inputScope.endsWith(suffix) && inputScope.length() > prefix.length() + suffix.length();
    }

    public String getBearerTokenValidClientIds() {
        return this.bearerTokenValidClientIds;
    }

    public String getTokenManagerId() {
        return this.tokenManagerId;
    }

    abstract String getMoreLogoutDesc();

    boolean isResume(HttpServletRequest req, String resumePath) {
        return resumePath != null && req.getRequestURI().endsWith(resumePath) && (req.getParameter(REF_PARAMETER_NAME) != null || req.getParameter(SOURCE_PARAMETER_NAME) != null);
    }

    Map<String, Object> retrieveAttributes(HttpServletRequest req) throws ArtifactPersistenceServiceException {
        String ref = req.getParameter(REF_PARAMETER_NAME);
        Map<String, Object> attributes = this.retrieveAttributes(ref);
        return attributes;
    }

    Map<String, Object> retrieveAttributes(String refId) throws ArtifactPersistenceServiceException {
        Map<String, Object> attributes = new HashMap<String, Object>();
        if (refId != null) {
            byte[] bytes = HexBin.stringToBytes((String)refId);
            if (bytes == null || bytes.length != this.handleLength) {
                logger.log((LogEvent)LoggerMessage.REF, LogCleaner.clean(refId));
                logger.log((LogEvent)LoggerMessage.MALFORMED_REF, this.handleLength);
            } else {
                String attributesLog;
                ArtifactPersistenceService.Message message = this.persistenceService.retrieveAndRemoveArtifact(bytes);
                if (message != null) {
                    Object msg = message.getMsg();
                    attributes = (Map)msg;
                } else {
                    logger.log((LogEvent)LoggerMessage.INVALID_REF, refId);
                }
                if (!StringUtils.isBlank((CharSequence)this.instanceId) && attributes != null && !attributes.isEmpty()) {
                    String stringInstanceId;
                    Object objectInstanceId = attributes.get(INSTANCE_ID);
                    String string = stringInstanceId = objectInstanceId instanceof String ? (String)objectInstanceId : null;
                    if (!this.instanceId.equalsIgnoreCase(stringInstanceId)) {
                        throw new ArtifactPersistenceServiceException("Instance Id mismatch");
                    }
                    attributes.remove(INSTANCE_ID);
                }
                String string = attributesLog = attributes == null ? "" : attributes.toString();
                if (attributes == null || attributes.isEmpty()) {
                    logger.log(LoggerMessage.EMPTY_PAYLOAD);
                }
                logger.log((LogEvent)LoggerMessage.REF_ID_EXCHANGE, LogCleaner.clean(refId), LogCleaner.clean(attributesLog));
            }
        }
        return attributes;
    }

    protected boolean sendBackChannelLogout(String logoutUrl) throws IOException {
        int responseCode;
        boolean ok;
        logger.log((LogEvent)LoggerMessage.BACKCHANNEL_MSG, logoutUrl);
        URL url = new URL(logoutUrl);
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
        if (httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            httpsURLConnection.setSSLSocketFactory(socketFactoryHolder.getSocketFactory());
            httpsURLConnection.setHostnameVerifier(this.skipHostNameValidation ? LAX_HOSTNAME_VERIFIER : DEFAULT_HOSTNAME_VERIFIER);
        }
        boolean bl = ok = 200 == (responseCode = httpURLConnection.getResponseCode());
        if (!ok) {
            logger.log((LogEvent)LoggerMessage.REQUEST_RESPONSE, logoutUrl, responseCode);
        }
        return ok;
    }

    String storeAttrs(HttpServletRequest req, Map<String, Object> attrs, String partnerId) throws ArtifactPersistenceServiceException {
        String ref = null;
        if (!StringUtils.isBlank((CharSequence)partnerId)) {
            attrs.put(PARTNER_ID_PARAM_NAME, partnerId);
        }
        if (!StringUtils.isBlank((CharSequence)this.instanceId)) {
            attrs.put(INSTANCE_ID, this.instanceId);
        }
        ArtifactPersistenceService.Message message = new ArtifactPersistenceService.Message(attrs);
        message.setMessageHandleLength(this.handleLength);
        ArtifactPersistenceService.Handle handle = this.persistenceService.saveArtifact(message, this.timeout);
        byte[] messageHandleBytes = handle.getMessageHandle();
        ref = HexBin.bytesToString((byte[])messageHandleBytes);
        logger.log((LogEvent)LoggerMessage.ATTRIBUTES_EXCHANGE, attrs.toString(), ref);
        return ref;
    }

    public void configure(Configuration configuration) {
        this.uname = configuration.getFieldValue(USER_NAME_FIELD_NAME);
        this.passphrase = configuration.getFieldValue(PASS_PHRASE_FIELD_NAME);
        this.acceptableSubjectDN = CertHelper.createDNList(configuration.getFieldValue(SUBJECT_DN_FIELD_NAME));
        this.acceptableIssuerDN = CertHelper.createDNList(configuration.getFieldValue(ISSUER_DN_FIELD_NAME));
        this.tokenManagerId = configuration.getFieldValue(ACCESS_TOKEN_MANAGER_FIELD_NAME);
        this.bearerTokenValidClientIds = configuration.getFieldValue(ALLOWED_BEARER_ACCESS_TOKEN_CLIENT_IDS);
        this.bearerTokenRequiredScopes = configuration.getFieldValue(REQUIRED_BEARER_ACCESS_TOKEN_SCOPES);
        this.credsValidatorUtil = new CredsValidatorUtil.Builder().setAcceptableSubjectDN(this.acceptableSubjectDN).setAcceptableIssuerDN(this.acceptableIssuerDN).setHttpBasicAuthUsername(this.uname).setHttpBasicAuthPassphrase(this.passphrase).setBearerTokenValidClientIds(this.bearerTokenValidClientIds).setBearerTokenRequiredScopes(this.bearerTokenRequiredScopes).setTokenManagerId(this.tokenManagerId).build();
        String logoutModeStr = configuration.getFieldValue(LOGOUT_MODE_FIELD_NAME);
        if (StringUtils.isBlank((CharSequence)logoutModeStr)) {
            String deprecatedLogoutFieldValue = configuration.getFieldValue("Logout Mode");
            this.logoutMode = LogoutMode.FRONT.toString().equalsIgnoreCase(deprecatedLogoutFieldValue) || LogoutMode.BACK.toString().equalsIgnoreCase(deprecatedLogoutFieldValue) ? LogoutMode.valueOf(deprecatedLogoutFieldValue) : LogoutMode.NONE;
        } else {
            this.logoutMode = LogoutMode.valueOf(logoutModeStr);
        }
        this.logoutSvcEndpoint = configuration.getFieldValue(LOGOUT_ENDPOINT_FIELD_NAME);
        this.includeNullAttributes = configuration.getBooleanFieldValue(INCLUDE_NULL_ATTRIBUTES_FIELD_NAME);
        FieldList advancedFields = configuration.getAdvancedFields();
        this.timeout = advancedFields.getIntFieldValue(TIMEOUT_FIELD_NAME);
        this.transportMode = advancedFields.getIntFieldValue(TRANSPORT_MODE_FIELD_NAME);
        this.handleLength = advancedFields.getIntFieldValue(REF_LENGTH_FIELD_NAME);
        this.requireTLS = advancedFields.getBooleanFieldValue(REQUIRE_TLS_FIELD_NAME);
        String skipHostNameStr = advancedFields.getFieldValue(SKIP_HOSTNAME_VALIDATION_FIELD_NAME);
        this.skipHostNameValidation = StringUtils.isBlank((CharSequence)skipHostNameStr) ? true : advancedFields.getBooleanFieldValue(SKIP_HOSTNAME_VALIDATION_FIELD_NAME);
        if (null == socketFactoryHolder) {
            socketFactoryHolder = new SocketFactoryHolder();
            socketFactoryHolder.initialize();
        }
        try {
            if (advancedFields.getFieldValue(SERIALIZER_FIELD_NAME).equalsIgnoreCase(SerializerType.JSON.toString())) {
                this.serializer = new JsonSerializer(this.includeNullAttributes);
            }
        }
        catch (Exception e) {
            logger.log((LogEvent)LoggerMessage.ATTRIBUTE_SERIALIZER_ERROR, e);
        }
        try {
            if (advancedFields.getFieldValue(DESERIALIZER_FIELD_NAME).equalsIgnoreCase(DeserializerType.JSON.toString())) {
                this.deserializer = new JsonDeserializer();
            }
        }
        catch (Exception e) {
            logger.log((LogEvent)LoggerMessage.ATTRIBUTE_SERIALIZER_ERROR, e);
        }
        this.instanceId = advancedFields.getFieldValue(INSTANCE_ID);
    }

    public boolean isRequireTLS() {
        return this.requireTLS;
    }

    public String getRefParamName() {
        return REF_PARAMETER_NAME;
    }

    public String getSSOContextAttributesName() {
        return FLAG_SSO_CONTEXT_BOOLEAN;
    }

    public int getHandleLength() {
        return this.handleLength;
    }

    public String getResumePathParamName() {
        return RESUME_PATH_PARAM_NAME;
    }

    public String getCurrentBaseUrlParamName() {
        return CURRENT_BASE_URL_PARAM_NAME;
    }

    public AttributeSerializer getSerializer() {
        return this.serializer;
    }

    public AttributeDeserializer getDeserializer() {
        return this.deserializer;
    }

    static synchronized void initHandlers() {
        if (!inited) {
            inited = true;
            dropoffHandler = new DropoffHandler();
            pickupHandler = new PickupHandler();
            HandlerRegistry.registerHandler((String)DROPOFF_SUBPATH, (Handler)dropoffHandler);
            HandlerRegistry.registerHandler((String)PICKUP_SUBPATH, (Handler)pickupHandler);
        }
    }

    static synchronized void reloadHandlers() {
        if (inited) {
            dropoffHandler.reload();
            pickupHandler.reload();
        }
    }

    public void validateCreds(BackchannelCreds creds) throws LoginException {
        this.credsValidatorUtil.validateCredentials(creds);
    }

    Map<String, Object> attributeMapToObjectMap(Map<String, AttributeValue> attrValueMap) {
        HashMap<String, Object> returnedMap = new HashMap<String, Object>();
        if (attrValueMap == null) {
            return returnedMap;
        }
        for (Map.Entry<String, AttributeValue> entry : attrValueMap.entrySet()) {
            String key = entry.getKey();
            AttributeValue value = entry.getValue();
            if (value == null) continue;
            if (value.isMultiValue()) {
                returnedMap.put(key, value.getValuesAsCollection());
                continue;
            }
            Type mapTypeToken = new TypeToken<Map<String, Object>>(){}.getType();
            Type listTypeToken = new TypeToken<List<String>>(){}.getType();
            Gson gson = new Gson();
            String attributeValueString = value.getValue();
            Object deserializedValue = null;
            try {
                deserializedValue = gson.fromJson(attributeValueString, listTypeToken);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            try {
                deserializedValue = gson.fromJson(attributeValueString, mapTypeToken);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            if (deserializedValue != null) {
                returnedMap.put(key, deserializedValue);
                continue;
            }
            returnedMap.put(key, attributeValueString);
        }
        return returnedMap;
    }

    public String getCurrentBaseUrl() {
        String currentBaseUrl = "";
        try {
            Class<?> baseUrlAccessorClass = Class.forName("com.pingidentity.access.BaseUrlAccessor");
            Method getCurrentBaseUrlMethod = baseUrlAccessorClass.getMethod("getCurrentBaseUrl", new Class[0]);
            currentBaseUrl = (String)getCurrentBaseUrlMethod.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentBaseUrl;
    }

    static {
        Method[] methods;
        logger = new IntegrationsLogger(BackchannelReferenceAuthnAdapter.class);
        LOG_UTIL = "com.pingidentity.sdk.logging.LoggingUtil";
        isSetLabelConfigMethodPresent = false;
        isSetHiddenMethodPresent = false;
        DEFAULT_CONTRACT = new HashSet<String>();
        DEFAULT_CONTRACT.add(TOKEN_SUBJECT);
        for (Method m : methods = FieldDescriptor.class.getMethods()) {
            if (m.getName().equals("setLabel")) {
                isSetLabelConfigMethodPresent = true;
            }
            if (!m.getName().equals("setHidden")) continue;
            isSetHiddenMethodPresent = true;
        }
        inited = false;
        REQUIRED_FIELD_VALIDATOR = new RequiredFieldValidator();
        HTTP_URL_VALIDATOR = new HttpURLValidator();
        BackchannelReferenceAuthnAdapter.initHandlers();
        DEFAULT_HOSTNAME_VERIFIER = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                try {
                    Principal peerPrincipal = sslSession.getPeerPrincipal();
                    String cn = Util.getCN((String)peerPrincipal.getName());
                    return cn.equals(hostname);
                }
                catch (SSLPeerUnverifiedException e) {
                    logger.log((LogEvent)LoggerMessage.HOSTNAME_ERROR, e);
                    return false;
                }
            }
        };
        LAX_HOSTNAME_VERIFIER = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return true;
            }
        };
    }

    static enum DeserializerType {
        SIMPLE,
        JSON;

    }

    static enum SerializerType {
        PROPERTIES,
        JSON;

    }

    static enum LogoutMode {
        FRONT,
        BACK,
        NONE;

    }
}

