/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.pf.adapters.referenceid.AbstractHandler;
import com.pingidentity.pf.adapters.referenceid.AttributeDeserializer;
import com.pingidentity.pf.adapters.referenceid.AttributeSerializer;
import com.pingidentity.pf.adapters.referenceid.BackchannelReferenceAuthnAdapter;
import com.pingidentity.pf.adapters.referenceid.LoggerMessage;
import com.pingidentity.pf.adapters.referenceid.RequestError;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.service.ArtifactPersistenceServiceException;
import org.sourceid.servlet.ServletExceptionSupport;
import shaded.refid.com.pingidentity.integrations.logger.IntegrationsLogger;

public class DropoffHandler
extends AbstractHandler {
    private static final IntegrationsLogger logger = new IntegrationsLogger(DropoffHandler.class);

    @Override
    void doHandle(HttpServletRequest req, HttpServletResponse resp, BackchannelReferenceAuthnAdapter adapter) throws ServletException, IOException {
        logger.log(LoggerMessage.DROP_OFF_HANDLER);
        Map<String, Object> attrs = null;
        AttributeDeserializer deserializer = adapter.getDeserializer();
        try {
            attrs = deserializer.deserialize(req, resp);
        }
        catch (IOException ie) {
            resp.setHeader("Content-Type", "application/json");
            resp.setStatus(400);
            resp.getWriter().write(new RequestError(400, ie.getMessage()).getJson());
            resp.flushBuffer();
            return;
        }
        try {
            String reference = adapter.storeAttrs(req, attrs, null);
            String refParamName = adapter.getRefParamName();
            AttributeSerializer serializer = adapter.getSerializer();
            HashMap<String, String> respAttrs = new HashMap<String, String>(2);
            respAttrs.put(refParamName, reference);
            serializer.serialize(respAttrs, req, resp);
        }
        catch (ArtifactPersistenceServiceException e) {
            ServletExceptionSupport.throwServletException((Exception)((Object)e));
        }
    }
}

