/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.pf.adapters.referenceid.AttributeDeserializer;
import com.pingidentity.pf.adapters.referenceid.LoggerMessage;
import com.pingidentity.pf.adapters.referenceid.RequestError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import shaded.refid.com.fasterxml.jackson.core.type.TypeReference;
import shaded.refid.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.refid.com.google.gson.JsonSyntaxException;
import shaded.refid.com.pingidentity.integrations.logger.IntegrationsLogger;
import shaded.refid.com.pingidentity.integrations.logger.LogEvent;
import shaded.refid.org.apache.commons.io.IOUtils;

public class JsonDeserializer
implements AttributeDeserializer {
    private static final IntegrationsLogger logger = new IntegrationsLogger(JsonDeserializer.class);

    @Override
    public Map<String, Object> deserialize(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> attributeMap = null;
        String encoding = req.getCharacterEncoding() == null ? "UTF-8" : req.getCharacterEncoding();
        InputStreamReader streamReader = new InputStreamReader((InputStream)req.getInputStream(), encoding);
        TypeReference<Map<String, Object>> mapType = new TypeReference<Map<String, Object>>(){};
        String rawPayload = IOUtils.toString(streamReader);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            attributeMap = objectMapper.readValue(rawPayload, mapType);
        }
        catch (JsonSyntaxException jse) {
            throw new IOException(RequestError.INVALID_JSON_PAYLOAD);
        }
        if (attributeMap == null) {
            logger.log(LoggerMessage.NO_DATA_DESERIALIZER);
            throw new IOException(RequestError.EMPTY_PAYLOAD);
        }
        logger.log(LoggerMessage.START_DESERIALIZER);
        for (Map.Entry<String, Object> e : attributeMap.entrySet()) {
            Object value = e.getValue();
            String key = e.getKey();
            logger.log((LogEvent)LoggerMessage.DESERIALIZER_KEY, key);
            logger.log((LogEvent)LoggerMessage.DESERIALIZER_VALUE, value);
        }
        logger.log(LoggerMessage.END_DESERIALIZER);
        return attributeMap;
    }
}

