/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.pf.adapters.referenceid.AttributeSerializer;
import com.pingidentity.pf.adapters.referenceid.LoggerMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import shaded.refid.com.google.gson.Gson;
import shaded.refid.com.google.gson.GsonBuilder;
import shaded.refid.com.google.gson.stream.JsonWriter;
import shaded.refid.com.pingidentity.integrations.logger.IntegrationsLogger;
import shaded.refid.com.pingidentity.integrations.logger.LogEvent;

public class JsonSerializer
implements AttributeSerializer {
    private static final IntegrationsLogger logger = new IntegrationsLogger(JsonSerializer.class);
    private boolean includeNullAttributes = false;

    public JsonSerializer() {
    }

    public JsonSerializer(boolean includeNullAttributes) {
        this.includeNullAttributes = includeNullAttributes;
    }

    @Override
    public void serialize(Map<String, ?> attributes, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HashMap jsonObj = new HashMap();
        if (attributes != null) {
            logger.log((LogEvent)LoggerMessage.SERIALIZE_ATTR, attributes.toString());
            for (Map.Entry<String, ?> e : attributes.entrySet()) {
                Object value = e.getValue();
                String key = e.getKey();
                logger.log((LogEvent)LoggerMessage.SERIALIZER_KEY, key);
                logger.log((LogEvent)LoggerMessage.SERIALIZER_VALUE, key);
                jsonObj.put(key, value);
            }
        }
        Gson gson = this.isIncludeNullAttributes() ? new GsonBuilder().serializeNulls().create() : new GsonBuilder().create();
        String json = gson.toJson(jsonObj);
        logger.log((LogEvent)LoggerMessage.SERIALIZED_STRING, json);
        resp.setHeader("Content-Type", "application/json");
        JsonWriter writer = gson.newJsonWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8"));
        writer.jsonValue(json);
        writer.flush();
        writer.close();
    }

    public boolean isIncludeNullAttributes() {
        return this.includeNullAttributes;
    }

    public void setIncludeNullAttributes(boolean includeNullAttributes) {
        this.includeNullAttributes = includeNullAttributes;
    }
}

