/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.ConfigStoreHelper;
import com.pingidentity.common.upgrade.FileMigrator;
import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.PingFederateDirectoryInfo;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStoreFileCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStorePropertyCustomAction;
import com.pingidentity.common.upgrade.exception.FileMigrationException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.pingcommons.util.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.config.impl.xml.ConfigDocument;
import org.sourceid.config.impl.xml.ConfigType;
import org.sourceid.config.impl.xml.ItemType;
import org.sourceid.config.impl.xml.ListType;
import org.sourceid.config.impl.xml.MapType;

public class ConfigStoreFileMigrator
extends FileMigrator {
    private static final Logger log = LogManager.getLogger(ConfigStoreFileMigrator.class);
    private LogHelper logHelper = LogHelper.getInstance();

    @Override
    public void merge(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) {
        this.migrate(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName, null);
    }

    @Override
    public void customMigrate(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName, FileCustomAction fileCustomAction) {
        if (fileCustomAction != null && !(fileCustomAction instanceof ConfigStoreFileCustomAction)) {
            throw new IllegalArgumentException("fileCustomAction must be of type " + ConfigStoreFileCustomAction.class.getSimpleName());
        }
        this.migrate(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName, (ConfigStoreFileCustomAction)fileCustomAction);
    }

    @Override
    public boolean mergeSourceFilesWithMissingDefaultFile() {
        return true;
    }

    @Override
    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileMigrationException {
        File destinationFile = new File(destinationFileParentDir, fileName);
        ConfigDocument destinationConfigDocument = ConfigStoreHelper.getConfigDocument(destinationFile);
        if (this.handlePropertiesMissingInSource(destinationConfigDocument, Collections.emptyMap(), destinationFile)) {
            ConfigStoreFileMigrator.save(destinationFile, (XmlObject)destinationConfigDocument);
        }
        return true;
    }

    private void migrate(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName, ConfigStoreFileCustomAction fileCustomAction) {
        File defaultSourceFile = new File(sourceDefaultFileParentDir, fileName);
        File sourceFile = new File(sourceFileParentDir, fileName);
        File destinationFile = new File(destinationFileParentDir, fileName);
        try {
            HashMap<String, Object> defaultSourceMap = new HashMap();
            if (defaultSourceFile.exists()) {
                ConfigDocument defaultSourceConfigDocument = ConfigStoreHelper.getConfigDocument(defaultSourceFile);
                defaultSourceMap = ConfigStoreHelper.getConfigStoreMapFromFile(defaultSourceConfigDocument);
            }
            ConfigDocument sourceConfigDocument = ConfigStoreHelper.getConfigDocument(sourceFile);
            Map<String, Object> sourceMap = ConfigStoreHelper.getConfigStoreMapFromFile(sourceConfigDocument);
            ConfigDocument destinationConfigDocument = ConfigStoreHelper.getConfigDocument(destinationFile);
            Map<String, Object> destinationMap = ConfigStoreHelper.getConfigStoreMapFromFile(destinationConfigDocument);
            if (defaultSourceFile.exists()) {
                this.removeAndLogDeletedDefaultPropsFromDestination(defaultSourceMap, sourceFile, sourceMap, destinationFile, destinationMap, destinationConfigDocument);
            }
            this.validateTargetProperties(destinationFile, fileCustomAction, sourceMap, destinationMap, destinationConfigDocument);
            for (Map.Entry<String, Object> sourceEntry : sourceMap.entrySet()) {
                String propertyName = sourceEntry.getKey();
                try {
                    Object defaultSourcePropertyValue = defaultSourceMap.get(propertyName);
                    Object sourcePropertyValue = sourceMap.get(propertyName);
                    Object destinationPropertyValue = destinationMap.get(propertyName);
                    boolean sourceAndDefaultAreDifferent = defaultSourcePropertyValue == null || !sourcePropertyValue.equals(defaultSourcePropertyValue);
                    boolean sourceDestinationAreDifferent = destinationPropertyValue == null || !sourcePropertyValue.equals(destinationPropertyValue);
                    boolean deprecatedProperty = destinationPropertyValue == null && defaultSourcePropertyValue != null;
                    boolean preserveOnUpgrade = this.checkPreserveOnUpgrade(destinationConfigDocument, propertyName);
                    if (!sourceDestinationAreDifferent) continue;
                    ConfigStorePropertyCustomAction customActionForProperty = null;
                    if (fileCustomAction != null) {
                        customActionForProperty = fileCustomAction.getCustomActionForProperty(propertyName);
                    }
                    boolean updateDestinationWithSourceValue = true;
                    if (customActionForProperty != null) {
                        updateDestinationWithSourceValue = customActionForProperty.isUseSourceValue(sourcePropertyValue, destinationPropertyValue, defaultSourcePropertyValue);
                        if (!updateDestinationWithSourceValue && !sourceAndDefaultAreDifferent) {
                            log.info("New Default in " + LogHelper.getInstance().getCleanPath(destinationFile.getPath()) + ". The default value for " + propertyName + " was changed from " + this.logHelper.getValueForLog(propertyName, defaultSourcePropertyValue) + " to " + this.logHelper.getValueForLog(propertyName, destinationPropertyValue) + ".");
                        }
                    } else if (deprecatedProperty) {
                        log.debug("Property not migrated: " + LogHelper.getInstance().getCleanPath(sourceFile.getPath()) + ". Property '" + propertyName + "' no longer needed.");
                        updateDestinationWithSourceValue = false;
                    } else if (!sourceAndDefaultAreDifferent && !preserveOnUpgrade) {
                        log.info("New Default in " + LogHelper.getInstance().getCleanPath(destinationFile.getPath()) + ". The default value for " + propertyName + " was changed from " + this.logHelper.getValueForLog(propertyName, defaultSourcePropertyValue) + " to " + this.logHelper.getValueForLog(propertyName, destinationPropertyValue) + ".");
                        updateDestinationWithSourceValue = false;
                    }
                    if (!updateDestinationWithSourceValue) continue;
                    this.setDocValue(destinationFile.getPath(), destinationConfigDocument, propertyName, sourcePropertyValue, this.getRemovedMapEntryList(defaultSourcePropertyValue, sourcePropertyValue, destinationPropertyValue));
                }
                catch (Exception e) {
                    throw new FileMigrationException("Error migrating property '" + propertyName + "': " + e.getMessage());
                }
            }
            String sourcePFVersion = PingFederateDirectoryInfo.getInstance().getSourcePFVersion();
            if (Version.compare(sourcePFVersion, "8.3.3") < 0) {
                this.migrateHSMKeystores(destinationFile, sourceMap, destinationConfigDocument);
            }
            ConfigStoreFileMigrator.save(destinationFile, (XmlObject)destinationConfigDocument);
        }
        catch (FileMigrationException | MigrationException | IOException e) {
            log.error("File not upgraded: " + destinationFile.getPath() + ". " + e.getMessage());
        }
    }

    private List<String> getRemovedMapEntryList(Object defaultSourcePropertyValue, Object sourcePropertyValue, Object destinationPropertyValue) {
        ArrayList<String> deletedEntries = new ArrayList<String>();
        if (defaultSourcePropertyValue instanceof Map) {
            Map defaultSourcePropertyMap = (Map)defaultSourcePropertyValue;
            Map sourcePropertyMap = (Map)sourcePropertyValue;
            Map destinationPropertyMap = (Map)destinationPropertyValue;
            for (Object key : defaultSourcePropertyMap.keySet()) {
                if (sourcePropertyMap.containsKey(key) || destinationPropertyMap == null || !destinationPropertyMap.containsKey(key)) continue;
                deletedEntries.add((String)key);
            }
        }
        return deletedEntries;
    }

    private void migrateHSMKeystores(File destinationFile, Map<String, Object> sourceMap, ConfigDocument destinationConfigDocument) throws IOException {
        String sourceRunPropertiesPath = this.getPingFederateDirectoryInfo().getSourceBinDir();
        File sourceRunPropertiesFile = new File(sourceRunPropertiesPath, "run.properties");
        Properties defaultSourceProps = FilesUtils.loadProperties(sourceRunPropertiesFile);
        String hsmMode = defaultSourceProps.getProperty("pf.hsm.mode");
        if (!StringUtils.equalsIgnoreCase((String)"OFF", (String)hsmMode)) {
            this.processKeystore(destinationFile, sourceMap, destinationConfigDocument, "ping-dsig.jks", "DsigKeystorePassword", "DsigHSMKeystorePassword", "DsigPrivateKeyPasswords", "DsigHSMPrivateKeyPasswords");
            this.processKeystore(destinationFile, sourceMap, destinationConfigDocument, "ping-ssl.jks", "SslKeystorePassword", "SslHSMKeystorePassword", "SslPrivateKeyPasswords", "SslHSMPrivateKeyPasswords");
            this.processKeystore(destinationFile, sourceMap, destinationConfigDocument, "ping-ssl-server.jks", "SslServerKeystorePassword", "SslServerHSMKeystorePassword", "SslServerPrivateKeyPasswords", "SslServerHSMPrivateKeyPasswords");
            this.processKeystore(destinationFile, sourceMap, destinationConfigDocument, "ping-general.jks", "GeneralKeystorePassword", "GeneralHSMKeystorePassword", "GeneralPrivateKeyPasswords", "GeneralHSMPrivateKeyPasswords");
            if (!StringUtils.equalsIgnoreCase((String)"LUNA", (String)hsmMode)) {
                this.processKeystore(destinationFile, sourceMap, destinationConfigDocument, "ping-trust.jks", "TrustKeystorePassword", "TrustHSMKeystorePassword", null, null);
            }
            if (StringUtils.equalsIgnoreCase((String)"LUNA", (String)hsmMode)) {
                this.migrateProperty(destinationFile, sourceMap, destinationConfigDocument, "DsigPublicKeystorePassword", "DsigKeystorePassword");
                this.migrateProperty(destinationFile, sourceMap, destinationConfigDocument, "SslPublicKeystorePassword", "SslKeystorePassword");
            }
        }
    }

    protected PingFederateDirectoryInfo getPingFederateDirectoryInfo() {
        return PingFederateDirectoryInfo.getInstance();
    }

    private void processKeystore(File destinationFile, Map<String, Object> sourceMap, ConfigDocument destinationConfigDocument, String keystoreFilename, String keystorePasswordField, String keystoreHsmPasswordField, String keystorePkPasswordField, String keystoreHsmPkPasswordField) {
        String sourceKeystorePath = this.getPingFederateDirectoryInfo().getSourceDataDir();
        File jksKeystore = new File(sourceKeystorePath, keystoreFilename);
        File hsmKeystore = new File(jksKeystore.getParent(), FilenameUtils.getBaseName((String)jksKeystore.getName()) + ".hsmks");
        if (jksKeystore.exists() && !hsmKeystore.exists() && !FilesUtils.isJksKeystore(jksKeystore)) {
            if (keystorePasswordField != null && sourceMap.get(keystorePasswordField) != null) {
                this.setDocValue(destinationFile.getPath(), destinationConfigDocument, keystoreHsmPasswordField, sourceMap.get(keystorePasswordField));
                this.removeItemFromConfigDoc(destinationConfigDocument, keystorePasswordField);
            }
            if (keystorePkPasswordField != null && sourceMap.get(keystorePkPasswordField) != null) {
                this.setDocValue(destinationFile.getPath(), destinationConfigDocument, keystoreHsmPkPasswordField, sourceMap.get(keystorePkPasswordField));
                this.removeMapFromConfigDoc(destinationConfigDocument, keystorePkPasswordField);
            }
        }
    }

    private void migrateProperty(File destinationFile, Map<String, Object> sourceMap, ConfigDocument destinationConfigDocument, String from, String to) {
        if (from != null && sourceMap.get(from) != null) {
            this.setDocValue(destinationFile.getPath(), destinationConfigDocument, to, sourceMap.get(from));
            this.removeItemFromConfigDoc(destinationConfigDocument, from);
        }
    }

    private void removeAndLogDeletedDefaultPropsFromDestination(Map<String, Object> defaultSourceMap, File sourceFile, Map<String, Object> sourceMap, File destinationFile, Map<String, Object> destinationMap, ConfigDocument destinationConfigDocument) throws FileMigrationException {
        for (Map.Entry<String, Object> defaultSourceEntry : defaultSourceMap.entrySet()) {
            String defaultSourcePropertyName = defaultSourceEntry.getKey();
            if (sourceMap.containsKey(defaultSourcePropertyName) || !destinationMap.containsKey(defaultSourcePropertyName)) continue;
            log.info("Default property " + defaultSourcePropertyName + " not found in " + LogHelper.getInstance().getCleanPath(sourceFile) + ". Removing property in " + LogHelper.getInstance().getCleanPath(destinationFile) + ".");
            this.removePropertyFromConfigDoc(destinationConfigDocument, defaultSourceEntry);
        }
    }

    private void setDocValue(String filePath, ConfigDocument configDoc, String propertyName, Object newPropertyValue) {
        this.setDocValue(filePath, configDoc, propertyName, newPropertyValue, null);
    }

    private void setDocValue(String filePath, ConfigDocument configDoc, String propertyName, Object newPropertyValue, List<String> removedMapEntryList) {
        ConfigType cfgType = configDoc.getConfig();
        if (newPropertyValue instanceof String || newPropertyValue instanceof Boolean || newPropertyValue instanceof Number) {
            ItemType[] items = cfgType.getItemArray();
            ItemType theItem = null;
            for (ItemType item : items) {
                if (!propertyName.equals(item.getName())) continue;
                theItem = item;
                break;
            }
            boolean addProperty = false;
            if (theItem == null) {
                addProperty = true;
                theItem = cfgType.addNewItem();
                theItem.setName(propertyName);
            }
            if (addProperty) {
                log.info("Update " + LogHelper.getInstance().getCleanPath(filePath) + ". Add property " + propertyName + ". Value set to " + this.logHelper.getValueForLog(propertyName, newPropertyValue) + ".");
            } else {
                log.info("Update " + LogHelper.getInstance().getCleanPath(filePath) + ". Change property " + propertyName + " from " + this.logHelper.getValueForLog(propertyName, theItem.getStringValue()) + " to " + this.logHelper.getValueForLog(propertyName, newPropertyValue) + ".");
            }
            if (newPropertyValue instanceof String) {
                theItem.setStringValue((String)newPropertyValue);
            } else {
                theItem.setStringValue(newPropertyValue.toString());
            }
        } else if (newPropertyValue instanceof Map) {
            MapType[] targetMapTypes = cfgType.getMapArray();
            MapType targetMapType = null;
            boolean preserveSourceOnUpgrade = false;
            for (MapType mapType : targetMapTypes) {
                if (!propertyName.equals(mapType.getName())) continue;
                preserveSourceOnUpgrade = mapType.getPreserveOnUpgrade();
                targetMapType = mapType;
                break;
            }
            if (targetMapType == null) {
                targetMapType = cfgType.addNewMap();
                targetMapType.setName(propertyName);
                log.info("Update " + LogHelper.getInstance().getCleanPath(filePath) + ". Add map property " + propertyName + ".");
            }
            Map newMapValue = (Map)newPropertyValue;
            if (!preserveSourceOnUpgrade) {
                for (ItemType targetMapItem : targetMapType.getItemArray()) {
                    boolean retainTargetMapItem;
                    String targetMapItemName = targetMapItem.getName();
                    boolean bl = retainTargetMapItem = !newMapValue.containsKey(targetMapItemName);
                    if (removedMapEntryList != null && removedMapEntryList.contains(targetMapItemName)) {
                        retainTargetMapItem = false;
                        log.info("Default entry " + targetMapItemName + " in map property " + propertyName + " not found in source. Removing entry in " + LogHelper.getInstance().getCleanPath(filePath) + ".");
                    }
                    if (!retainTargetMapItem) continue;
                    newMapValue.put(targetMapItemName, targetMapItem.getStringValue());
                }
            }
            ArrayList<ItemType> newMapItems = new ArrayList<ItemType>();
            for (Map.Entry newMapEntry : newMapValue.entrySet()) {
                String newItemName = (String)newMapEntry.getKey();
                boolean itemExistsInTargetMap = false;
                String targetItemValue = "";
                for (ItemType targetMapItem : targetMapType.getItemArray()) {
                    if (!targetMapItem.getName().equals(newItemName)) continue;
                    itemExistsInTargetMap = true;
                    targetItemValue = targetMapItem.getStringValue();
                    break;
                }
                ItemType newMapItem = targetMapType.addNewItem();
                newMapItem.setName(newItemName);
                Object newMapItemValue = newMapEntry.getValue();
                String newMapItemValueString = newMapItemValue != null ? newMapItemValue.toString() : "";
                newMapItem.setStringValue(newMapItemValueString);
                newMapItems.add(newMapItem);
                if (itemExistsInTargetMap) {
                    if (targetItemValue.equals(newMapItemValueString)) continue;
                    log.info("Update " + LogHelper.getInstance().getCleanPath(filePath) + ". Update entry " + newItemName + " in map property " + propertyName + ". Value changed from " + this.logHelper.getValueForLog(propertyName, newItemName, targetItemValue) + " to " + this.logHelper.getValueForLog(propertyName, newItemName, newMapItemValueString) + ".");
                    continue;
                }
                log.info("Update " + LogHelper.getInstance().getCleanPath(filePath) + ". Add entry " + newItemName + " to map property " + propertyName + ". Value set to " + this.logHelper.getValueForLog(propertyName, newItemName, newMapItemValueString) + ".");
            }
            targetMapType.setItemArray(newMapItems.toArray(new ItemType[newMapItems.size()]));
        } else if (newPropertyValue instanceof List) {
            ListType listType = null;
            for (ListType lt : cfgType.getListArray()) {
                if (!lt.getName().equals(propertyName)) continue;
                listType = lt;
                break;
            }
            boolean addPropertyList = false;
            if (listType == null) {
                addPropertyList = true;
                listType = cfgType.addNewList();
                listType.setName(propertyName);
            }
            if (addPropertyList) {
                log.info("Update " + LogHelper.getInstance().getCleanPath(filePath) + ". Add property list " + propertyName + ".");
            } else {
                log.info("Update " + LogHelper.getInstance().getCleanPath(filePath) + ". Update property list " + propertyName + ".");
            }
            List listValue = (List)newPropertyValue;
            String[] strings = listValue.toArray(new String[listValue.size()]);
            listType.setListItemArray(strings);
        }
    }

    protected static void save(File destinationConfigFile, XmlObject doc) throws FileMigrationException {
        FileOutputStream s;
        block5: {
            XmlOptions options = new XmlOptions();
            options.setSavePrettyPrint();
            options.setSavePrettyPrintIndent(4);
            s = null;
            try {
                s = new FileOutputStream(destinationConfigFile);
                if (doc != null) {
                    doc.save((OutputStream)s, options);
                    break block5;
                }
                s.flush();
            }
            catch (IOException e) {
                try {
                    throw new FileMigrationException("Error while saving " + destinationConfigFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    Closer.close(s);
                    throw throwable;
                }
            }
        }
        Closer.close((Closeable)s);
    }

    private void validateTargetProperties(File destinationFile, ConfigStoreFileCustomAction fileCustomAction, Map<String, Object> sourceMap, Map<String, Object> destinationMap, ConfigDocument document) {
        if (fileCustomAction != null && fileCustomAction.isValidateTargetProperties()) {
            ArrayList<String> removeProperties = new ArrayList<String>();
            for (Map.Entry<String, Object> destinationEntry : destinationMap.entrySet()) {
                String destinationPropertyName = destinationEntry.getKey();
                ConfigStorePropertyCustomAction customActionForProperty = fileCustomAction.getCustomActionForProperty(destinationPropertyName);
                if (customActionForProperty == null || customActionForProperty.isRetainTargetProperty(sourceMap.get(destinationPropertyName))) continue;
                removeProperties.add(destinationPropertyName);
                log.info("Update " + LogHelper.getInstance().getCleanPath(destinationFile.getPath()) + ". Remove property " + destinationPropertyName + ".");
            }
            for (String removeProperty : removeProperties) {
                this.removeItemFromConfigDoc(document, removeProperty);
            }
        }
        this.handlePropertiesMissingInSource(document, sourceMap, destinationFile);
    }

    private boolean handlePropertiesMissingInSource(ConfigDocument destinationConfigDoc, Map<String, Object> sourceMap, File destinationFile) {
        boolean destFileUpdated = false;
        ArrayList propertiesRemoved = new ArrayList();
        ConfigType configType = destinationConfigDoc.getConfig();
        ArrayList<ItemType> updatedItems = new ArrayList<ItemType>(Arrays.asList(configType.getItemArray()));
        updatedItems.removeIf(item -> {
            if (item.getPreserveOnUpgrade() && !item.isSetDefaultForUpgrade() && !sourceMap.containsKey(item.getName())) {
                propertiesRemoved.add(item.getName());
                return true;
            }
            return false;
        });
        for (ItemType item2 : updatedItems) {
            if (!item2.isSetDefaultForUpgrade() || sourceMap.containsKey(item2.getName())) continue;
            String origValue = item2.getStringValue();
            item2.setStringValue(item2.getDefaultForUpgrade());
            log.info("Update " + LogHelper.getInstance().getCleanPath(destinationFile.getPath()) + ". Change property " + item2.getName() + " from " + this.logHelper.getValueForLog(item2.getName(), origValue) + " to default for upgrade: " + this.logHelper.getValueForLog(item2.getName(), item2.getStringValue()) + ".");
            destFileUpdated = true;
        }
        configType.setItemArray(updatedItems.toArray(new ItemType[0]));
        ArrayList<MapType> updatedMaps = new ArrayList<MapType>(Arrays.asList(configType.getMapArray()));
        updatedMaps.removeIf(item -> {
            if (item.getPreserveOnUpgrade() && !sourceMap.containsKey(item.getName())) {
                propertiesRemoved.add(item.getName());
                return true;
            }
            return false;
        });
        configType.setMapArray(updatedMaps.toArray(new MapType[0]));
        ArrayList<ListType> updatedLists = new ArrayList<ListType>(Arrays.asList(configType.getListArray()));
        updatedLists.removeIf(item -> {
            if (item.getPreserveOnUpgrade() && !sourceMap.containsKey(item.getName())) {
                propertiesRemoved.add(item.getName());
                return true;
            }
            return false;
        });
        configType.setListArray(updatedLists.toArray(new ListType[0]));
        if (!propertiesRemoved.isEmpty()) {
            log.info("Update " + LogHelper.getInstance().getCleanPath(destinationFile.getPath()) + ". Removed properties not found in source: " + StringUtils.join(propertiesRemoved, (String)", ") + ".");
            destFileUpdated = true;
        }
        return destFileUpdated;
    }

    private boolean checkPreserveOnUpgrade(ConfigDocument destinationConfigDoc, String propertyName) {
        ConfigType configType = destinationConfigDoc.getConfig();
        for (ItemType itemType : configType.getItemArray()) {
            if (!propertyName.equals(itemType.getName()) || !itemType.getPreserveOnUpgrade()) continue;
            return true;
        }
        for (ItemType itemType : configType.getMapArray()) {
            if (!propertyName.equals(itemType.getName()) || !itemType.getPreserveOnUpgrade()) continue;
            return true;
        }
        for (ItemType itemType : configType.getListArray()) {
            if (!propertyName.equals(itemType.getName()) || !itemType.getPreserveOnUpgrade()) continue;
            return true;
        }
        return false;
    }

    private void removeItemFromConfigDoc(ConfigDocument document, String itemToRemove) {
        ConfigType cfgType = document.getConfig();
        ItemType[] items = cfgType.getItemArray();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getName().equals(itemToRemove)) continue;
            cfgType.removeItem(i);
        }
    }

    private void removeMapFromConfigDoc(ConfigDocument document, String mapToRemove) {
        ConfigType cfgType = document.getConfig();
        MapType[] items = cfgType.getMapArray();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getName().equals(mapToRemove)) continue;
            cfgType.removeMap(i);
        }
    }

    private void removeListFromConfigDoc(ConfigDocument document, String listToRemove) {
        ConfigType cfgType = document.getConfig();
        ListType[] items = cfgType.getListArray();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getName().equals(listToRemove)) continue;
            cfgType.removeList(i);
        }
    }

    private void removePropertyFromConfigDoc(ConfigDocument destinationConfigDocument, Map.Entry<String, Object> defaultSourceEntry) {
        String key = defaultSourceEntry.getKey();
        Object defaultSourcePropertyValue = defaultSourceEntry.getValue();
        if (defaultSourcePropertyValue instanceof Map) {
            this.removeMapFromConfigDoc(destinationConfigDocument, key);
        } else if (defaultSourcePropertyValue instanceof List) {
            this.removeListFromConfigDoc(destinationConfigDocument, key);
        } else {
            this.removeItemFromConfigDoc(destinationConfigDocument, key);
        }
    }
}

