/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.exception.FileMigrationException;
import com.pingidentity.pingcommons.util.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.config.impl.xml.ConfigDocument;
import org.sourceid.config.impl.xml.ConfigType;
import org.sourceid.config.impl.xml.ItemType;
import org.sourceid.config.impl.xml.MapType;

public class ConfigStoreHelper {
    public static ConfigDocument getConfigDocument(File configStoreFile) throws FileMigrationException {
        ConfigDocument configDocument;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configStoreFile);
            XmlObject xmlObject = XmlObject.Factory.parse((InputStream)fis);
            ConfigStoreHelper.validate(xmlObject);
            configDocument = (ConfigDocument)xmlObject;
        }
        catch (IOException | XmlException e) {
            try {
                throw new FileMigrationException("Unable to parse file. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Closer.close(fis);
                throw throwable;
            }
        }
        Closer.close((Closeable)fis);
        return configDocument;
    }

    private static void validate(XmlObject xmlObject) throws FileMigrationException {
        XmlOptions xmlOptions = new XmlOptions();
        LinkedList errors = new LinkedList();
        xmlOptions.setErrorListener(errors);
        xmlObject.validate(xmlOptions);
        if (errors.size() > 0) {
            String NEW_LINE = "\n";
            StringBuffer errorsSB = new StringBuffer();
            for (XmlError error : errors) {
                errorsSB.append(error.getMessage() + NEW_LINE);
            }
            throw new FileMigrationException(errorsSB.toString());
        }
    }

    public static Map<String, Object> getConfigStoreMapFromFile(ConfigDocument newDoc) throws FileMigrationException {
        MapType[] maps;
        ItemType[] items;
        ConfigType cfg = newDoc.getConfig();
        HashMap<String, Object> newConfigMap = new HashMap<String, Object>();
        for (ItemType item : items = cfg.getItemArray()) {
            newConfigMap.put(item.getName(), item.getStringValue());
        }
        for (MapType mapType : maps = cfg.getMapArray()) {
            ItemType[] mapItems;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            String mapName = mapType.getName();
            for (ItemType item : mapItems = mapType.getItemArray()) {
                map.put(item.getName(), item.getStringValue());
            }
            newConfigMap.put(mapName, map);
        }
        for (MapType mapType : cfg.getListArray()) {
            List<String> list = Arrays.asList(mapType.getListItemArray());
            String listName = mapType.getName();
            newConfigMap.put(listName, list);
        }
        return newConfigMap;
    }
}

