/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.FileMigrator;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.FileMigrationException;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileMigrationManager {
    private static final Logger log = LogManager.getLogger(FileMigrationManager.class);
    private final String sourceRootDir;
    private final String destinationRootDir;
    private final String templateRootDirForSourceVersion;

    public FileMigrationManager(String srcRootDir, String destRootDir, String refFileRootDirSrc) {
        this.sourceRootDir = srcRootDir;
        this.destinationRootDir = destRootDir;
        this.templateRootDirForSourceVersion = refFileRootDirSrc;
    }

    public void migrate(FileMigrator fileMigrator, String relativeDir, String fileName, FileCustomAction customAction) {
        this.migrate(fileMigrator, relativeDir, relativeDir, fileName, customAction);
    }

    public void migrate(FileMigrator fileMigrator, String sourceRelativeDir, String destinationRelativeDir, String fileName, FileCustomAction customAction) {
        File sourceFileParentDir = new File(this.sourceRootDir + sourceRelativeDir);
        File sourceFile = new File(sourceFileParentDir, fileName);
        File destinationFileParentDir = new File(this.destinationRootDir + destinationRelativeDir);
        File destinationFile = new File(destinationFileParentDir, fileName);
        String sourceDefaultRelativeDir = destinationRelativeDir;
        File sourceDefaultFileParentDir = new File(this.templateRootDirForSourceVersion + sourceDefaultRelativeDir);
        try {
            if (!sourceFile.exists()) {
                if (!(customAction != null && customAction.handleSourceFileNotFound(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName) || fileMigrator.handleSourceFileNotFound(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName))) {
                    log.debug("File not migrated: " + LogHelper.getInstance().getCleanPath(sourceFile) + ". File does not exist.");
                }
            } else if (customAction != null) {
                if (!fileMigrator.isDefaultFile(sourceDefaultFileParentDir, fileName) && customAction.copyIfSourceDefaultMissing()) {
                    fileMigrator.copy(sourceFile, destinationFile);
                } else {
                    fileMigrator.customMigrate(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName, customAction);
                }
            } else if (!destinationFile.exists()) {
                if (!fileMigrator.isDefaultFile(sourceDefaultFileParentDir, fileName)) {
                    fileMigrator.copy(sourceFile, destinationFile);
                } else {
                    log.debug("File not migrated. " + LogHelper.getInstance().getCleanPath(sourceFile) + " is no longer needed.");
                }
            } else if (!fileMigrator.isDefaultFile(sourceDefaultFileParentDir, fileName) && !fileMigrator.mergeSourceFilesWithMissingDefaultFile()) {
                log.debug("File not migrated. " + LogHelper.getInstance().getCleanPath(sourceFile) + " was not expected.");
            } else if (!fileMigrator.isFilesEqual(sourceFile, destinationFile)) {
                fileMigrator.merge(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName);
            } else {
                log.debug("File not migrated. " + LogHelper.getInstance().getCleanPath(sourceFile) + " is equal to " + LogHelper.getInstance().getCleanPath(destinationFile));
            }
        }
        catch (FileCustomActionException | FileMigrationException e) {
            log.error("Unable to migrate file " + LogHelper.getInstance().getCleanPath(destinationFile), (Throwable)e);
        }
    }
}

