/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.FileMigrationException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileMigrator {
    private static final Logger log = LogManager.getLogger(FileMigrator.class);

    public void customMigrate(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName, FileCustomAction customAction) throws FileCustomActionException {
        customAction.performMigration(sourceFileParentDir, destinationFileParentDir, sourceDefaultFileParentDir, fileName);
    }

    public void merge(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileMigrationException {
        log.warn("Unable to migrate " + sourceFileParentDir + File.separator + fileName + ". Merge not supported for this file.");
    }

    public void copy(File sourceFile, File destinationFile) throws FileMigrationException {
        try {
            if (sourceFile.isDirectory()) {
                FilesUtils.copyDirectory(sourceFile, destinationFile, true, true);
            } else {
                FilesUtils.copyfile(sourceFile, destinationFile);
            }
        }
        catch (IOException e) {
            throw new FileMigrationException("Unable to copy " + sourceFile.getPath() + " to " + destinationFile.getPath(), e);
        }
    }

    public boolean isDefaultFile(File sourceDefaultFileParentDir, String fileName) throws FileMigrationException {
        return new File(sourceDefaultFileParentDir, fileName).exists();
    }

    public boolean isFilesEqual(File sourceFile, File destinationFile) throws FileMigrationException {
        try {
            return FileUtils.contentEqualsIgnoreEOL((File)sourceFile, (File)destinationFile, null);
        }
        catch (IOException e) {
            throw new FileMigrationException("Unable to compare files", e);
        }
    }

    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileMigrationException {
        return false;
    }

    public boolean mergeSourceFilesWithMissingDefaultFile() {
        return false;
    }
}

