/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.pingcommons.util.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FilesUtils {
    private static final Logger log = LogManager.getLogger(FilesUtils.class);

    private FilesUtils() {
        throw new UnsupportedOperationException("not allowed");
    }

    public static File createTempDir() throws IOException {
        return FilesUtils.createTempDir(true);
    }

    public static File createTempDir(boolean logAsDebug) throws IOException {
        String dirName;
        File newTempDir;
        File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
        int maxAttempts = 9;
        int attemptCount = 0;
        do {
            if (++attemptCount <= 9) continue;
            throw new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 9 attempts.");
        } while ((newTempDir = new File(sysTempDir, dirName = UUID.randomUUID().toString())).exists());
        String message = "Creating " + newTempDir.getPath();
        if (logAsDebug) {
            log.debug(message);
        } else {
            log.info(message);
        }
        if (newTempDir.mkdirs()) {
            return newTempDir;
        }
        throw new IOException("Failed to create temp dir named " + newTempDir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFileList(File file) {
        List<String> list;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            list = FilesUtils.getFileList(fis);
        }
        catch (FileNotFoundException e) {
            List<String> list2;
            try {
                log.error("Error creating input stream for " + file.getPath());
                list2 = null;
            }
            catch (Throwable throwable) {
                Closer.close(fis);
                throw throwable;
            }
            Closer.close((Closeable)fis);
            return list2;
        }
        Closer.close((Closeable)fis);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getFileList(InputStream is) {
        ArrayList<String> fileList = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                fileList.add(line);
            }
        }
        catch (IOException e) {
            log.error("Error reading input stream", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error("Error closing input stream", (Throwable)e);
            }
        }
        return fileList;
    }

    public static void copyfile(File srcFile, File destFile) throws IOException {
        FilesUtils.copyfile(srcFile, destFile, false);
    }

    public static void copyfile(File srcFile, File destFile, boolean logAsDebug) throws IOException {
        FileUtils.copyFile((File)srcFile, (File)destFile);
        String logMessage = "Copy " + LogHelper.getInstance().getCleanPath(srcFile.getPath()) + " to " + LogHelper.getInstance().getCleanPath(destFile.getPath());
        if (logAsDebug) {
            log.debug(logMessage);
        } else {
            log.info(logMessage);
        }
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter fileFilter) {
        File[] filesToCopy = srcDir.listFiles(fileFilter);
        if (filesToCopy != null) {
            for (File f : filesToCopy) {
                if (f.isDirectory()) {
                    try {
                        log.info("Copy " + LogHelper.getInstance().getCleanPath(f.getPath()) + " to " + LogHelper.getInstance().getCleanPath(destDir.getPath()));
                        FileUtils.copyDirectoryToDirectory((File)f, (File)destDir);
                    }
                    catch (IOException ioe) {
                        log.error(ioe.getMessage());
                    }
                    continue;
                }
                try {
                    log.info("Copy " + LogHelper.getInstance().getCleanPath(f.getPath()) + " to " + LogHelper.getInstance().getCleanPath(destDir.getPath()));
                    FileUtils.copyFileToDirectory((File)f, (File)destDir);
                }
                catch (IOException ioe) {
                    log.error(ioe.getMessage());
                }
            }
        }
    }

    public static void copyDirectory(File srcDir, File destDir, boolean subDir, boolean logFilesAsDebug) {
        log.info("Copy " + LogHelper.getInstance().getCleanPath(srcDir.getPath()) + " to " + LogHelper.getInstance().getCleanPath(destDir.getPath()));
        FilesUtils.copyDirectoryFiles(srcDir, destDir, subDir, logFilesAsDebug);
    }

    public static void copyDirectory(File srcDir, File destDir, boolean subDir) {
        log.info("Copy " + LogHelper.getInstance().getCleanPath(srcDir.getPath()) + " to " + LogHelper.getInstance().getCleanPath(destDir.getPath()));
        FilesUtils.copyDirectoryFiles(srcDir, destDir, subDir, false);
    }

    private static void copyDirectoryFiles(File srcDir, File destDir, boolean subDir, boolean logFilesAsDebug) {
        File[] filesToCopy = srcDir.listFiles();
        if (filesToCopy != null) {
            for (File f : filesToCopy) {
                String logMessage;
                if (f.isDirectory()) {
                    if (!subDir) continue;
                    logMessage = "Copy " + LogHelper.getInstance().getCleanPath(f.getPath()) + " to " + LogHelper.getInstance().getCleanPath(destDir.getPath());
                    if (logFilesAsDebug) {
                        log.debug(logMessage);
                    } else {
                        log.info(logMessage);
                    }
                    FilesUtils.copyDirectoryFiles(f, new File(destDir, f.getName()), subDir, logFilesAsDebug);
                    continue;
                }
                try {
                    logMessage = "Copy " + LogHelper.getInstance().getCleanPath(f.getPath()) + " to " + LogHelper.getInstance().getCleanPath(destDir.getPath());
                    if (logFilesAsDebug) {
                        log.debug(logMessage);
                    } else {
                        log.info(logMessage);
                    }
                    FileUtils.copyFileToDirectory((File)f, (File)destDir);
                }
                catch (IOException ioe) {
                    log.error(ioe.getMessage());
                }
            }
        }
    }

    public static Properties loadProperties(File propertiesFile) throws IOException {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propertiesFile);
            if (fis == null) {
                throw new IOException("There is no resource " + propertiesFile.getPath());
            }
            props.load(fis);
        }
        catch (Throwable throwable) {
            Closer.close(fis);
            throw throwable;
        }
        Closer.close((Closeable)fis);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromClasspath(String fileName) {
        Properties properties;
        InputStream is = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            is = classLoader.getResourceAsStream(fileName);
            Properties properties2 = new Properties();
            properties2.load(is);
            properties = properties2;
        }
        catch (IOException e) {
            Properties properties3;
            try {
                log.error("Unable to load properties file " + fileName, (Throwable)e);
                properties3 = null;
            }
            catch (Throwable throwable) {
                Closer.close(is);
                throw throwable;
            }
            Closer.close((Closeable)is);
            return properties3;
        }
        Closer.close((Closeable)is);
        return properties;
    }

    public static void deleteFile(File fileToDelete) {
        log.info("Delete " + LogHelper.getInstance().getCleanPath(fileToDelete.getPath()));
        boolean successful = fileToDelete.delete();
        if (!successful) {
            log.error("Unable to delete file: " + fileToDelete.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJksKeystore(File file) {
        FileInputStream fis = null;
        try {
            KeyStore keystore = KeyStore.getInstance("jks");
            fis = new FileInputStream(file);
            keystore.load(fis, null);
            Closer.close((Closeable)fis);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Closer.close(fis);
        }
        return true;
    }

    public static String removeZipExtension(String filename) {
        if (filename == null || filename.isEmpty()) {
            return filename;
        }
        if (filename.endsWith(".zip")) {
            return filename.substring(0, filename.length() - 4);
        }
        return filename;
    }
}

