/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import java.io.File;

public class PingFederateDirectoryInfo {
    private static PingFederateDirectoryInfo instance;
    public static final String TEMP_SOURCE_DATA_ARCHIVE_DIR_NAME = "temp-source-data-archive";
    private String sourceRootDir;
    private String destinationRootDir;
    private String homeDir;
    private String sourcePFVersion;

    private PingFederateDirectoryInfo() {
    }

    public static PingFederateDirectoryInfo getInstance() {
        if (instance == null) {
            instance = new PingFederateDirectoryInfo();
        }
        return instance;
    }

    public String getSourceRootDir() {
        return this.sourceRootDir;
    }

    public void setSourceRootDir(String sourceRootDir) {
        this.sourceRootDir = sourceRootDir;
    }

    public String getDestinationRootDir() {
        return this.destinationRootDir;
    }

    public void setDestinationRootDir(String destinationRootDir) {
        this.destinationRootDir = destinationRootDir;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public void setSourcePFVersion(String sourcePFVersion) {
        this.sourcePFVersion = sourcePFVersion;
    }

    public String getSourcePFVersion() {
        return this.sourcePFVersion;
    }

    public String getRelativeDefaultServerDir() {
        return File.separator + "server" + File.separator + "default";
    }

    public String getRelativeDataDir() {
        return this.getRelativeDefaultServerDir() + File.separator + "data";
    }

    public String getSourceRelativeDataDir() {
        if (this.getSourceRootDir() == null) {
            return "";
        }
        return this.getRelativeDataDir();
    }

    public String getSourceRelativeConfigStoreDir() {
        if (this.getSourceRootDir() == null) {
            return File.separator + "config-store";
        }
        return this.getRelativeConfigStoreDir();
    }

    public String getRelativeConfigStoreDir() {
        return this.getRelativeDataDir() + File.separator + "config-store";
    }

    public String getRelativeInstanceDataDir() {
        return this.getRelativeDataDir() + File.separator + "instance";
    }

    public String getRelativeDeployDir() {
        return this.getRelativeDefaultServerDir() + File.separator + "deploy";
    }

    public String getRelativeUpdateDir() {
        return this.getRelativeDataDir() + File.separator + "update";
    }

    public String getRelativeConfDir() {
        return this.getRelativeDefaultServerDir() + File.separator + "conf";
    }

    public String getRelativeConfTemplateDir() {
        return this.getRelativeConfDir() + File.separator + "template";
    }

    public String getRelativeServerLibDir() {
        return this.getRelativeDefaultServerDir() + File.separator + "lib";
    }

    public String getRelativeBinDir() {
        return File.separator + "bin";
    }

    public String getRelativeStartupDir() {
        return File.separator + "startup";
    }

    public String getRelativeEtcDir() {
        return File.separator + "etc";
    }

    public String getRelativeLibDir() {
        return File.separator + "lib";
    }

    public String getReferenceFilesRootDir() {
        return this.homeDir + File.separator + "reference-files";
    }

    public String getReferenceFilesRootDirForConnectors() {
        return this.getReferenceFilesRootDir() + File.separator + "connectors";
    }

    public String getReferenceFilesRootDirForSourceVersion() {
        return this.getReferenceFilesRootDir() + File.separator + this.sourcePFVersion;
    }

    public String getSourceConfigStoreDir() {
        return this.getSourceRootDir() + this.getRelativeConfigStoreDir();
    }

    public String getSourceUpdateDir() {
        return this.getSourceRootDir() + this.getRelativeUpdateDir();
    }

    public String getDestinationUpdateDir() {
        return this.getDestinationRootDir() + this.getRelativeUpdateDir();
    }

    public String getSourceDataDir() {
        if (this.getSourceRootDir() == null) {
            return this.destinationRootDir + File.separator + TEMP_SOURCE_DATA_ARCHIVE_DIR_NAME;
        }
        return this.getSourceRootDir() + this.getRelativeDataDir();
    }

    public String getSourceBinDir() {
        return this.getSourceRootDir() + this.getRelativeBinDir();
    }

    public String getSourceLanguagePackDir() {
        return this.getSourceRootDir() + this.getRelativeLanguagePackDir();
    }

    public String getSourceTemplateDir() {
        return this.getSourceRootDir() + this.getRelativeConfTemplateDir();
    }

    public String getDestinationLanguagePackDir() {
        return this.getDestinationRootDir() + this.getRelativeLanguagePackDir();
    }

    public String getRelativeLanguagePackDir() {
        return this.getRelativeConfDir() + File.separator + "language-packs";
    }

    public String getReferenceFilesLanguagePackDir() {
        return this.getReferenceFilesRootDirForSourceVersion() + File.separator + this.getRelativeLanguagePackDir();
    }

    public String getSourceEmailTemplateDir() {
        return this.getSourceTemplateDir() + File.separator + "mail-notifications";
    }
}

