/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.ExtensionsType;
import org.sourceid.saml20.xmlbinding.metadata.localext.v2.ExtensionRootType;

public class Saml2LocalMetadataMigrator {
    private static final Logger logger = LogManager.getLogger(Saml2LocalMetadataMigrator.class);
    private static final String LOCAL_METADATA_FILENAME = "sourceid-saml2-local-metadata.xml";
    private static final String ADAPTER_SELECTOR_FILENAME = "adapter-selectors.xml";

    public void migrate(String srcDataDir, String destDataDir) {
        this.migrateLegacyCidrSelectorSettings(destDataDir);
        this.warnDeprecatedAutoConnect(srcDataDir);
        this.updateClientCertHeaderAuth(destDataDir);
    }

    private void updateClientCertHeaderAuth(String destDataDir) {
        String localMetadata = destDataDir + File.separator + LOCAL_METADATA_FILENAME;
        File file = new File(localMetadata);
        try {
            EntityDescriptorDocument entityDescriptorDoc = EntityDescriptorDocument.Factory.parse((File)file);
            EntityDescriptorType entityDescType = entityDescriptorDoc.getEntityDescriptor();
            ExtensionsType extensionsType = entityDescType.getExtensions();
            XmlObject xml = this.getFirstChild((XmlObject)extensionsType);
            ExtensionRootType extensionRootType = (ExtensionRootType)xml;
            if (extensionRootType == null) {
                logger.error("ExtensionRootType is null");
                return;
            }
            if (!extensionRootType.isSetEnableClientCertHeaderAuth()) {
                boolean clientCertSSLHeaderNameIsConfigured = extensionRootType.isSetClientCertSSLHeaderName() && StringUtils.isNotBlank((String)extensionRootType.getClientCertSSLHeaderName());
                boolean clientCertChainSSLHeaderNameIsCondigured = extensionRootType.isSetClientCertChainSSLHeaderName() && StringUtils.isNotBlank((String)extensionRootType.getClientCertChainSSLHeaderName());
                extensionRootType.setEnableClientCertHeaderAuth(clientCertSSLHeaderNameIsConfigured || clientCertChainSSLHeaderNameIsCondigured);
            }
            if (!extensionRootType.isSetClientCertEncodingFormat()) {
                extensionRootType.setClientCertEncodingFormat("APACHE_MOD_SSL");
            }
            XmlOptions options = new XmlOptions();
            options.setSavePrettyPrint();
            options.setSavePrettyPrintIndent(4);
            entityDescriptorDoc.save(file, options);
        }
        catch (IOException | XmlException e) {
            logger.error("File not upgraded: " + localMetadata + ". " + e.getMessage());
        }
    }

    protected void warnDeprecatedAutoConnect(String srcDataDir) {
        String localMetadata = srcDataDir + File.separator + LOCAL_METADATA_FILENAME;
        File file = new File(localMetadata);
        try {
            if (this.getMatchingStringFromFile(file, "EnableSpDynaFed=\"true\"") != null || this.getMatchingStringFromFile(file, "EnableIdpDynaFed=\"true\"") != null) {
                logger.warn("Auto-Connect has been deprecated and is no longer supported in PingFederate. Please use a SAML2.0 IdP or SP connection.");
            }
        }
        catch (IOException e) {
            logger.error("Unable to process the file " + file.getAbsolutePath());
        }
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    protected void migrateLegacyCidrSelectorSettings(String destDataDir) {
        List<File> adapterSelectorXmlFile = this.getXmlFilesFromTargetDir(new File(destDataDir, "config-store"), List.of(ADAPTER_SELECTOR_FILENAME));
        if (!adapterSelectorXmlFile.isEmpty()) {
            List<File> cidrAdapterSelectorFiles;
            List<String> cidrAdapterSelectorNames;
            File adapterSelectorsConfigFile = adapterSelectorXmlFile.get(0);
            try {
                cidrAdapterSelectorNames = this.getCidrAdapterSelectorNames(adapterSelectorsConfigFile);
            }
            catch (IOException ioe) {
                logger.error("Unable to process the file " + adapterSelectorsConfigFile.getAbsolutePath());
                return;
            }
            if (!cidrAdapterSelectorNames.isEmpty() && this.isContainsXForwardedFor(cidrAdapterSelectorFiles = this.getXmlFilesFromTargetDir(new File(destDataDir, "adapter-selectors"), cidrAdapterSelectorNames))) {
                String localMetadata = destDataDir + File.separator + LOCAL_METADATA_FILENAME;
                File file = new File(localMetadata);
                try {
                    EntityDescriptorDocument entityDescriptorDoc = EntityDescriptorDocument.Factory.parse((File)file);
                    EntityDescriptorType entityDescType = entityDescriptorDoc.getEntityDescriptor();
                    ExtensionsType extensionsType = entityDescType.getExtensions();
                    XmlObject xml = this.getFirstChild((XmlObject)extensionsType);
                    ExtensionRootType extensionRootType = (ExtensionRootType)xml;
                    extensionRootType.setCustomGlobalHttpHeaderName("X-Forwarded-For");
                    XmlOptions options = new XmlOptions();
                    options.setSavePrettyPrint();
                    options.setSavePrettyPrintIndent(4);
                    entityDescriptorDoc.save(file, options);
                }
                catch (Exception e) {
                    logger.error("File not upgraded: " + localMetadata + ". " + e.getMessage());
                }
            }
        }
    }

    protected boolean isContainsXForwardedFor(List<File> cidrAdapterSelectorFiles) {
        if (cidrAdapterSelectorFiles != null) {
            for (File cidrAdapterSelectorFile : cidrAdapterSelectorFiles) {
                try {
                    String matchingLine = this.getMatchingStringFromFile(cidrAdapterSelectorFile, "X-Forwarded-For");
                    if (!StringUtils.isNotBlank((String)matchingLine) || !matchingLine.contains("true")) continue;
                    return true;
                }
                catch (IOException ioe) {
                    logger.error("Error reading file: " + cidrAdapterSelectorFile.getAbsolutePath() + "  Error: " + ioe.getMessage());
                }
            }
        }
        return false;
    }

    protected List<String> getCidrAdapterSelectorNames(File adapterSelectorConfigFile) throws IOException {
        String cidrClassname = "com.pingidentity.pf.selectors.cidr.CIDRAdapterSelector";
        LinkedList<String> cidrSelectorNames = new LinkedList<String>();
        String matchingLine = this.getMatchingStringFromFile(adapterSelectorConfigFile, cidrClassname);
        if (StringUtils.isNotBlank((String)matchingLine)) {
            String fileName = StringUtils.substringAfterLast((String)StringUtils.substringBeforeLast((String)matchingLine, (String)"\""), (String)"\"").trim();
            cidrSelectorNames.add(fileName + ".xml");
        }
        return cidrSelectorNames;
    }

    protected String getMatchingStringFromFile(File f, String strToMatch) throws IOException {
        if (f != null) {
            List fileLines = IOUtils.readLines((InputStream)FileUtils.openInputStream((File)f), (String)"UTF-8");
            for (String fileLine : fileLines) {
                if (!fileLine.contains(strToMatch)) continue;
                return fileLine;
            }
        }
        return null;
    }

    protected List<File> getXmlFilesFromTargetDir(File targetDir, List<String> filenames) {
        LinkedList<File> matchingFiles = new LinkedList<File>();
        String[] fileExt = new String[]{"xml"};
        Collection files = FileUtils.listFiles((File)targetDir, (String[])fileExt, (boolean)false);
        for (File f : files) {
            for (String filename : filenames) {
                if (!filename.equals(f.getName())) continue;
                matchingFiles.add(f);
            }
        }
        return matchingFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlObject getFirstChild(XmlObject xml) {
        XmlCursor xmlCursor = null;
        try {
            xmlCursor = xml.newCursor();
            boolean hasFirstChild = xmlCursor.toFirstChild();
            if (hasFirstChild) {
                XmlObject xmlObject = xmlCursor.getObject();
                return xmlObject;
            }
        }
        finally {
            this.disposeCursor(xmlCursor);
        }
        return null;
    }

    private void disposeCursor(XmlCursor cur) {
        if (cur != null) {
            cur.dispose();
        }
    }
}

