/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.LogHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.saml20.xmlbinding.metadata.AttributeConsumingServiceType;
import org.sourceid.saml20.xmlbinding.metadata.EntitiesDescriptorDocument;
import org.sourceid.saml20.xmlbinding.metadata.EntitiesDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.EntityDescriptorType;
import org.sourceid.saml20.xmlbinding.metadata.RequestedAttributeType;
import org.sourceid.saml20.xmlbinding.metadata.SPSSODescriptorType;

public class Saml2MetadataMigrator {
    private static final Logger log = LogManager.getLogger(Saml2MetadataMigrator.class);
    private static final String FILENAME = "sourceid-saml2-metadata.xml";
    private static final String BASIC = "urn:oasis:names:tc:SAML:2.0:attrname-format:basic";

    public void migrate(String destDataDir) {
        String metadata = destDataDir + File.separator + FILENAME;
        File file = new File(metadata);
        EntitiesDescriptorDocument entitiesDescriptorDoc = null;
        boolean isModified = false;
        try {
            entitiesDescriptorDoc = EntitiesDescriptorDocument.Factory.parse((File)file);
            EntitiesDescriptorType entitiesDescriptor = entitiesDescriptorDoc.getEntitiesDescriptor();
            for (EntityDescriptorType entityDescriptor : entitiesDescriptor.getEntityDescriptorArray()) {
                for (SPSSODescriptorType spSSODescriptor : entityDescriptor.getSPSSODescriptorArray()) {
                    List protocolSupport = spSSODescriptor.getProtocolSupportEnumeration();
                    if (!protocolSupport.contains("WSFED") && !protocolSupport.contains("urn:oasis:names:tc:SAML:1.1:protocol")) continue;
                    for (AttributeConsumingServiceType acs : spSSODescriptor.getAttributeConsumingServiceArray()) {
                        for (RequestedAttributeType requestedAttr : acs.getRequestedAttributeArray()) {
                            if (!BASIC.equals(requestedAttr.getNameFormat())) continue;
                            requestedAttr.unsetNameFormat();
                            isModified = true;
                            log.info("Update " + LogHelper.getInstance().getCleanPath(metadata) + ". Remove urn:oasis:names:tc:SAML:2.0:attrname-format:basic attribute NameFormat from connection " + entityDescriptor.getEntityID() + ".");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("File not upgraded: " + metadata + ". " + e.getMessage());
            return;
        }
        if (isModified) {
            try {
                XmlOptions options = new XmlOptions();
                options.setSavePrettyPrint();
                options.setSavePrettyPrintIndent(4);
                entitiesDescriptorDoc.save(file, options);
            }
            catch (IOException e) {
                log.error("File not upgraded: " + metadata + ". " + e.getMessage());
            }
        }
    }
}

