/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.exception.FileHandlingException;
import com.pingidentity.common.upgrade.exception.MigrationException;
import com.pingidentity.common.upgrade.exception.UnsupportedUpgradeVersionException;
import com.pingidentity.pingcommons.upgrade.zip.UnzipUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Utils {
    private static final Logger log = LogManager.getLogger(Utils.class);

    private Utils() {
        throw new UnsupportedOperationException("not allowed");
    }

    public static boolean eligibleForForceUpgrade(Version sourceActualPFVersion, Version destinationPFVersion) {
        Version dstMajorMinorVersion;
        Version srcMajorMinorVersion = new Version(sourceActualPFVersion.getMajor(), sourceActualPFVersion.getMinor(), 0);
        return srcMajorMinorVersion.compareTo(dstMajorMinorVersion = new Version(destinationPFVersion.getMajor(), destinationPFVersion.getMinor(), 0)) < 0;
    }

    public static Version findClosestSupportedSourceVersion(Version sourceActualPFVersion, String referenceFilesDirPath) {
        int srcMajorVersion = sourceActualPFVersion.getMajor();
        int srcMinorVersion = sourceActualPFVersion.getMinor();
        File referenceFilesDir = new File(referenceFilesDirPath);
        for (int srcPatchVersion = sourceActualPFVersion.getPatch() - 1; srcPatchVersion >= 0; --srcPatchVersion) {
            Version closestSupportedSourceVersion = new Version(srcMajorVersion, srcMinorVersion, srcPatchVersion);
            if (!new File(referenceFilesDir, closestSupportedSourceVersion + ".zip").exists()) continue;
            return closestSupportedSourceVersion;
        }
        return null;
    }

    public static Version resolveClosestSupportedSourceVersion(Version sourceActualPFVersion, Version destinationPFVersion, String referenceFilesDir, String sourcePFVersionPath) throws UnsupportedUpgradeVersionException {
        if (new File(referenceFilesDir, sourceActualPFVersion.toString() + ".zip").exists()) {
            return sourceActualPFVersion;
        }
        if (!Utils.eligibleForForceUpgrade(sourceActualPFVersion, destinationPFVersion)) {
            String errorMessage = String.format("Unable to complete upgrade. The source version (%s) is not eligible for upgrade to the destination version (%s).", sourceActualPFVersion, destinationPFVersion);
            throw new UnsupportedUpgradeVersionException(errorMessage);
        }
        log.debug("No matching reference files for source version ({}). Identifying closest matching source version ...", (Object)sourceActualPFVersion);
        Version newSourcePFVersion = Utils.findClosestSupportedSourceVersion(sourceActualPFVersion, referenceFilesDir);
        if (newSourcePFVersion == null) {
            log.debug("No closest matching reference files for source version ({}).", (Object)sourceActualPFVersion);
            String errorMessage = String.format("Unable to complete upgrade. This tool does not support upgrading the version (%s) of PingFederate defined by (%s).", sourceActualPFVersion, sourcePFVersionPath);
            throw new UnsupportedUpgradeVersionException(errorMessage);
        }
        log.info("Source version ({}) is being treated as equivalent to known reference version {}.", (Object)sourceActualPFVersion, (Object)newSourcePFVersion);
        return newSourcePFVersion;
    }

    public static File unzipDefaultPFInstall(String referenceFilesDir, Version sourceReferencePFVersion) throws FileHandlingException {
        File sourcePFReferenceFilesDir = new File(referenceFilesDir, sourceReferencePFVersion.toString());
        File sourcePFReferenceZip = new File(referenceFilesDir, sourceReferencePFVersion + ".zip");
        try {
            Utils.deleteFolder(sourcePFReferenceFilesDir);
            boolean created = sourcePFReferenceFilesDir.mkdir();
            if (!created) {
                throw new FileHandlingException("Error while creating the directory " + sourcePFReferenceFilesDir.getPath());
            }
            UnzipUtil.deployToFilesystem((String)sourcePFReferenceFilesDir.getPath(), (File)sourcePFReferenceZip);
            return sourcePFReferenceFilesDir;
        }
        catch (IOException e) {
            throw new FileHandlingException("Error while unzipping the file " + sourcePFReferenceZip.getPath(), e);
        }
    }

    public static Version getSourceVersionFromConfigArchive(Map<String, byte[]> archiveMap) {
        String archiveVersion = Utils.getVersionFromConfigArchive(archiveMap);
        if ("Unknown".equals(archiveVersion)) {
            log.warn("Unknown Pingfederate version in config archive.");
            return null;
        }
        try {
            return new Version(archiveVersion);
        }
        catch (MigrationException e) {
            log.warn("Error parsing Pingfederate version from config archive: " + e.getMessage());
            return null;
        }
    }

    public static Version getCurrentPingFederateVersion() {
        try {
            return new Version(System.getProperty("pingfederate.version"));
        }
        catch (MigrationException e) {
            log.error("Error finding current PingFederate version.", (Throwable)e);
            return null;
        }
    }

    public static String getVersionFromConfigArchive(Map<String, byte[]> archiveMap) {
        byte[] archiveMetadataBytes = archiveMap.get("archive-metadata");
        if (archiveMetadataBytes == null) {
            log.warn("No archive-metadata file found in config archive.");
            return "Unknown";
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(archiveMetadataBytes);
        Properties props = new Properties();
        try {
            props.load(inputStream);
            return props.getProperty("Version");
        }
        catch (IOException e) {
            log.error("Error reading archive-metadata file.", (Throwable)e);
            return "Unknown";
        }
    }

    public static String getReferenceFilesDir(String upgradeDir) {
        return upgradeDir + File.separator + "reference-files";
    }

    public static void deleteFolder(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            log.debug("Error deleting directory {}", (Object)dir.getPath(), (Object)e);
        }
    }

    public static void deletePfJwkFileFromDir(String dir) {
        File pfJwk = new File(dir, "pf.jwk");
        if (pfJwk.exists() && !pfJwk.delete()) {
            log.error("Failed to delete file: {}", (Object)pfJwk.getAbsolutePath());
        }
    }
}

