/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.exception.MigrationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private final int major;
    private final int minor;
    private final int patch;
    private int build;
    private boolean includeBuild = false;
    public static final Pattern versionRegex = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(\\.(\\d+))?");

    public Version(String version) throws MigrationException {
        this(version, false);
    }

    public Version(String version, boolean includeBuild) throws MigrationException {
        this.includeBuild = includeBuild;
        Matcher matcher = versionRegex.matcher(version);
        if (matcher.find()) {
            String buildNumber;
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.patch = Integer.parseInt(matcher.group(3));
            if (includeBuild && (buildNumber = matcher.group(5)) != null) {
                this.build = Integer.parseInt(buildNumber);
            }
        } else {
            throw new MigrationException("Unexpected version format: " + version);
        }
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Version(int major, int minor, int patch, int build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.includeBuild = true;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getBuild() {
        return this.build;
    }

    public boolean getIncludeBuild() {
        return this.includeBuild;
    }

    public int compareTo(Version that) {
        int result = this.major - that.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - that.minor;
        if (result != 0) {
            return result;
        }
        result = this.patch - that.patch;
        if (result != 0) {
            return result;
        }
        result = this.build - that.build;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version that = (Version)obj;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return -1;
    }

    public String toString() {
        String result = this.major + "." + this.minor + "." + this.patch;
        if (this.includeBuild) {
            result = result + "." + this.build;
        }
        return result;
    }

    public String toLogString() {
        String build = this.major + "." + this.minor + "." + this.patch;
        if (this.patch < 200) {
            return build;
        }
        int rValue = this.patch / 100;
        return this.major + "." + this.minor + "-R" + rValue + " (" + build + ")";
    }

    public static int compare(String version1, String version2) throws MigrationException {
        Version v1 = new Version(version1);
        Version v2 = new Version(version2);
        return v1.compareTo(v2);
    }
}

