/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade.custom;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.PingFederateDirectoryInfo;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.source2target.xmlbinding.Source2TargetPluginMappingType;
import org.sourceid.source2target.xmlbinding.Source2TargetPluginMappingsDocument;

public class Adapter2AdapterCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(Adapter2AdapterCustomAction.class);

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File srcAdapter2AdapterMappingXmlFile = new File(sourceFileParentDir, fileName);
        if (srcAdapter2AdapterMappingXmlFile.exists()) {
            File destAdapter2AdapterMappingXmlFile = new File(destinationFileParentDir, fileName);
            try {
                FilesUtils.copyfile(srcAdapter2AdapterMappingXmlFile, destAdapter2AdapterMappingXmlFile);
            }
            catch (Exception e) {
                log.error("Unable to migrate file " + LogHelper.getInstance().getCleanPath(srcAdapter2AdapterMappingXmlFile), (Throwable)e);
                return;
            }
            try {
                Source2TargetPluginMappingsDocument destOriginal = Source2TargetPluginMappingsDocument.Factory.parse((File)destAdapter2AdapterMappingXmlFile);
                Source2TargetPluginMappingsDocument destCopy = (Source2TargetPluginMappingsDocument)destOriginal.copy();
                String logMessage = this.removeMappingsWithMissingAdapterConfigurations(destOriginal, destCopy);
                if (logMessage != null) {
                    this.updateFile(destCopy, destAdapter2AdapterMappingXmlFile, logMessage);
                }
            }
            catch (Exception e) {
                log.error("Unable to update file " + LogHelper.getInstance().getCleanPath(destAdapter2AdapterMappingXmlFile), (Throwable)e);
            }
        }
    }

    @Override
    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        return false;
    }

    @Override
    public boolean copyIfSourceDefaultMissing() {
        return false;
    }

    private String removeMappingsWithMissingAdapterConfigurations(Source2TargetPluginMappingsDocument destOriginal, Source2TargetPluginMappingsDocument destCopy) {
        HashSet<CallSite> removedA2AMappings = new HashSet<CallSite>();
        ArrayList<Source2TargetPluginMappingType> mappingsToKeep = new ArrayList<Source2TargetPluginMappingType>();
        for (Source2TargetPluginMappingType source2TargetPluginMappingType : destOriginal.getSource2TargetPluginMappings().getSource2TargetPluginMappingArray()) {
            String idpId = source2TargetPluginMappingType.getSourcePluginId();
            String spId = source2TargetPluginMappingType.getTargetPluginId();
            File idpAdapterConfigFile = new File(this.getSourceDataDir() + File.separator + "adapter-config", idpId + ".xml");
            File spAdapterConfigFile = new File(this.getSourceDataDir() + File.separator + "adapter-config", spId + ".xml");
            if (idpAdapterConfigFile.exists() && spAdapterConfigFile.exists()) {
                mappingsToKeep.add(source2TargetPluginMappingType);
                continue;
            }
            removedA2AMappings.add((CallSite)((Object)(idpId + "-to-" + spId)));
        }
        String errorMessage = null;
        if (!removedA2AMappings.isEmpty()) {
            destCopy.getSource2TargetPluginMappings().setSource2TargetPluginMappingArray(mappingsToKeep.toArray(new Source2TargetPluginMappingType[mappingsToKeep.size()]));
            StringBuilder sb = new StringBuilder("The following Adapter-to-Adapter Mappings were removed due to missing adapter configuration(s): [ ");
            for (String string : removedA2AMappings) {
                sb.append(string).append(" ");
            }
            sb.append("]");
            errorMessage = sb.toString();
        }
        return errorMessage;
    }

    private void updateFile(Source2TargetPluginMappingsDocument destCopy, File destAdapter2AdapterMappingXmlFile, String logMessage) throws IOException {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        destCopy.save(destAdapter2AdapterMappingXmlFile, options);
        StringBuilder sb = new StringBuilder("Update ");
        sb.append(LogHelper.getInstance().getCleanPath(destAdapter2AdapterMappingXmlFile.getPath()));
        sb.append(". ");
        sb.append(logMessage);
        log.info(sb.toString());
    }

    protected String getSourceDataDir() {
        return PingFederateDirectoryInfo.getInstance().getSourceDataDir();
    }
}

