/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade.custom.configstorefile;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LinkedHashMapUtils;
import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStoreFileCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStorePropertyCustomAction;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Scanner;

public class JCEManagerCustomAction
extends ConfigStoreFileCustomAction {
    public static final String CIPHER_SUITES_PROPERTY_NAME = "enabled-cipher-suites";

    public JCEManagerCustomAction(String mode, final String fileName) {
        this.addCustomActionForProperty(CIPHER_SUITES_PROPERTY_NAME, new ConfigStorePropertyCustomAction(mode){

            @Override
            public boolean isUseSourceValue(Object sourceValue, Object destinationValue, Object defaultSourceValue) {
                boolean useSourceValue = false;
                if ("-c".equals(this.getMode())) {
                    String userResponse = this.promptUser();
                    return !userResponse.equalsIgnoreCase("y");
                }
                if (!(sourceValue instanceof LinkedHashMap)) {
                    String errMsg = "Unexpected type for 'enabled-cipher-suites' property from source file '" + fileName + "'";
                    throw new IllegalArgumentException(errMsg);
                }
                if (!(defaultSourceValue instanceof LinkedHashMap)) {
                    String errMsg = "Unexpected type for 'enabled-cipher-suites' property from default source file '" + fileName + "'";
                    throw new IllegalArgumentException(errMsg);
                }
                LinkedHashMap sourceValueMap = (LinkedHashMap)sourceValue;
                LinkedHashMap defaultSourceMap = (LinkedHashMap)defaultSourceValue;
                if (!LinkedHashMapUtils.isEqualConsiderOrder(sourceValueMap, defaultSourceMap)) {
                    useSourceValue = true;
                }
                return useSourceValue;
            }

            @Override
            public String getPromptQuestionId() {
                return "com.pingidentity.crypto.JCEManager.xml_enabled-cipher-suites";
            }

            @Override
            public boolean isRetainTargetProperty(Object sourceValue) {
                return true;
            }

            @Override
            public String promptUser() {
                Properties promptMessages = FilesUtils.loadPropertiesFromClasspath("custom-mode-messages.properties");
                Object promptMessage = promptMessages.getProperty(this.getPromptQuestionId());
                promptMessage = promptMessage == null ? "***** PUT MESSAGE IN custom-mode-messages.properties *****" : MessageFormat.format((String)promptMessage, fileName) + " ";
                System.out.print((String)promptMessage);
                Scanner in = new Scanner(System.in, "UTF-8");
                return in.nextLine();
            }
        });
    }
}

