/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade.custom.configstorefile;

import com.pingidentity.common.upgrade.ConfigStoreHelper;
import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStoreFileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.common.upgrade.exception.FileMigrationException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.impl.xml.ConfigDocument;

public class UnboundIDAccessGrantCustomAction
extends ConfigStoreFileCustomAction {
    public UnboundIDAccessGrantCustomAction(String mode) {
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File store = new File(sourceFileParentDir + File.separator + fileName);
        if (this.isMigrationNeeded(store)) {
            File destinationFile = new File(destinationFileParentDir + File.separator + fileName);
            try {
                FilesUtils.copyfile(store, destinationFile);
            }
            catch (IOException e) {
                throw new FileCustomActionException(e.getMessage(), e);
            }
        }
    }

    public boolean isMigrationNeeded(File store) {
        try {
            Object obj;
            ConfigDocument configDoc = ConfigStoreHelper.getConfigDocument(store);
            Map<String, Object> config = ConfigStoreHelper.getConfigStoreMapFromFile(configDoc);
            if (config.containsKey("PingFederateDSJNDIName") && (obj = config.get("PingFederateDSJNDIName")) != null && StringUtils.isNotEmpty((String)((String)obj))) {
                return true;
            }
        }
        catch (FileMigrationException e) {
            return false;
        }
        return false;
    }
}

