/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.consistent;

import com.pingidentity.common.util.consistent.ConsistentHashFunction;
import com.pingidentity.common.util.consistent.DigestConsistentHashFunction;
import com.pingidentity.common.util.consistent.HashRingNode;
import com.pingidentity.common.util.consistent.Range;
import com.pingidentity.common.util.consistent.RangeDiff;
import com.pingidentity.common.util.consistent.RangeList;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsistentHashRing {
    private static final Log log = LogFactory.getLog(ConsistentHashRing.class);
    private static final ConsistentHashFunction DEFAULT_HASH_FUNCTION = new DigestConsistentHashFunction(HashAlgorithm.SHA256, 1000000000);
    private Set<HashRingNode> nodes;
    private int replicationFactor;
    private NavigableMap<Integer, HashRange> ranges = new TreeMap<Integer, HashRange>();
    private ConsistentHashFunction hashFunction;

    public ConsistentHashRing(Collection<? extends HashRingNode> nodes, int virtualNodeCount, int replicationFactor) {
        this.initialize(nodes, virtualNodeCount, replicationFactor, DEFAULT_HASH_FUNCTION);
    }

    public ConsistentHashRing(Collection<? extends HashRingNode> nodes, int virtualNodeCount, int replicationFactor, ConsistentHashFunction hashFunction) {
        this.initialize(nodes, virtualNodeCount, replicationFactor, hashFunction);
    }

    protected ConsistentHashRing() {
    }

    /*
     * WARNING - void declaration
     */
    protected void initialize(Collection<? extends HashRingNode> nodes, int virtualNodeCount, int replicationFactor, ConsistentHashFunction hashFunction) {
        void var8_10;
        Iterator iterator;
        Map.Entry entry;
        this.hashFunction = hashFunction;
        this.replicationFactor = replicationFactor;
        this.nodes = new HashSet<HashRingNode>(nodes);
        ArrayList<? extends HashRingNode> sortedNodes = new ArrayList<HashRingNode>(nodes);
        Collections.sort(sortedNodes);
        TreeMap<Integer, HashRingNode> virtualNodes = new TreeMap<Integer, HashRingNode>();
        for (HashRingNode hashRingNode : sortedNodes) {
            for (int i = 0; i < virtualNodeCount; ++i) {
                String virtualNodeId = this.getVirtualNodeId(hashRingNode, i);
                int hash = this.calculateHash(virtualNodeId);
                virtualNodes.put(hash, hashRingNode);
            }
        }
        if (!virtualNodes.isEmpty() && virtualNodes.get(0) == null) {
            virtualNodes.put(0, (HashRingNode)virtualNodes.get(virtualNodes.lastKey()));
        }
        Map.Entry entry2 = entry = (iterator = virtualNodes.entrySet().iterator()).hasNext() ? iterator.next() : null;
        while (var8_10 != null) {
            Map.Entry next = iterator.hasNext() ? iterator.next() : null;
            int end = next != null ? ((Integer)next.getKey()).intValue() : hashFunction.getHashSpaceSize();
            this.ranges.put((Integer)var8_10.getKey(), new HashRange((Integer)var8_10.getKey(), end, (HashRingNode)var8_10.getValue()));
            Map.Entry entry3 = next;
        }
    }

    public ConsistentHashFunction getHashFunction() {
        return this.hashFunction;
    }

    public Set<HashRingNode> getNodes() {
        return this.nodes;
    }

    public Set<HashRingNode> getReplicaSet(String identifier) {
        return this.getReplicaSet(this.calculateHash(identifier));
    }

    public Set<HashRingNode> getReplicaSet(int hash) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting replica set for hash " + hash));
        }
        HashSet<HashRingNode> result = new HashSet<HashRingNode>();
        int neededReplicas = Math.min(this.replicationFactor, this.nodes.size());
        Integer floorKey = this.ranges.floorKey(hash);
        if (floorKey == null) {
            return result;
        }
        SortedMap<Integer, HashRange> tailMap = this.ranges.tailMap(floorKey);
        this.findReplicas(tailMap, result, neededReplicas);
        if (result.size() >= neededReplicas) {
            return result;
        }
        this.findReplicas(this.ranges, result, neededReplicas);
        return result;
    }

    public RangeList getRanges(HashRingNode node) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (HashRange hashRange : this.ranges.values()) {
            if (!this.getReplicaSet(hashRange.getStart()).contains(node)) continue;
            result.add(hashRange.getRange());
        }
        return new RangeList(result);
    }

    public RangeDiff getRangeDiff(ConsistentHashRing oldRing, HashRingNode node) {
        RangeList newRanges = this.getRanges(node);
        RangeList oldRanges = oldRing.getRanges(node);
        return newRanges.getDiff(oldRanges);
    }

    public Collection<HashRange> getRanges() {
        return Collections.unmodifiableCollection(this.ranges.values());
    }

    public String toString() {
        return this.nodes.toString();
    }

    protected String getVirtualNodeId(HashRingNode node, int virtualNodeIndex) {
        return node.getId() + ":" + virtualNodeIndex;
    }

    private void findReplicas(SortedMap<Integer, HashRange> ranges, Collection<HashRingNode> result, int neededReplicas) {
        if (result.size() >= neededReplicas) {
            return;
        }
        for (HashRange range : ranges.values()) {
            if (!result.contains(range.getNode())) {
                result.add(range.getNode());
            }
            if (result.size() < neededReplicas) continue;
            break;
        }
    }

    private int calculateHash(String identifier) {
        return this.hashFunction.calculateHash(identifier);
    }

    public static class HashRange {
        private Range range;
        private HashRingNode node;

        public HashRange(int start, int end, HashRingNode node) {
            this.range = new Range(start, end);
            this.node = node;
        }

        public Range getRange() {
            return this.range;
        }

        public int getStart() {
            return this.range.getStart();
        }

        public int getEnd() {
            return this.range.getEnd();
        }

        public HashRingNode getNode() {
            return this.node;
        }
    }
}

