/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.consistent;

import com.pingidentity.common.util.consistent.ConsistentHashFunction;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import com.pingidentity.pingcommons.crypto.HashUtil;
import java.math.BigInteger;

public class DigestConsistentHashFunction
implements ConsistentHashFunction {
    private static final long serialVersionUID = 1L;
    private HashAlgorithm baseHashAlgorithm;
    private int hashSpaceSize;

    public DigestConsistentHashFunction(HashAlgorithm baseHashAlgorithm, int hashSpaceSize) {
        this.baseHashAlgorithm = baseHashAlgorithm;
        this.hashSpaceSize = hashSpaceSize;
    }

    @Override
    public int calculateHash(String identifier) {
        if (identifier == null) {
            identifier = "";
        }
        byte[] bytes = HashUtil.hashToBytes((String)identifier, (HashAlgorithm)this.baseHashAlgorithm);
        BigInteger bigInt = new BigInteger(1, bytes);
        BigInteger modulus = bigInt.mod(BigInteger.valueOf(this.hashSpaceSize));
        return modulus.intValue();
    }

    @Override
    public int getHashSpaceSize() {
        return this.hashSpaceSize;
    }
}

