/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.crypto;

import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.jose4j.jwe.kdf.ConcatenationKeyDerivationFunctionWithSha256;

public class BcFipsConcatKeyDerivationFunctionWithSha256
implements ConcatenationKeyDerivationFunctionWithSha256 {
    public byte[] kdf(byte[] sharedSecret, int keydatalen, byte[] otherInfo) {
        FipsKDF.AgreementKDFParameters kdfParams = FipsKDF.CONCATENATION.withPRF(FipsKDF.AgreementKDFPRF.SHA256).using(sharedSecret).withIV(otherInfo);
        FipsKDF.AgreementOperatorFactory agreementOperatorFactory = new FipsKDF.AgreementOperatorFactory();
        KDFCalculator kdfCalculator = agreementOperatorFactory.createKDFCalculator(kdfParams);
        byte[] derivedKeyMaterial = new byte[keydatalen / 8];
        kdfCalculator.generateBytes(derivedKeyMaterial);
        return derivedKeyMaterial;
    }
}

