/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.common.util.PropertyInfo;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.common.VersionUtil;

public class CryptoUtil {
    private static final Log log = LogFactory.getLog(CryptoUtil.class);
    public static final String BLOWFISH_ALGORITHM = "Blowfish";
    public static final String AES_ALGORITHM = "AES";
    private static final String VERSION = "version";
    private static final byte[] HARDCODED_KEY = new byte[]{-85, -17, 27, 47, -54, 15, -110, 5, 123, 32, 37, 104, -108, -122, 98, 45};
    private static final SecretKeySpec aesKeySpec = new SecretKeySpec(HARDCODED_KEY, "AES");
    private static final SecretKeySpec blowfishKeySpec = new SecretKeySpec(HARDCODED_KEY, "Blowfish");

    private CryptoUtil() {
    }

    public static Cipher getCipher(int mode, String algorithm) {
        try {
            SecretKeySpec secretKeySpec = CryptoUtil.getSecretKeySpec(algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(mode, secretKeySpec);
            return cipher;
        }
        catch (Exception e) {
            throw new ObfuscationException("Unable to initialize cipher", e);
        }
    }

    @Deprecated
    public static SecretKeySpec getSecretKeySpec(String algorithm) {
        SecretKeySpec secretKeySpec = null;
        switch (algorithm) {
            case "AES": {
                secretKeySpec = aesKeySpec;
                break;
            }
            case "Blowfish": {
                secretKeySpec = blowfishKeySpec;
                break;
            }
            default: {
                throw new ObfuscationException("Unsupported algorithm: " + algorithm);
            }
        }
        return secretKeySpec;
    }

    public static String obfuscate(String clearText, JsonWebKey jwk) {
        return CryptoUtil.obfuscate(clearText, jwk, false);
    }

    public static String obfuscate(String clearText, JsonWebKey jwk, boolean compress) {
        try {
            return CryptoUtil.jweObfuscate(clearText, jwk, compress);
        }
        catch (JoseException e) {
            throw new ObfuscationException("JSON Web Encryption error", e);
        }
    }

    public static String obfuscateBinary(byte[] clearText, JsonWebKey jwk) {
        try {
            return CryptoUtil.jweObfuscateBinary(clearText, jwk, true);
        }
        catch (JoseException e) {
            throw new ObfuscationException("JSON Web Encryption error", e);
        }
    }

    public static String obfuscateBinary(byte[] clearText, JsonWebKey jwk, boolean compress) {
        try {
            return CryptoUtil.jweObfuscateBinary(clearText, jwk, compress);
        }
        catch (JoseException e) {
            throw new ObfuscationException("JSON Web Encryption error", e);
        }
    }

    @Deprecated
    public static String obfuscate(String clearText, String algorithm) {
        try {
            Cipher cipher = CryptoUtil.getCipher(1, algorithm);
            byte[] obfuscatedBytes = cipher.doFinal(clearText.getBytes("UTF-8"));
            return B64.encode((byte[])obfuscatedBytes);
        }
        catch (Exception e) {
            throw new ObfuscationException("Obfuscating error for algorithm: " + algorithm, e);
        }
    }

    public static String deobfuscate(String obfuscatedText, String algorithm) {
        String clearText = CryptoUtil.doDeobfuscate(obfuscatedText, algorithm);
        if (clearText == null) {
            if (BLOWFISH_ALGORITHM.equals(algorithm)) {
                clearText = CryptoUtil.doDeobfuscate(obfuscatedText, AES_ALGORITHM);
            } else if (!CryptoUtil.isStrictFipsMode()) {
                clearText = CryptoUtil.doDeobfuscate(obfuscatedText, BLOWFISH_ALGORITHM);
            }
        }
        if (clearText == null) {
            throw new ObfuscationException("Unable to deobfuscate text");
        }
        return clearText;
    }

    private static boolean isStrictFipsMode() {
        return PropertyInfo.isBCFIPSMode() && !PropertyInfo.isFipsAllowUnapprovedAlgorithms();
    }

    private static String jweObfuscate(String clearText, JsonWebKey jwk, boolean compress) throws JoseException {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setPlaintext(clearText);
        jwe.setAlgorithmHeaderValue("dir");
        jwe.setEncryptionMethodHeaderParameter("A128CBC-HS256");
        if (compress) {
            jwe.setCompressionAlgorithmHeaderParameter("DEF");
        }
        jwe.setKey(jwk.getKey());
        jwe.setKeyIdHeaderValue(jwk.getKeyId());
        jwe.setHeader(VERSION, VersionUtil.getVersion());
        return jwe.getCompactSerialization();
    }

    private static String jweObfuscateBinary(byte[] clearText, JsonWebKey jwk, boolean compress) throws JoseException {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setPlaintext(clearText);
        jwe.setAlgorithmHeaderValue("dir");
        jwe.setEncryptionMethodHeaderParameter("A128CBC-HS256");
        jwe.setKey(jwk.getKey());
        jwe.setKeyIdHeaderValue(jwk.getKeyId());
        jwe.setHeader(VERSION, VersionUtil.getVersion());
        if (compress) {
            jwe.enableDefaultCompression();
        }
        return jwe.getCompactSerialization();
    }

    public static String jweDeobfuscate(String obfuscatedText, JsonWebKeySet jsonWebKeys) throws JoseException {
        String deobfuscated = null;
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setCompactSerialization(obfuscatedText);
        if (jwe.getKeyIdHeaderValue() != null) {
            JsonWebKey jwk = jsonWebKeys.findJsonWebKey(jwe.getKeyIdHeaderValue(), "oct", null, null);
            if (jwk != null) {
                jwe.setKey(jwk.getKey());
                deobfuscated = jwe.getPlaintextString();
            } else {
                log.warn((Object)("Unable to find key with id: " + jwe.getKeyIdHeaderValue()));
            }
        }
        return deobfuscated;
    }

    public static byte[] jweDeobfuscateBinary(String obfuscatedText, JsonWebKeySet jsonWebKeys) {
        byte[] deobfuscated = null;
        if (StringUtils.isNotEmpty((String)obfuscatedText)) {
            try {
                JsonWebEncryption jwe = new JsonWebEncryption();
                jwe.setCompactSerialization(obfuscatedText);
                if (jwe.getKeyIdHeaderValue() != null) {
                    JsonWebKey jwk = jsonWebKeys.findJsonWebKey(jwe.getKeyIdHeaderValue(), "oct", null, null);
                    if (jwk != null) {
                        jwe.setKey(jwk.getKey());
                        deobfuscated = jwe.getPlaintextBytes();
                    } else {
                        log.warn((Object)("Unable to find key with id: " + jwe.getKeyIdHeaderValue()));
                    }
                }
            }
            catch (JoseException e) {
                log.debug((Object)"Unable to deobfuscate binary data. This is expected for unencrypted file data.");
                log.trace((Object)e);
            }
        }
        return deobfuscated;
    }

    private static String doDeobfuscate(String obfuscatedText, String algorithm) {
        String clearText = null;
        try {
            Cipher cipher = CryptoUtil.getCipher(2, algorithm);
            byte[] obfuscatedBytes = B64.decodeToBytes((String)obfuscatedText);
            clearText = new String(cipher.doFinal(obfuscatedBytes), "UTF-8");
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
        }
        return clearText;
    }
}

