/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.InvalidKeyReferenceException;
import org.sourceid.common.KeyReferenceParser;

public class StringSubstituter {
    private static final Log log = LogFactory.getLog(StringSubstituter.class);
    public static final String PREFIX = "${";
    public static final String SUFFIX = "}";

    public static Set<String> parseReferences(String original) {
        HashSet<String> result = new HashSet<String>();
        if (original != null) {
            int lastIndex = 0;
            while (lastIndex < original.length()) {
                int afterIndex;
                block4: {
                    int beforeIndex = original.indexOf(PREFIX, lastIndex);
                    afterIndex = original.indexOf(SUFFIX, beforeIndex);
                    if (beforeIndex == -1 || afterIndex == -1) break;
                    try {
                        KeyReferenceParser parser = new KeyReferenceParser(original.substring(beforeIndex + 2, afterIndex));
                        result.add(parser.getKey());
                    }
                    catch (InvalidKeyReferenceException e) {
                        if (!log.isDebugEnabled()) break block4;
                        log.debug((Object)e.getMessage());
                    }
                }
                lastIndex = afterIndex + 1;
            }
        }
        return result;
    }

    public static String substituteValues(String original, Map substitutionValuesMap) throws UnRecognizedKeyException {
        return StringSubstituter.substituteValues(original, substitutionValuesMap, false, false);
    }

    public static String substituteValuesTolarateUnkownKey(String original, Map substitutionValuesMap) {
        try {
            return StringSubstituter.substituteValues(original, substitutionValuesMap, true, false);
        }
        catch (UnRecognizedKeyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return original;
        }
    }

    private static String substituteValues(String original, Map substitutionValuesMap, boolean suppressUnknownKey, boolean ignoreDefaultValues) throws UnRecognizedKeyException {
        if (original != null) {
            StringBuilder result = new StringBuilder();
            int lastIndex = 0;
            while (lastIndex < original.length()) {
                String value;
                KeyReferenceParser parser;
                int beforeIndex = original.indexOf(PREFIX, lastIndex);
                int afterIndex = original.indexOf(SUFFIX, beforeIndex);
                if (beforeIndex == -1) {
                    String remainder = original.substring(lastIndex);
                    result.append(remainder);
                    break;
                }
                if (afterIndex == -1) {
                    throw new IncompleteKeyException("Incomplete key at " + original.substring(beforeIndex));
                }
                result.append(original.substring(lastIndex, beforeIndex));
                try {
                    parser = new KeyReferenceParser(original.substring(beforeIndex + PREFIX.length(), afterIndex));
                }
                catch (InvalidKeyReferenceException e) {
                    throw new IncompleteKeyException(e.getMessage());
                }
                if (!(suppressUnknownKey || substitutionValuesMap.containsKey(parser.getKey()) || !ignoreDefaultValues && parser.getDefaultValue() != null)) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Unknown Key (").append(parser.getKey()).append(") found attempting substitution with ");
                    msg.append(substitutionValuesMap).append(" on: ").append(original);
                    throw new UnRecognizedKeyException(msg.toString());
                }
                Object obj = substitutionValuesMap.get(parser.getKey());
                if (obj != null) {
                    value = obj.toString();
                } else if (parser.getDefaultValue() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Key '%s' not found in incoming attributes. Using default value '%s'.", parser.getKey(), parser.getDefaultValue()));
                    }
                    value = parser.getDefaultValue();
                } else {
                    value = "";
                }
                result.append(value);
                lastIndex = afterIndex + 1;
            }
            return result.toString();
        }
        return original;
    }

    protected static String substituteValues(String original, Map substitutionValuesMap, boolean suppressUnknownKey, boolean ignoreDefaultValues, List<String> substitutedParams) throws UnRecognizedKeyException {
        if (original != null) {
            StringBuilder result = new StringBuilder();
            int lastIndex = 0;
            while (lastIndex < original.length()) {
                String value;
                KeyReferenceParser parser;
                int beforeIndex = original.indexOf(PREFIX, lastIndex);
                int afterIndex = original.indexOf(SUFFIX, beforeIndex);
                if (beforeIndex == -1) {
                    String remainder = original.substring(lastIndex);
                    result.append(remainder);
                    break;
                }
                if (afterIndex == -1) {
                    throw new IncompleteKeyException("Incomplete key at " + original.substring(beforeIndex));
                }
                result.append(original.substring(lastIndex, beforeIndex));
                try {
                    parser = new KeyReferenceParser(original.substring(beforeIndex + PREFIX.length(), afterIndex));
                }
                catch (InvalidKeyReferenceException e) {
                    throw new IncompleteKeyException(e.getMessage());
                }
                if (!(suppressUnknownKey || substitutionValuesMap.containsKey(parser.getKey()) || !ignoreDefaultValues && parser.getDefaultValue() != null)) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Unknown Key (").append(parser.getKey()).append(") found attempting substitution with ");
                    msg.append(substitutionValuesMap).append(" on: ").append(original);
                    throw new UnRecognizedKeyException(msg.toString());
                }
                Object obj = substitutionValuesMap.get(parser.getKey());
                if (obj != null) {
                    value = obj.toString();
                } else if (parser.getDefaultValue() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Key '%s' not found in incoming attributes. Using default value '%s'.", parser.getKey(), parser.getDefaultValue()));
                    }
                    value = parser.getDefaultValue();
                } else {
                    value = "";
                }
                substitutedParams.add(value);
                result.append("?");
                lastIndex = afterIndex + 1;
            }
            String resultStr = result.toString();
            resultStr = resultStr.replaceAll("'\\?", "?");
            resultStr = resultStr.replaceAll("\\?'", "?");
            return resultStr;
        }
        return original;
    }

    private static boolean checkSubstituteValues(String original, Map values) {
        try {
            StringSubstituter.substituteValues(original, values, false, true);
            return true;
        }
        catch (UnRecognizedKeyException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
            return false;
        }
    }

    public static boolean checkSubstituteValues(String original, Collection availableVariables) {
        HashMap tempMap = new HashMap();
        for (Object key : availableVariables) {
            tempMap.put(key, "");
        }
        return StringSubstituter.checkSubstituteValues(original, tempMap);
    }

    public static class IncompleteKeyException
    extends UnRecognizedKeyException {
        private static final long serialVersionUID = 1L;

        public IncompleteKeyException(String message) {
            super(message);
        }
    }

    public static class UnRecognizedKeyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnRecognizedKeyException(String msg) {
            super(msg);
        }
    }
}

