/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import com.pingidentity.common.upgrade.Version;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionUtil {
    private static final Log log = LogFactory.getLog(VersionUtil.class);
    private static final String VERSION = "version";
    private static final String version = VersionUtil.loadVersionFromPom();

    private VersionUtil() {
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="introduced by java 11 language level change")
    private static String loadVersionFromPom() {
        String version = null;
        try (InputStream is = VersionUtil.class.getResourceAsStream("/META-INF/maven/pingfederate/pf-commons/pom.properties");){
            if (is != null) {
                Properties pomProperties = new Properties();
                pomProperties.load(is);
                version = pomProperties.getProperty(VERSION);
            }
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage());
        }
        return version;
    }

    public static String getVersion() {
        return version;
    }

    public static int compareProductMajorMinorVersions(String version1, String version2) {
        double version2MajorMinor;
        String[] version1Parts = version1.split("\\.");
        String[] version2Parts = version2.split("\\.");
        int configMajor = Integer.parseInt(version1Parts[0]);
        int configMinor = Integer.parseInt(version1Parts[1]);
        int installMajor = Integer.parseInt(version2Parts[0]);
        int installMinor = Integer.parseInt(version2Parts[1]);
        double version1MajorMinor = Double.parseDouble(configMajor + "." + configMinor);
        if (version1MajorMinor > (version2MajorMinor = Double.parseDouble(installMajor + "." + installMinor))) {
            return 1;
        }
        if (version1MajorMinor < version2MajorMinor) {
            return -1;
        }
        return 0;
    }

    public static boolean isValidVersion(String version) {
        Matcher matcher = Version.versionRegex.matcher(version);
        return matcher.find();
    }
}

