/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.opentoken;

import com.pingidentity.adapters.opentoken.config.ConfigDownloadAction;
import com.pingidentity.adapters.opentoken.config.ConfigValidator;
import com.pingidentity.adapters.opentoken.config.Constants;
import com.pingidentity.adapters.opentoken.config.GuiHelper;
import com.pingidentity.adapters.opentoken.config.PasswordValidator;
import com.pingidentity.opentoken.Agent;
import com.pingidentity.opentoken.AgentConfiguration;
import com.pingidentity.opentoken.TokenException;
import com.pingidentity.opentoken.util.UrlHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;

public abstract class BaseAuthnAdapter
implements ConfigurableAuthnAdapter {
    private static final Log log = LogFactory.getLog(BaseAuthnAdapter.class);
    protected Agent agent;
    protected String logoutService;
    protected GuiHelper helper = new GuiHelper();
    protected static Set<String> DEFAULT_CONTRACT = new HashSet<String>();
    protected int transportMode = 0;
    protected boolean replayPrevention = false;
    protected String transportModeConstant;

    public void configure(Configuration cfg) {
        String sameSiteAttr;
        Field field;
        this.logoutService = cfg.getFieldValue(this.helper.getFieldName("logout.service"));
        this.transportMode = cfg.getIntFieldValue(this.helper.getFieldName(this.transportModeConstant));
        this.replayPrevention = cfg.getBooleanFieldValue(this.helper.getFieldName("replay.prevention"));
        int cipherSuite = -1;
        switch (cfg.getIntFieldValue(this.helper.getFieldName("cipher.suite"))) {
            case 0: {
                cipherSuite = 0;
                break;
            }
            case 1: {
                cipherSuite = 1;
                break;
            }
            case 2: {
                cipherSuite = 2;
                break;
            }
            case 3: {
                cipherSuite = 3;
            }
        }
        String debug = System.getProperty("opentoken.debug");
        if (debug != null && debug.equals("true")) {
            cipherSuite = 0;
        }
        if ((field = cfg.getField(this.helper.getFieldName("cookie.samesite"))) == null) {
            sameSiteAttr = "Nothing";
        } else {
            switch (cfg.getIntFieldValue(this.helper.getFieldName("cookie.samesite"))) {
                case 0: {
                    sameSiteAttr = "Strict";
                    break;
                }
                case 1: {
                    sameSiteAttr = "Lax";
                    break;
                }
                case 2: {
                    sameSiteAttr = "None";
                    break;
                }
                default: {
                    sameSiteAttr = "Nothing";
                }
            }
        }
        AgentConfiguration agentConfiguration = new AgentConfiguration(false);
        agentConfiguration.setTokenName(cfg.getFieldValue(this.helper.getFieldName("token.name")));
        agentConfiguration.setPassword(cfg.getFieldValue(this.helper.getFieldName("password")));
        agentConfiguration.setCipherSuite(cipherSuite);
        agentConfiguration.setUseCookie(this.transportMode == 1);
        agentConfiguration.setCookieDomain(cfg.getFieldValue(this.helper.getFieldName("cookie.domain")));
        agentConfiguration.setCookiePath(cfg.getFieldValue(this.helper.getFieldName("cookie.path")));
        agentConfiguration.setTokenLifetime(cfg.getIntFieldValue(this.helper.getFieldName("token.lifetime")));
        agentConfiguration.setRenewUntilLifetime(cfg.getIntFieldValue(this.helper.getFieldName("renew.until.lifetime")));
        agentConfiguration.setNotBeforeTolerance(cfg.getIntFieldValue(this.helper.getFieldName("token.notbefore.tolerance")));
        agentConfiguration.setUseSunJCE(cfg.getBooleanFieldValue(this.helper.getFieldName("sun.crypto.provider")));
        agentConfiguration.setUseVerboseErrorMessages(cfg.getBooleanFieldValue(this.helper.getFieldName("use.verbose.error.messages")));
        agentConfiguration.setDetectMalformedAttributes(!cfg.getBooleanFieldValue(this.helper.getFieldName("detect.malformed.attributes")));
        agentConfiguration.setRemoveTrailingBackslash(!cfg.getBooleanFieldValue(this.helper.getFieldName("remove.trailing.backslash")));
        agentConfiguration.setObfuscatePassword(true);
        agentConfiguration.setSameSiteCookieAttr(sameSiteAttr);
        agentConfiguration.setSessionCookie(cfg.getBooleanFieldValue(this.helper.getFieldName("session.cookie")));
        agentConfiguration.setSecureCookie(cfg.getBooleanFieldValue(this.helper.getFieldName("secure.cookie")));
        agentConfiguration.setHttpOnly(cfg.getBooleanFieldValue(this.helper.getFieldName("httponly")));
        this.agent = new Agent(agentConfiguration);
    }

    protected AdapterConfigurationGuiDescriptor setupBaseGui() {
        AdapterConfigurationGuiDescriptor gui = new AdapterConfigurationGuiDescriptor("OpenToken Adapter 2.9");
        gui.addValidator((ConfigurationValidator)new PasswordValidator(this.helper.getFieldName("password"), this.helper.getFieldName("confirm.password"), this.helper.getFieldName("obfuscate.password")));
        gui.addValidator((ConfigurationValidator)new ConfigValidator(this.helper));
        this.helper.setAddFieldToAdvanced(false);
        this.helper.addTextField(gui, "password", true, true, 10);
        this.helper.addTextField(gui, "confirm.password", true, true, 10);
        this.helper.setAddFieldToAdvanced(true);
        this.helper.addRadioGroupField(gui, this.transportModeConstant, Constants.TRANSPORT_MODES, true);
        this.helper.addTextField(gui, "token.name", true, 15);
        this.helper.addRadioGroupField(gui, "cipher.suite", Constants.CIPHER_SUITES, false);
        this.helper.addURLField(gui, "logout.service", false, 40);
        this.helper.addRadioGroupField(gui, "cookie.samesite", Constants.COOKIE_SAMESITE_ATTRS, false);
        this.helper.addTextField(gui, "cookie.domain", 15);
        this.helper.addTextField(gui, "cookie.path", false, 10);
        this.helper.addIntField(gui, "token.lifetime", true, 1, 28800);
        this.helper.addIntField(gui, "renew.until.lifetime", true, 1, 259200);
        this.helper.addIntField(gui, "token.notbefore.tolerance", true, 0, 3600);
        this.helper.addCheckboxField(gui, "sun.crypto.provider", false);
        this.helper.addCheckboxField(gui, "use.verbose.error.messages", false);
        this.helper.addCheckboxField(gui, "obfuscate.password", false, true);
        this.helper.addCheckboxField(gui, "session.cookie", false);
        this.helper.addCheckboxField(gui, "secure.cookie", false);
        this.helper.addCheckboxField(gui, "httponly", false);
        gui.addAction(new ActionDescriptor(this.helper.getFieldName("download.action"), this.helper.getFieldDesc("download.action"), "text", "agent-config.txt", (ActionDescriptor.Action)new ConfigDownloadAction(this)));
        return gui;
    }

    protected void writeToken(MultiMap ids, HttpServletResponse resp, UrlHelper targetUrl, boolean doRedirect) throws AuthnAdapterException {
        if (!ids.containsKey((Object)"subject")) {
            ids.put((Object)"subject", (Object)"userId");
        }
        try {
            this.agent.writeToken(ids, resp, targetUrl, doRedirect);
        }
        catch (Exception e) {
            throw new AuthnAdapterException("Error constructing token", (Throwable)e);
        }
    }

    protected String writeToken(MultiMap ids) throws AuthnAdapterException {
        if (!ids.containsKey((Object)"subject")) {
            ids.put((Object)"subject", (Object)"userId");
        }
        try {
            return this.agent.writeToken(ids);
        }
        catch (Exception e) {
            throw new AuthnAdapterException("Error constructing token", (Throwable)e);
        }
    }

    protected MultiMap readToken(HttpServletRequest req, HttpServletResponse resp) {
        try {
            return this.agent.readTokenToMultiMap(req);
        }
        catch (TokenException e) {
            log.error((Object)"Error decoding token", (Throwable)e);
            return null;
        }
    }

    public Agent getAgent() {
        return this.agent;
    }

    Calendar parseDate(String s) throws ParseException {
        Calendar result = Calendar.getInstance(AgentConfiguration.UTC_TZ);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(AgentConfiguration.UTC_TZ);
        result.setTime(formatter.parse(s));
        return result;
    }

    static {
        DEFAULT_CONTRACT.add("subject");
    }
}

